/*     */ package org.jboss.invocation.unified.marshall;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import javax.transaction.SystemException;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.MarshalledInvocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.http.HTTPMarshaller;
/*     */ import org.jboss.tm.TransactionPropagationContextFactory;
/*     */ import org.jboss.tm.TransactionPropagationContextUtil;
/*     */ 
/*     */ public class HTTPInvocationMarshaller extends HTTPMarshaller
/*     */ {
/*     */   static final long serialVersionUID = 1611946070051056241L;
/*     */   public static final String DATATYPE = "invocationhttp";
/*  52 */   private static final Logger log = Logger.getLogger(HTTPInvocationMarshaller.class);
/*     */ 
/*     */   public void write(Object dataObject, OutputStream output, int version)
/*     */     throws IOException
/*     */   {
/*  68 */     if ((dataObject instanceof InvocationRequest))
/*     */     {
/*  70 */       InvocationRequest remoteInv = (InvocationRequest)dataObject;
/*     */ 
/*  72 */       if ((remoteInv.getParameter() instanceof Invocation))
/*     */       {
/*  74 */         Invocation inv = (Invocation)remoteInv.getParameter();
/*     */ 
/*  76 */         MarshalledInvocation marshInv = new MarshalledInvocation(inv);
/*     */ 
/*  78 */         if (inv != null)
/*     */         {
/*     */           try
/*     */           {
/*  86 */             marshInv.setTransactionPropagationContext(getTransactionPropagationContext());
/*     */           }
/*     */           catch (SystemException e)
/*     */           {
/*  90 */             log.error("Error setting transaction propagation context.", e);
/*  91 */             throw new IOException("Error setting transaction context.  Message: " + e.getMessage());
/*     */           }
/*     */ 
/*  95 */           remoteInv.setParameter(marshInv);
/*     */         }
/*     */         else
/*     */         {
/* 100 */           log.error("Attempting to marshall Invocation but is null.  Can not proceed.");
/* 101 */           throw new IOException("Can not process data object due to the InvocationRequest's parameter being null.");
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 106 */       super.write(dataObject, output, version);
/*     */     }
/*     */     else
/*     */     {
/* 111 */       super.write(dataObject, output);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getTransactionPropagationContext()
/*     */     throws SystemException
/*     */   {
/* 118 */     TransactionPropagationContextFactory tpcFactory = TransactionPropagationContextUtil.getTPCFactoryClientSide();
/* 119 */     return tpcFactory == null ? null : tpcFactory.getTransactionPropagationContext();
/*     */   }
/*     */ 
/*     */   public Marshaller cloneMarshaller() throws CloneNotSupportedException
/*     */   {
/* 124 */     return new HTTPInvocationMarshaller();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.unified.marshall.HTTPInvocationMarshaller
 * JD-Core Version:    0.6.0
 */