/*     */ package org.jboss.invocation.pooled.interfaces;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.Serializable;
/*     */ import javax.net.SocketFactory;
/*     */ 
/*     */ public class ServerAddress
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -7206359745950445445L;
/*     */   public String address;
/*     */   public int port;
/*  60 */   public boolean enableTcpNoDelay = false;
/*     */ 
/*  66 */   public int timeout = 60000;
/*     */   public SocketFactory clientSocketFactory;
/*     */   private transient int hashCode;
/*     */ 
/*     */   public ServerAddress(String address, int port, boolean enableTcpNoDelay, int timeout, SocketFactory clientSocketFactory)
/*     */   {
/*  90 */     this.address = address;
/*  91 */     this.port = port;
/*  92 */     this.enableTcpNoDelay = enableTcpNoDelay;
/*  93 */     this.hashCode = (address.hashCode() + port);
/*  94 */     if (enableTcpNoDelay)
/*  95 */       this.hashCode += 1;
/*  96 */     this.timeout = timeout;
/*  97 */     this.clientSocketFactory = clientSocketFactory;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 102 */     return "[address:" + this.address + ",port:" + this.port + ",enableTcpNoDelay:" + this.enableTcpNoDelay + "]";
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*     */     try
/*     */     {
/* 110 */       ServerAddress o = (ServerAddress)obj;
/* 111 */       if (this.port != o.port)
/* 112 */         return false;
/* 113 */       if (!this.address.equals(o.address)) {
/* 114 */         return false;
/*     */       }
/* 116 */       return this.enableTcpNoDelay == o.enableTcpNoDelay;
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*     */     }
/*     */ 
/* 121 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 127 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 140 */     in.defaultReadObject();
/*     */ 
/* 142 */     this.hashCode = (this.address.hashCode() + this.port);
/* 143 */     if (this.enableTcpNoDelay)
/* 144 */       this.hashCode += 1;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.pooled.interfaces.ServerAddress
 * JD-Core Version:    0.6.0
 */