/*     */ package org.jboss.invocation.pooled.interfaces;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.Principal;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.invocation.MarshalledInvocation;
/*     */ import org.jboss.invocation.MarshalledValue;
/*     */ 
/*     */ public class PooledMarshalledInvocation extends MarshalledInvocation
/*     */   implements Externalizable
/*     */ {
/*     */   static final long serialVersionUID = -728630295444149842L;
/*     */   private transient Transaction tx;
/*     */   private transient Object credential;
/*     */   private transient Principal principal;
/*     */   private transient Object enterpriseContext;
/*     */   private transient Object id;
/*     */   private transient PooledMarshalledValue pooledMarshalledArgs;
/*     */ 
/*     */   public PooledMarshalledInvocation()
/*     */   {
/*     */   }
/*     */ 
/*     */   public PooledMarshalledInvocation(Invocation invocation)
/*     */   {
/*  74 */     this.payload = invocation.payload;
/*  75 */     this.as_is_payload = invocation.as_is_payload;
/*  76 */     this.method = invocation.getMethod();
/*  77 */     this.objectName = invocation.getObjectName();
/*  78 */     this.args = invocation.getArguments();
/*  79 */     this.invocationType = invocation.getType();
/*     */   }
/*     */ 
/*     */   public PooledMarshalledInvocation(Object id, Method m, Object[] args, Transaction tx, Principal identity, Object credential)
/*     */   {
/* 103 */     super(id, m, args, tx, identity, credential);
/*     */   }
/*     */ 
/*     */   public Object getEnterpriseContext()
/*     */   {
/* 111 */     return this.enterpriseContext;
/*     */   }
/*     */ 
/*     */   public void setEnterpriseContext(Object enterpriseContext)
/*     */   {
/* 116 */     this.enterpriseContext = enterpriseContext;
/*     */   }
/*     */ 
/*     */   public Object getId()
/*     */   {
/* 121 */     if (this.id == null) this.id = super.getId();
/* 122 */     return this.id;
/*     */   }
/*     */ 
/*     */   public void setId(Object id)
/*     */   {
/* 127 */     super.setId(id);
/* 128 */     this.id = id;
/*     */   }
/*     */ 
/*     */   public void setTransaction(Transaction tx)
/*     */   {
/* 133 */     super.setTransaction(tx);
/* 134 */     this.tx = tx;
/*     */   }
/*     */ 
/*     */   public Transaction getTransaction()
/*     */   {
/* 139 */     if (this.tx == null) this.tx = super.getTransaction();
/* 140 */     return this.tx;
/*     */   }
/*     */ 
/*     */   public Object getCredential()
/*     */   {
/* 145 */     if (this.credential == null) this.credential = super.getCredential();
/* 146 */     return this.credential;
/*     */   }
/*     */ 
/*     */   public void setCredential(Object credential)
/*     */   {
/* 151 */     super.setCredential(credential);
/* 152 */     this.credential = credential;
/*     */   }
/*     */ 
/*     */   public Principal getPrincipal()
/*     */   {
/* 157 */     if (this.principal == null) this.principal = super.getPrincipal();
/* 158 */     return this.principal;
/*     */   }
/*     */ 
/*     */   public void setPrincipal(Principal principal)
/*     */   {
/* 163 */     super.setPrincipal(principal);
/* 164 */     this.principal = principal;
/*     */   }
/*     */ 
/*     */   public Object[] getArguments()
/*     */   {
/* 170 */     if (this.args == null)
/*     */     {
/*     */       try
/*     */       {
/* 174 */         this.args = ((Object[])(Object[])this.pooledMarshalledArgs.get());
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 178 */         e.printStackTrace();
/*     */       }
/*     */     }
/* 181 */     return this.args;
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 188 */     out.writeObject(this.invocationType);
/*     */ 
/* 191 */     out.writeObject(this.tpc);
/*     */ 
/* 193 */     long methodHash = calculateHash(this.method);
/* 194 */     out.writeLong(methodHash);
/*     */ 
/* 196 */     out.writeInt(((Integer)this.objectName).intValue());
/* 197 */     out.writeObject(new PooledMarshalledValue(this.args));
/*     */ 
/* 208 */     if (this.payload == null) {
/* 209 */       out.writeInt(0);
/*     */     }
/*     */     else {
/* 212 */       out.writeInt(this.payload.size());
/* 213 */       Iterator keys = this.payload.keySet().iterator();
/* 214 */       while (keys.hasNext())
/*     */       {
/* 216 */         Object currentKey = keys.next();
/*     */ 
/* 221 */         out.writeObject(currentKey);
/* 222 */         out.writeObject(new MarshalledValue(this.payload.get(currentKey)));
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 228 */     if (this.as_is_payload == null) {
/* 229 */       out.writeInt(0);
/*     */     }
/*     */     else {
/* 232 */       out.writeInt(this.as_is_payload.size());
/*     */ 
/* 234 */       Iterator keys = this.as_is_payload.keySet().iterator();
/* 235 */       while (keys.hasNext())
/*     */       {
/* 237 */         Object currentKey = keys.next();
/* 238 */         out.writeObject(currentKey);
/* 239 */         out.writeObject(this.as_is_payload.get(currentKey));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 247 */     this.invocationType = ((InvocationType)in.readObject());
/* 248 */     this.tpc = in.readObject();
/* 249 */     this.methodHash = in.readLong();
/*     */ 
/* 251 */     this.objectName = new Integer(in.readInt());
/*     */ 
/* 253 */     this.pooledMarshalledArgs = ((PooledMarshalledValue)in.readObject());
/*     */ 
/* 255 */     int payloadSize = in.readInt();
/* 256 */     if (payloadSize > 0)
/*     */     {
/* 258 */       this.payload = new HashMap();
/* 259 */       for (int i = 0; i < payloadSize; i++)
/*     */       {
/* 261 */         Object key = in.readObject();
/* 262 */         Object value = in.readObject();
/* 263 */         this.payload.put(key, value);
/*     */       }
/*     */     }
/*     */ 
/* 267 */     int as_is_payloadSize = in.readInt();
/* 268 */     if (as_is_payloadSize > 0)
/*     */     {
/* 270 */       this.as_is_payload = new HashMap();
/* 271 */       for (int i = 0; i < as_is_payloadSize; i++)
/*     */       {
/* 273 */         Object key = in.readObject();
/* 274 */         Object value = in.readObject();
/* 275 */         this.as_is_payload.put(key, value);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.pooled.interfaces.PooledMarshalledInvocation
 * JD-Core Version:    0.6.0
 */