/*     */ package org.jboss.invocation.local;
/*     */ 
/*     */ import java.net.InetAddress;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.Invoker;
/*     */ import org.jboss.invocation.InvokerInterceptor;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.JMXExceptionDecoder;
/*     */ import org.jboss.proxy.TransactionInterceptor;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class LocalInvoker extends ServiceMBeanSupport
/*     */   implements Invoker, LocalInvokerMBean
/*     */ {
/*     */   private MBeanServerAction serverAction;
/*     */ 
/*     */   public LocalInvoker()
/*     */   {
/*  53 */     this.serverAction = new MBeanServerAction();
/*     */   }
/*     */ 
/*     */   protected void createService()
/*     */     throws Exception
/*     */   {
/*  63 */     InvokerInterceptor.setLocal(this);
/*     */ 
/*  65 */     Registry.bind(this.serviceName, this);
/*     */   }
/*     */ 
/*     */   protected void startService() throws Exception
/*     */   {
/*  70 */     InitialContext ctx = new InitialContext();
/*     */     try
/*     */     {
/*  77 */       TransactionManager tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
/*  78 */       TransactionInterceptor.setTransactionManager(tm);
/*     */     }
/*     */     finally
/*     */     {
/*  82 */       ctx.close();
/*     */     }
/*     */ 
/*  85 */     this.log.debug("Local invoker for JMX node started");
/*     */   }
/*     */ 
/*     */   protected void destroyService()
/*     */   {
/*  90 */     Registry.unbind(this.serviceName);
/*     */   }
/*     */ 
/*     */   public String getServerHostName()
/*     */   {
/*     */     try
/*     */     {
/*  99 */       return InetAddress.getLocalHost().getHostName();
/*     */     }
/*     */     catch (Exception ignored) {
/*     */     }
/* 103 */     return null;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Exception
/*     */   {
/* 112 */     ClassLoader oldCl = LocalInvoker.TCLAction.UTIL.getContextClassLoader();
/*     */ 
/* 114 */     ObjectName mbean = (ObjectName)Registry.lookup((Integer)invocation.getObjectName());
/*     */     try
/*     */     {
/* 117 */       Object[] args = { invocation };
/* 118 */       Object rtnValue = this.serverAction.invoke(mbean, "invoke", args, Invocation.INVOKE_SIGNATURE);
/*     */ 
/* 120 */       localObject1 = rtnValue;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */       Object localObject1;
/* 124 */       e = (Exception)JMXExceptionDecoder.decode(e);
/* 125 */       if (this.log.isTraceEnabled())
/* 126 */         this.log.trace("Failed to invoke on mbean: " + mbean, e);
/* 127 */       throw e;
/*     */     }
/*     */     finally
/*     */     {
/* 131 */       LocalInvoker.TCLAction.UTIL.setContextClassLoader(oldCl);
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface TCLAction
/*     */   {
/* 219 */     public static final TCLAction NON_PRIVILEGED = new TCLAction()
/*     */     {
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 223 */         return Thread.currentThread().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 228 */         return thread.getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 233 */         Thread.currentThread().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 238 */         thread.setContextClassLoader(cl);
/*     */       }
/* 219 */     };
/*     */ 
/* 242 */     public static final TCLAction PRIVILEGED = new TCLAction()
/*     */     {
/* 244 */       private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 248 */           return Thread.currentThread().getContextClassLoader();
/*     */         }
/* 244 */       };
/*     */ 
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 254 */         return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 259 */         return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(thread)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 263 */             return this.val$thread.getContextClassLoader();
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl) {
/* 270 */         AccessController.doPrivileged(new PrivilegedAction(cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 275 */             Thread.currentThread().setContextClassLoader(this.val$cl);
/* 276 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 284 */         AccessController.doPrivileged(new PrivilegedAction(thread, cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 289 */             this.val$thread.setContextClassLoader(this.val$cl);
/* 290 */             return null;
/*     */           }
/*     */         });
/*     */       }
/* 242 */     };
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader();
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader(Thread paramThread);
/*     */ 
/*     */     public abstract void setContextClassLoader(ClassLoader paramClassLoader);
/*     */ 
/*     */     public abstract void setContextClassLoader(Thread paramThread, ClassLoader paramClassLoader);
/*     */ 
/*     */     public static class UTIL
/*     */     {
/*     */       static LocalInvoker.TCLAction getTCLAction()
/*     */       {
/* 195 */         return System.getSecurityManager() == null ? LocalInvoker.TCLAction.NON_PRIVILEGED : LocalInvoker.TCLAction.PRIVILEGED;
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader()
/*     */       {
/* 200 */         return getTCLAction().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 205 */         return getTCLAction().getContextClassLoader(thread);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 210 */         getTCLAction().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 215 */         getTCLAction().setContextClassLoader(thread, cl);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   class MBeanServerAction
/*     */     implements PrivilegedExceptionAction
/*     */   {
/*     */     private ObjectName target;
/*     */     String method;
/*     */     Object[] args;
/*     */     String[] sig;
/*     */ 
/*     */     MBeanServerAction()
/*     */     {
/*     */     }
/*     */ 
/*     */     MBeanServerAction(ObjectName target, String method, Object[] args, String[] sig)
/*     */     {
/* 150 */       this.target = target;
/* 151 */       this.method = method;
/* 152 */       this.args = args;
/* 153 */       this.sig = sig;
/*     */     }
/*     */ 
/*     */     public Object run() throws Exception
/*     */     {
/* 158 */       Object rtnValue = LocalInvoker.this.server.invoke(this.target, this.method, this.args, this.sig);
/* 159 */       return rtnValue;
/*     */     }
/*     */ 
/*     */     Object invoke(ObjectName target, String method, Object[] args, String[] sig) throws Exception
/*     */     {
/* 164 */       SecurityManager sm = System.getSecurityManager();
/* 165 */       Object rtnValue = null;
/* 166 */       if (sm == null)
/*     */       {
/* 169 */         rtnValue = LocalInvoker.this.server.invoke(target, method, args, sig);
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/* 176 */           MBeanServerAction action = new MBeanServerAction(LocalInvoker.this, target, method, args, sig);
/* 177 */           rtnValue = AccessController.doPrivileged(action);
/*     */         }
/*     */         catch (PrivilegedActionException e)
/*     */         {
/* 181 */           Exception ex = e.getException();
/* 182 */           throw ex;
/*     */         }
/*     */       }
/* 185 */       return rtnValue;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.local.LocalInvoker
 * JD-Core Version:    0.6.0
 */