/*     */ package org.jboss.invocation.jrmp.server;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvokerInterceptor;
/*     */ import org.jboss.invocation.MarshalledInvocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.naming.Util;
/*     */ import org.jboss.proxy.ClientMethodInterceptor;
/*     */ import org.jboss.proxy.GenericProxyFactory;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class JRMPProxyFactory extends ServiceMBeanSupport
/*     */   implements JRMPProxyFactoryMBean
/*     */ {
/*     */   private ObjectName invokerName;
/*     */   private ObjectName targetName;
/*     */   protected Object theProxy;
/*     */   private String jndiName;
/*     */   private Class[] exportedInterfaces;
/*     */   private Element interceptorConfig;
/*  68 */   private ArrayList interceptorClasses = new ArrayList();
/*     */   private boolean invokeTargetMethod;
/*  72 */   private final Map methodMap = new HashMap();
/*     */ 
/*  74 */   private final Map signatureMap = new HashMap();
/*     */ 
/*     */   public JRMPProxyFactory()
/*     */   {
/*  78 */     this.interceptorClasses.add(ClientMethodInterceptor.class);
/*  79 */     this.interceptorClasses.add(InvokerInterceptor.class);
/*     */   }
/*     */ 
/*     */   public ObjectName getInvokerName()
/*     */   {
/*  84 */     return this.invokerName;
/*     */   }
/*     */ 
/*     */   public void setInvokerName(ObjectName invokerName) {
/*  88 */     this.invokerName = invokerName;
/*     */   }
/*     */ 
/*     */   public ObjectName getTargetName()
/*     */   {
/*  93 */     return this.targetName;
/*     */   }
/*     */ 
/*     */   public void setTargetName(ObjectName targetName) {
/*  97 */     this.targetName = targetName;
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/* 102 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName) {
/* 106 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public Class getExportedInterface()
/*     */   {
/* 111 */     return this.exportedInterfaces[0];
/*     */   }
/*     */ 
/*     */   public void setExportedInterface(Class exportedInterface) {
/* 115 */     this.exportedInterfaces = new Class[] { exportedInterface };
/*     */   }
/*     */ 
/*     */   public Class[] getExportedInterfaces()
/*     */   {
/* 120 */     return this.exportedInterfaces;
/*     */   }
/*     */ 
/*     */   public void setExportedInterfaces(Class[] exportedInterfaces) {
/* 124 */     this.exportedInterfaces = exportedInterfaces;
/*     */   }
/*     */ 
/*     */   public boolean getInvokeTargetMethod()
/*     */   {
/* 129 */     return this.invokeTargetMethod;
/*     */   }
/*     */ 
/*     */   public void setInvokeTargetMethod(boolean invokeTargetMethod)
/*     */   {
/* 134 */     this.invokeTargetMethod = invokeTargetMethod;
/*     */   }
/*     */ 
/*     */   public Element getClientInterceptors()
/*     */   {
/* 139 */     return this.interceptorConfig;
/*     */   }
/*     */ 
/*     */   public void setClientInterceptors(Element config) throws Exception {
/* 143 */     this.interceptorConfig = config;
/* 144 */     Iterator interceptorElements = MetaData.getChildrenByTagName(this.interceptorConfig, "interceptor");
/* 145 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 146 */     this.interceptorClasses.clear();
/* 147 */     while ((interceptorElements != null) && (interceptorElements.hasNext()))
/*     */     {
/* 149 */       Element ielement = (Element)interceptorElements.next();
/* 150 */       String className = null;
/* 151 */       className = MetaData.getElementContent(ielement);
/* 152 */       Class clazz = loader.loadClass(className);
/* 153 */       this.interceptorClasses.add(clazz);
/* 154 */       this.log.debug("added interceptor type: " + clazz);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getProxy()
/*     */   {
/* 160 */     return this.theProxy;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation mi) throws Exception
/*     */   {
/* 165 */     boolean remoteInvocation = mi instanceof MarshalledInvocation;
/* 166 */     if (remoteInvocation)
/*     */     {
/* 168 */       ((MarshalledInvocation)mi).setMethodMap(this.methodMap);
/*     */     }
/*     */     Object result;
/*     */     Object result;
/* 172 */     if (this.invokeTargetMethod)
/*     */     {
/* 174 */       String[] signature = (String[])(String[])this.signatureMap.get(mi.getMethod());
/* 175 */       result = this.server.invoke(this.targetName, mi.getMethod().getName(), mi.getArguments(), signature);
/*     */     }
/*     */     else
/*     */     {
/* 179 */       result = this.server.invoke(this.targetName, "invoke", new Object[] { mi }, Invocation.INVOKE_SIGNATURE);
/*     */     }
/*     */ 
/* 182 */     return result;
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 193 */     Integer nameHash = new Integer(getServiceName().hashCode());
/* 194 */     Registry.bind(nameHash, getServiceName());
/*     */ 
/* 197 */     Object cacheID = null;
/* 198 */     String proxyBindingName = null;
/* 199 */     Class[] ifaces = this.exportedInterfaces;
/* 200 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 201 */     createProxy(cacheID, proxyBindingName, loader, ifaces);
/* 202 */     this.log.debug("Created JRMPPRoxy for service=" + this.targetName + ", nameHash=" + nameHash + ", invoker=" + this.invokerName);
/*     */ 
/* 205 */     if (this.jndiName != null)
/*     */     {
/* 207 */       InitialContext iniCtx = new InitialContext();
/* 208 */       Util.bind(iniCtx, this.jndiName, this.theProxy);
/* 209 */       this.log.debug("Bound proxy under jndiName=" + this.jndiName);
/*     */     }
/*     */ 
/* 212 */     for (int i = 0; i < this.exportedInterfaces.length; i++)
/*     */     {
/* 214 */       Method[] methods = this.exportedInterfaces[i].getMethods();
/* 215 */       for (int j = 0; j < methods.length; j++)
/*     */       {
/* 217 */         this.methodMap.put(new Long(MarshalledInvocation.calculateHash(methods[j])), methods[j]);
/*     */ 
/* 220 */         Class[] types = methods[j].getParameterTypes();
/*     */         String[] signature;
/*     */         String[] signature;
/* 221 */         if ((types == null) || (types.length == 0))
/*     */         {
/* 223 */           signature = null;
/*     */         }
/*     */         else
/*     */         {
/* 227 */           signature = new String[types.length];
/* 228 */           for (int typeInd = 0; typeInd < types.length; typeInd++)
/*     */           {
/* 230 */             signature[typeInd] = types[typeInd].getName();
/*     */           }
/*     */         }
/* 233 */         this.signatureMap.put(methods[j], signature);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 240 */     Integer nameHash = new Integer(getServiceName().hashCode());
/* 241 */     Registry.unbind(nameHash);
/* 242 */     if (this.jndiName != null)
/*     */     {
/* 244 */       InitialContext iniCtx = new InitialContext();
/* 245 */       Util.unbind(iniCtx, this.jndiName);
/*     */     }
/* 247 */     this.theProxy = null;
/*     */   }
/*     */ 
/*     */   protected void destroyService() throws Exception
/*     */   {
/* 252 */     this.interceptorClasses.clear();
/*     */   }
/*     */ 
/*     */   protected void createProxy(Object cacheID, String proxyBindingName, ClassLoader loader, Class[] ifaces)
/*     */   {
/* 263 */     GenericProxyFactory proxyFactory = new GenericProxyFactory();
/* 264 */     this.theProxy = proxyFactory.createProxy(cacheID, getServiceName(), this.invokerName, this.jndiName, proxyBindingName, this.interceptorClasses, loader, ifaces);
/*     */   }
/*     */ 
/*     */   protected void rebind()
/*     */     throws Exception
/*     */   {
/* 270 */     this.log.debug("(re-)Binding " + this.jndiName);
/* 271 */     Util.rebind(new InitialContext(), this.jndiName, this.theProxy);
/*     */   }
/*     */ 
/*     */   protected ArrayList getInterceptorClasses()
/*     */   {
/* 276 */     return this.interceptorClasses;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.jrmp.server.JRMPProxyFactory
 * JD-Core Version:    0.6.0
 */