/*     */ package org.jboss.invocation.jrmp.interfaces;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.rmi.ConnectException;
/*     */ import java.rmi.MarshalledObject;
/*     */ import java.rmi.NoSuchObjectException;
/*     */ import java.rmi.RemoteException;
/*     */ import java.rmi.ServerException;
/*     */ import java.rmi.server.RemoteObject;
/*     */ import java.rmi.server.RemoteStub;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.TransactionRolledbackException;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.Invoker;
/*     */ import org.jboss.invocation.MarshalledInvocation;
/*     */ import org.jboss.tm.TransactionPropagationContextFactory;
/*     */ import org.jboss.tm.TransactionPropagationContextUtil;
/*     */ 
/*     */ public class JRMPInvokerProxy
/*     */   implements Invoker, Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = -3713605626489646730L;
/*     */   protected Invoker remoteInvoker;
/*  65 */   public static int MAX_RETRIES = 10;
/*     */ 
/*     */   public JRMPInvokerProxy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public JRMPInvokerProxy(Invoker remoteInvoker)
/*     */   {
/*  83 */     this.remoteInvoker = remoteInvoker;
/*     */   }
/*     */ 
/*     */   public String getServerHostName()
/*     */     throws Exception
/*     */   {
/*  91 */     return this.remoteInvoker.getServerHostName();
/*     */   }
/*     */ 
/*     */   public Object getTransactionPropagationContext()
/*     */     throws SystemException
/*     */   {
/* 107 */     TransactionPropagationContextFactory tpcFactory = TransactionPropagationContextUtil.getTPCFactoryClientSide();
/* 108 */     return tpcFactory == null ? null : tpcFactory.getTransactionPropagationContext();
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Exception
/*     */   {
/* 120 */     MarshalledInvocation mi = new MarshalledInvocation(invocation);
/*     */ 
/* 124 */     mi.setTransactionPropagationContext(getTransactionPropagationContext());
/*     */ 
/* 129 */     for (int i = 0; i < MAX_RETRIES; i++)
/*     */     {
/*     */       try
/*     */       {
/* 133 */         MarshalledObject result = (MarshalledObject)this.remoteInvoker.invoke(mi);
/* 134 */         return result.get();
/*     */       }
/*     */       catch (ConnectException ce)
/*     */       {
/* 138 */         if (i + 1 < MAX_RETRIES)
/*     */         {
/* 140 */           Thread.sleep(1L);
/*     */         }
/*     */         else {
/* 143 */           throw ce;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (ServerException ex)
/*     */       {
/* 150 */         if ((ex.detail instanceof NoSuchObjectException))
/*     */         {
/* 152 */           throw ((NoSuchObjectException)ex.detail);
/*     */         }
/* 154 */         if ((ex.detail instanceof TransactionRolledbackException))
/*     */         {
/* 156 */           throw ((TransactionRolledbackException)ex.detail);
/*     */         }
/* 158 */         if ((ex.detail instanceof RemoteException))
/*     */         {
/* 160 */           throw ((RemoteException)ex.detail);
/*     */         }
/* 162 */         throw ex;
/*     */       }
/*     */     }
/* 165 */     throw new Exception("Unreachable statement");
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 178 */     if ((this.remoteInvoker instanceof RemoteStub))
/*     */     {
/* 180 */       out.writeObject(this.remoteInvoker);
/*     */     }
/*     */     else
/*     */     {
/* 184 */       Object replacement = RemoteObject.toStub(this.remoteInvoker);
/* 185 */       out.writeObject(replacement);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 196 */     this.remoteInvoker = ((Externalizable)in.readObject());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.jrmp.interfaces.JRMPInvokerProxy
 * JD-Core Version:    0.6.0
 */