/*    */ package org.jboss.invocation.iiop;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.Serializable;
/*    */ import org.jboss.util.Conversion;
/*    */ 
/*    */ public class ReferenceData
/*    */   implements Serializable
/*    */ {
/*    */   private Object servantId;
/*    */   private Object objectId;
/*    */ 
/*    */   public static byte[] create(Object servantId, Object objectId)
/*    */   {
/* 47 */     return Conversion.toByteArray(new ReferenceData(servantId, objectId));
/*    */   }
/*    */ 
/*    */   public static byte[] create(Object id)
/*    */   {
/* 52 */     return Conversion.toByteArray(id);
/*    */   }
/*    */ 
/*    */   public static Object extractServantId(byte[] refData, ClassLoader cl)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 58 */     Object obj = Conversion.toObject(refData, cl);
/* 59 */     if ((obj != null) && ((obj instanceof ReferenceData))) {
/* 60 */       return ((ReferenceData)obj).servantId;
/*    */     }
/* 62 */     return obj;
/*    */   }
/*    */ 
/*    */   public static Object extractServantId(byte[] refData)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 68 */     return extractServantId(refData, Thread.currentThread().getContextClassLoader());
/*    */   }
/*    */ 
/*    */   public static Object extractObjectId(byte[] refData, ClassLoader cl)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 75 */     Object obj = Conversion.toObject(refData, cl);
/* 76 */     if ((obj != null) && ((obj instanceof ReferenceData))) {
/* 77 */       return ((ReferenceData)obj).objectId;
/*    */     }
/* 79 */     return obj;
/*    */   }
/*    */ 
/*    */   public static Object extractObjectId(byte[] refData)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 85 */     return extractObjectId(refData, Thread.currentThread().getContextClassLoader());
/*    */   }
/*    */ 
/*    */   private ReferenceData(Object servantId, Object objectId)
/*    */   {
/* 91 */     this.servantId = servantId;
/* 92 */     this.objectId = objectId;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.iiop.ReferenceData
 * JD-Core Version:    0.6.0
 */