/*     */ package org.jboss.invocation.iiop;
/*     */ 
/*     */ import java.net.InetAddress;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Map;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ import org.jboss.iiop.CorbaORBService;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.Util;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.omg.CORBA.LocalObject;
/*     */ import org.omg.CORBA.Policy;
/*     */ import org.omg.CORBA.SetOverrideType;
/*     */ import org.omg.CORBA.UNKNOWN;
/*     */ import org.omg.PortableServer.IdAssignmentPolicyValue;
/*     */ import org.omg.PortableServer.IdUniquenessPolicyValue;
/*     */ import org.omg.PortableServer.LifespanPolicyValue;
/*     */ import org.omg.PortableServer.POA;
/*     */ import org.omg.PortableServer.POAManager;
/*     */ import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
/*     */ import org.omg.PortableServer.RequestProcessingPolicyValue;
/*     */ import org.omg.PortableServer.Servant;
/*     */ import org.omg.PortableServer.ServantLocator;
/*     */ import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
/*     */ import org.omg.PortableServer.ServantRetentionPolicyValue;
/*     */ 
/*     */ public class IIOPInvoker extends ServiceMBeanSupport
/*     */   implements IIOPInvokerMBean, ServantRegistries, ObjectFactory
/*     */ {
/*     */   private static IIOPInvoker theIIOPInvoker;
/*     */   private POA rootPOA;
/*     */   private ServantRegistry registryWithSharedTransientPOA;
/*     */   private POA transientPOA;
/*     */   private Map transientServantMap;
/*     */   private ServantRegistry registryWithSharedPersistentPOA;
/*     */   private POA persistentPOA;
/*     */   private Map persistentServantMap;
/*     */   private ServantRegistry registryWithTransientPOAPerServant;
/*     */   private Map transientPoaMap;
/*     */   private Policy[] transientPoaPolicies;
/*     */   private ServantRegistry registryWithPersistentPOAPerServant;
/*     */   private Map persistentPoaMap;
/*     */   private Policy[] persistentPoaPolicies;
/*     */ 
/*     */   public void createService()
/*     */     throws Exception
/*     */   {
/* 132 */     theIIOPInvoker = this;
/* 133 */     this.transientServantMap = Collections.synchronizedMap(new HashMap());
/* 134 */     this.persistentServantMap = Collections.synchronizedMap(new HashMap());
/* 135 */     this.transientPoaMap = Collections.synchronizedMap(new HashMap());
/* 136 */     this.persistentPoaMap = Collections.synchronizedMap(new HashMap());
/*     */   }
/*     */ 
/*     */   public void startService()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 144 */       this.rootPOA = ((POA)new InitialContext().lookup("java:/" + CorbaORBService.POA_NAME));
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 148 */       throw new RuntimeException("Cannot lookup java:/" + CorbaORBService.POA_NAME + ": " + e);
/*     */     }
/*     */ 
/* 153 */     this.transientPoaPolicies = new Policy[] { this.rootPOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT), this.rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), this.rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), this.rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT), this.rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID) };
/*     */ 
/* 167 */     this.persistentPoaPolicies = new Policy[] { this.rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), this.rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), this.rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), this.rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT), this.rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID) };
/*     */ 
/* 181 */     Policy[] policies = { this.rootPOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT), this.rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), this.rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), this.rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER), this.rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID) };
/*     */ 
/* 196 */     this.transientPOA = this.rootPOA.create_POA("TPOA", null, policies);
/* 197 */     this.transientPOA.set_servant_manager(new TransientServantLocator());
/*     */ 
/* 200 */     policies[0] = this.rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT);
/*     */ 
/* 205 */     this.persistentPOA = this.rootPOA.create_POA("PPOA", null, policies);
/* 206 */     this.persistentPOA.set_servant_manager(new PersistentServantLocator());
/*     */ 
/* 209 */     this.registryWithSharedTransientPOA = new ServantRegistryWithSharedTransientPOA();
/*     */ 
/* 211 */     this.registryWithSharedPersistentPOA = new ServantRegistryWithSharedPersistentPOA();
/*     */ 
/* 213 */     this.registryWithTransientPOAPerServant = new ServantRegistryWithTransientPOAPerServant();
/*     */ 
/* 215 */     this.registryWithPersistentPOAPerServant = new ServantRegistryWithPersistentPOAPerServant();
/*     */ 
/* 219 */     Registry.bind(getServiceName(), this);
/*     */ 
/* 222 */     this.transientPOA.the_POAManager().activate();
/* 223 */     this.persistentPOA.the_POAManager().activate();
/*     */ 
/* 225 */     Context context = new InitialContext();
/*     */ 
/* 228 */     Util.rebind(context, "invokers/" + InetAddress.getLocalHost().getHostName() + "/iiop", new Reference(getClass().getName(), getClass().getName(), null));
/*     */ 
/* 238 */     getLog().debug("Bound IIOP invoker for JMX node");
/*     */   }
/*     */ 
/*     */   public void stopService()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 246 */       this.transientPOA.the_POAManager().deactivate(false, true);
/*     */ 
/* 249 */       this.persistentPOA.the_POAManager().deactivate(false, true);
/*     */ 
/* 252 */       this.transientPOA.destroy(false, false);
/*     */ 
/* 254 */       this.persistentPOA.destroy(false, false);
/*     */     }
/*     */     catch (AdapterInactive adapterInactive)
/*     */     {
/* 258 */       getLog().error("Cannot deactivate home POA", adapterInactive);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static Policy[] concatPolicies(Policy[] policies1, Policy[] policies2)
/*     */   {
/* 267 */     Policy[] policies = new Policy[policies1.length + policies2.length];
/* 268 */     int j = 0;
/* 269 */     for (int i = 0; i < policies1.length; j++) {
/* 270 */       policies[j] = policies1[i];
/*     */ 
/* 269 */       i++;
/*     */     }
/*     */ 
/* 272 */     for (int i = 0; i < policies2.length; j++) {
/* 273 */       policies[j] = policies2[i];
/*     */ 
/* 272 */       i++;
/*     */     }
/*     */ 
/* 275 */     return policies;
/*     */   }
/*     */ 
/*     */   public ServantRegistry getServantRegistry(ServantRegistryKind kind)
/*     */   {
/* 283 */     if (kind == ServantRegistryKind.SHARED_TRANSIENT_POA) {
/* 284 */       return this.registryWithSharedTransientPOA;
/*     */     }
/* 286 */     if (kind == ServantRegistryKind.SHARED_PERSISTENT_POA) {
/* 287 */       return this.registryWithSharedPersistentPOA;
/*     */     }
/* 289 */     if (kind == ServantRegistryKind.TRANSIENT_POA_PER_SERVANT) {
/* 290 */       return this.registryWithTransientPOAPerServant;
/*     */     }
/* 292 */     if (kind == ServantRegistryKind.PERSISTENT_POA_PER_SERVANT) {
/* 293 */       return this.registryWithPersistentPOAPerServant;
/*     */     }
/*     */ 
/* 296 */     return null;
/*     */   }
/*     */ 
/*     */   public java.lang.Object getObjectInstance(java.lang.Object obj, Name name, Context nameCtx, Hashtable environment)
/*     */     throws Exception
/*     */   {
/* 306 */     String s = name.toString();
/* 307 */     if (getLog().isTraceEnabled()) {
/* 308 */       getLog().trace("getObjectInstance: obj.getClass().getName=\"" + obj.getClass().getName() + "\n                   name=" + s);
/*     */     }
/*     */ 
/* 311 */     if (s.equals("iiop")) {
/* 312 */       return theIIOPInvoker;
/*     */     }
/* 314 */     return null;
/*     */   }
/*     */ 
/*     */   class PersistentServantLocator extends LocalObject
/*     */     implements ServantLocator
/*     */   {
/*     */     PersistentServantLocator()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Servant preinvoke(byte[] oid, POA adapter, String operation, CookieHolder the_cookie)
/*     */     {
/*     */       try
/*     */       {
/* 626 */         the_cookie.value = null;
/* 627 */         java.lang.Object id = ReferenceData.extractServantId(oid);
/* 628 */         return (Servant)IIOPInvoker.this.persistentServantMap.get(id);
/*     */       }
/*     */       catch (Exception e) {
/* 631 */         IIOPInvoker.this.getLog().trace("Unexpected exception in preinvoke:", e);
/* 632 */       }throw new UNKNOWN(e.toString());
/*     */     }
/*     */ 
/*     */     public void postinvoke(byte[] oid, POA adapter, String operation, java.lang.Object the_cookie, Servant the_servant)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   class TransientServantLocator extends LocalObject
/*     */     implements ServantLocator
/*     */   {
/*     */     TransientServantLocator()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Servant preinvoke(byte[] oid, POA adapter, String operation, CookieHolder the_cookie)
/*     */     {
/*     */       try
/*     */       {
/* 594 */         the_cookie.value = null;
/* 595 */         java.lang.Object id = ReferenceData.extractServantId(oid);
/* 596 */         return (Servant)IIOPInvoker.this.transientServantMap.get(id);
/*     */       }
/*     */       catch (Exception e) {
/* 599 */         IIOPInvoker.this.getLog().trace("Unexpected exception in preinvoke:", e);
/* 600 */       }throw new UNKNOWN(e.toString());
/*     */     }
/*     */ 
/*     */     public void postinvoke(byte[] oid, POA adapter, String operation, java.lang.Object the_cookie, Servant the_servant)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   class ServantRegistryWithPersistentPOAPerServant
/*     */     implements ServantRegistry
/*     */   {
/*     */     ServantRegistryWithPersistentPOAPerServant()
/*     */     {
/*     */     }
/*     */ 
/*     */     public ReferenceFactory bind(String name, Servant servant, Policy[] policies)
/*     */       throws Exception
/*     */     {
/* 539 */       if ((servant instanceof ServantWithMBeanServer)) {
/* 540 */         ((ServantWithMBeanServer)servant).setMBeanServer(IIOPInvoker.this.getServer());
/*     */       }
/* 542 */       Policy[] poaPolicies = IIOPInvoker.access$500(IIOPInvoker.this.persistentPoaPolicies, policies);
/*     */ 
/* 544 */       POA poa = IIOPInvoker.this.rootPOA.create_POA(name, null, poaPolicies);
/* 545 */       IIOPInvoker.this.persistentPoaMap.put(name, poa);
/* 546 */       poa.set_servant(servant);
/* 547 */       poa.the_POAManager().activate();
/* 548 */       return new IIOPInvoker.PoaReferenceFactory(poa);
/*     */     }
/*     */ 
/*     */     public ReferenceFactory bind(String name, Servant servant)
/*     */       throws Exception
/*     */     {
/* 555 */       if ((servant instanceof ServantWithMBeanServer)) {
/* 556 */         ((ServantWithMBeanServer)servant).setMBeanServer(IIOPInvoker.this.getServer());
/*     */       }
/* 558 */       POA poa = IIOPInvoker.this.rootPOA.create_POA(name, null, IIOPInvoker.this.persistentPoaPolicies);
/* 559 */       IIOPInvoker.this.persistentPoaMap.put(name, poa);
/* 560 */       poa.set_servant(servant);
/* 561 */       poa.the_POAManager().activate();
/* 562 */       return new IIOPInvoker.PoaReferenceFactory(poa);
/*     */     }
/*     */ 
/*     */     public void unbind(String name)
/*     */       throws Exception
/*     */     {
/* 569 */       POA poa = (POA)IIOPInvoker.this.persistentPoaMap.remove(name);
/* 570 */       if (poa != null) {
/* 571 */         poa.the_POAManager().deactivate(false, true);
/*     */ 
/* 573 */         poa.destroy(false, false);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   class ServantRegistryWithTransientPOAPerServant
/*     */     implements ServantRegistry
/*     */   {
/*     */     ServantRegistryWithTransientPOAPerServant()
/*     */     {
/*     */     }
/*     */ 
/*     */     public ReferenceFactory bind(String name, Servant servant, Policy[] policies)
/*     */       throws Exception
/*     */     {
/* 489 */       if ((servant instanceof ServantWithMBeanServer)) {
/* 490 */         ((ServantWithMBeanServer)servant).setMBeanServer(IIOPInvoker.this.getServer());
/*     */       }
/* 492 */       Policy[] poaPolicies = IIOPInvoker.access$500(IIOPInvoker.this.transientPoaPolicies, policies);
/* 493 */       POA poa = IIOPInvoker.this.rootPOA.create_POA(name, null, poaPolicies);
/* 494 */       IIOPInvoker.this.transientPoaMap.put(name, poa);
/* 495 */       poa.set_servant(servant);
/* 496 */       poa.the_POAManager().activate();
/* 497 */       return new IIOPInvoker.PoaReferenceFactory(poa);
/*     */     }
/*     */ 
/*     */     public ReferenceFactory bind(String name, Servant servant)
/*     */       throws Exception
/*     */     {
/* 504 */       if ((servant instanceof ServantWithMBeanServer)) {
/* 505 */         ((ServantWithMBeanServer)servant).setMBeanServer(IIOPInvoker.this.getServer());
/*     */       }
/* 507 */       POA poa = IIOPInvoker.this.rootPOA.create_POA(name, null, IIOPInvoker.this.transientPoaPolicies);
/* 508 */       IIOPInvoker.this.transientPoaMap.put(name, poa);
/* 509 */       poa.set_servant(servant);
/* 510 */       poa.the_POAManager().activate();
/* 511 */       return new IIOPInvoker.PoaReferenceFactory(poa);
/*     */     }
/*     */ 
/*     */     public void unbind(String name)
/*     */       throws Exception
/*     */     {
/* 518 */       POA poa = (POA)IIOPInvoker.this.transientPoaMap.remove(name);
/* 519 */       if (poa != null) {
/* 520 */         poa.the_POAManager().deactivate(false, true);
/*     */ 
/* 522 */         poa.destroy(false, false);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   class ServantRegistryWithSharedPersistentPOA
/*     */     implements ServantRegistry
/*     */   {
/*     */     ServantRegistryWithSharedPersistentPOA()
/*     */     {
/*     */     }
/*     */ 
/*     */     public ReferenceFactory bind(String name, Servant servant, Policy[] policies)
/*     */     {
/* 455 */       if ((servant instanceof ServantWithMBeanServer)) {
/* 456 */         ((ServantWithMBeanServer)servant).setMBeanServer(IIOPInvoker.this.getServer());
/*     */       }
/* 458 */       IIOPInvoker.this.persistentServantMap.put(name, servant);
/* 459 */       return new IIOPInvoker.PoaAndPoliciesReferenceFactory(IIOPInvoker.this.persistentPOA, name, policies);
/*     */     }
/*     */ 
/*     */     public ReferenceFactory bind(String name, Servant servant)
/*     */     {
/* 465 */       if ((servant instanceof ServantWithMBeanServer)) {
/* 466 */         ((ServantWithMBeanServer)servant).setMBeanServer(IIOPInvoker.this.getServer());
/*     */       }
/* 468 */       IIOPInvoker.this.persistentServantMap.put(name, servant);
/* 469 */       return new IIOPInvoker.PoaReferenceFactory(IIOPInvoker.this.persistentPOA, name);
/*     */     }
/*     */ 
/*     */     public void unbind(String name)
/*     */     {
/* 474 */       IIOPInvoker.this.persistentServantMap.remove(name);
/*     */     }
/*     */   }
/*     */ 
/*     */   class ServantRegistryWithSharedTransientPOA
/*     */     implements ServantRegistry
/*     */   {
/*     */     ServantRegistryWithSharedTransientPOA()
/*     */     {
/*     */     }
/*     */ 
/*     */     public ReferenceFactory bind(String name, Servant servant, Policy[] policies)
/*     */     {
/* 423 */       if ((servant instanceof ServantWithMBeanServer)) {
/* 424 */         ((ServantWithMBeanServer)servant).setMBeanServer(IIOPInvoker.this.getServer());
/*     */       }
/* 426 */       IIOPInvoker.this.transientServantMap.put(name, servant);
/* 427 */       return new IIOPInvoker.PoaAndPoliciesReferenceFactory(IIOPInvoker.this.transientPOA, name, policies);
/*     */     }
/*     */ 
/*     */     public ReferenceFactory bind(String name, Servant servant)
/*     */     {
/* 433 */       if ((servant instanceof ServantWithMBeanServer)) {
/* 434 */         ((ServantWithMBeanServer)servant).setMBeanServer(IIOPInvoker.this.getServer());
/*     */       }
/* 436 */       IIOPInvoker.this.transientServantMap.put(name, servant);
/* 437 */       return new IIOPInvoker.PoaReferenceFactory(IIOPInvoker.this.transientPOA, name);
/*     */     }
/*     */ 
/*     */     public void unbind(String name)
/*     */     {
/* 442 */       IIOPInvoker.this.transientServantMap.remove(name);
/*     */     }
/*     */   }
/*     */ 
/*     */   static class PoaReferenceFactory
/*     */     implements ReferenceFactory
/*     */   {
/*     */     private POA poa;
/*     */     private String servantName;
/*     */     private byte[] servantId;
/*     */ 
/*     */     PoaReferenceFactory(POA poa, String servantName)
/*     */     {
/* 380 */       this.poa = poa;
/* 381 */       this.servantName = servantName;
/* 382 */       this.servantId = ReferenceData.create(servantName);
/*     */     }
/*     */ 
/*     */     PoaReferenceFactory(POA poa)
/*     */     {
/* 387 */       this(poa, null);
/*     */     }
/*     */ 
/*     */     public org.omg.CORBA.Object createReference(String interfId)
/*     */       throws Exception
/*     */     {
/* 393 */       return this.poa.create_reference_with_id(this.servantId, interfId);
/*     */     }
/*     */ 
/*     */     public org.omg.CORBA.Object createReferenceWithId(java.lang.Object id, String interfId)
/*     */       throws Exception
/*     */     {
/* 400 */       byte[] referenceData = this.servantName == null ? ReferenceData.create(id) : ReferenceData.create(this.servantName, id);
/*     */ 
/* 403 */       return this.poa.create_reference_with_id(referenceData, interfId);
/*     */     }
/*     */ 
/*     */     public POA getPOA()
/*     */     {
/* 408 */       return this.poa;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class PoaAndPoliciesReferenceFactory
/*     */     implements ReferenceFactory
/*     */   {
/*     */     private POA poa;
/*     */     private String servantName;
/*     */     private Policy[] policies;
/*     */     private byte[] servantId;
/*     */ 
/*     */     PoaAndPoliciesReferenceFactory(POA poa, String servantName, Policy[] policies)
/*     */     {
/* 330 */       this.poa = poa;
/* 331 */       this.servantName = servantName;
/* 332 */       this.policies = policies;
/* 333 */       this.servantId = ReferenceData.create(servantName);
/*     */     }
/*     */ 
/*     */     PoaAndPoliciesReferenceFactory(POA poa, Policy[] policies)
/*     */     {
/* 338 */       this(poa, null, policies);
/*     */     }
/*     */ 
/*     */     public org.omg.CORBA.Object createReference(String interfId)
/*     */       throws Exception
/*     */     {
/* 344 */       org.omg.CORBA.Object corbaRef = this.poa.create_reference_with_id(this.servantId, interfId);
/*     */ 
/* 346 */       return corbaRef._set_policy_override(this.policies, SetOverrideType.ADD_OVERRIDE);
/*     */     }
/*     */ 
/*     */     public org.omg.CORBA.Object createReferenceWithId(java.lang.Object id, String interfId)
/*     */       throws Exception
/*     */     {
/* 354 */       byte[] referenceData = this.servantName == null ? ReferenceData.create(id) : ReferenceData.create(this.servantName, id);
/*     */ 
/* 357 */       org.omg.CORBA.Object corbaRef = this.poa.create_reference_with_id(referenceData, interfId);
/*     */ 
/* 359 */       return corbaRef._set_policy_override(this.policies, SetOverrideType.ADD_OVERRIDE);
/*     */     }
/*     */ 
/*     */     public POA getPOA()
/*     */     {
/* 365 */       return this.poa;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.iiop.IIOPInvoker
 * JD-Core Version:    0.6.0
 */