/*     */ package org.jboss.invocation.http.server;
/*     */ 
/*     */ import java.net.InetAddress;
/*     */ import java.net.UnknownHostException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.invocation.Invoker;
/*     */ import org.jboss.invocation.InvokerInterceptor;
/*     */ import org.jboss.invocation.http.interfaces.ClientMethodInterceptor;
/*     */ import org.jboss.invocation.http.interfaces.HttpInvokerProxy;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.naming.Util;
/*     */ import org.jboss.proxy.GenericProxyFactory;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.system.server.ServerConfigUtil;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class HttpProxyFactory extends ServiceMBeanSupport
/*     */   implements HttpProxyFactoryMBean
/*     */ {
/*     */   private ObjectName jmxInvokerName;
/*     */   private Object theProxy;
/*     */   private String invokerURL;
/*  63 */   private String invokerURLPrefix = "http://";
/*     */ 
/*  65 */   private String invokerURLSuffix = ":8080/invoker/JMXInvokerServlet";
/*     */ 
/*  67 */   private boolean useHostName = false;
/*     */   private String jndiName;
/*     */   private Class exportedInterface;
/*     */   private Element interceptorConfig;
/*     */   private ArrayList interceptorClasses;
/*     */ 
/*     */   public ObjectName getInvokerName()
/*     */   {
/*  81 */     return this.jmxInvokerName;
/*     */   }
/*     */ 
/*     */   public void setInvokerName(ObjectName jmxInvokerName) {
/*  85 */     this.jmxInvokerName = jmxInvokerName;
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/*  90 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName) {
/*  94 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public String getInvokerURL()
/*     */   {
/*  99 */     return this.invokerURL;
/*     */   }
/*     */ 
/*     */   public void setInvokerURL(String invokerURL)
/*     */   {
/* 104 */     String tmp = StringPropertyReplacer.replaceProperties(invokerURL);
/* 105 */     this.invokerURL = tmp;
/* 106 */     this.log.debug("Set invokerURL to " + this.invokerURL);
/*     */   }
/*     */ 
/*     */   public String getInvokerURLPrefix()
/*     */   {
/* 111 */     return this.invokerURLPrefix;
/*     */   }
/*     */ 
/*     */   public void setInvokerURLPrefix(String invokerURLPrefix) {
/* 115 */     this.invokerURLPrefix = invokerURLPrefix;
/*     */   }
/*     */ 
/*     */   public String getInvokerURLSuffix()
/*     */   {
/* 120 */     return this.invokerURLSuffix;
/*     */   }
/*     */ 
/*     */   public void setInvokerURLSuffix(String invokerURLSuffix) {
/* 124 */     this.invokerURLSuffix = invokerURLSuffix;
/*     */   }
/*     */ 
/*     */   public boolean getUseHostName()
/*     */   {
/* 129 */     return this.useHostName;
/*     */   }
/*     */ 
/*     */   public void setUseHostName(boolean flag) {
/* 133 */     this.useHostName = flag;
/*     */   }
/*     */ 
/*     */   public Class getExportedInterface()
/*     */   {
/* 138 */     return this.exportedInterface;
/*     */   }
/*     */ 
/*     */   public void setExportedInterface(Class exportedInterface) {
/* 142 */     this.exportedInterface = exportedInterface;
/*     */   }
/*     */ 
/*     */   public Element getClientInterceptors()
/*     */   {
/* 147 */     return this.interceptorConfig;
/*     */   }
/*     */ 
/*     */   public void setClientInterceptors(Element config) throws Exception {
/* 151 */     this.interceptorConfig = config;
/* 152 */     Iterator interceptorElements = MetaData.getChildrenByTagName(this.interceptorConfig, "interceptor");
/* 153 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 154 */     if (this.interceptorClasses != null)
/* 155 */       this.interceptorClasses.clear();
/*     */     else
/* 157 */       this.interceptorClasses = new ArrayList();
/* 158 */     while ((interceptorElements != null) && (interceptorElements.hasNext()))
/*     */     {
/* 160 */       Element ielement = (Element)interceptorElements.next();
/* 161 */       String className = null;
/* 162 */       className = MetaData.getElementContent(ielement);
/* 163 */       Class clazz = loader.loadClass(className);
/* 164 */       this.interceptorClasses.add(clazz);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getProxy()
/*     */   {
/* 170 */     return this.theProxy;
/*     */   }
/*     */ 
/*     */   public Object getProxy(Object id)
/*     */   {
/* 175 */     Class[] ifaces = { this.exportedInterface };
/* 176 */     ArrayList interceptorClasses = null;
/* 177 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 178 */     GenericProxyFactory proxyFactory = new GenericProxyFactory();
/* 179 */     Object newProxy = null;
/*     */ 
/* 184 */     return newProxy;
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 195 */     Invoker delegateInvoker = createInvoker();
/* 196 */     Integer nameHash = new Integer(this.jmxInvokerName.hashCode());
/* 197 */     this.log.debug("Bound delegate: " + delegateInvoker + " for invoker=" + this.jmxInvokerName);
/*     */ 
/* 203 */     Registry.bind(nameHash, this.jmxInvokerName);
/*     */ 
/* 205 */     Object cacheID = null;
/* 206 */     String proxyBindingName = null;
/* 207 */     Class[] ifaces = { this.exportedInterface };
/*     */ 
/* 210 */     if (this.interceptorClasses == null)
/* 211 */       this.interceptorClasses = defineDefaultInterceptors();
/* 212 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 213 */     GenericProxyFactory proxyFactory = new GenericProxyFactory();
/* 214 */     this.theProxy = proxyFactory.createProxy(cacheID, this.jmxInvokerName, delegateInvoker, this.jndiName, proxyBindingName, this.interceptorClasses, loader, ifaces);
/*     */ 
/* 217 */     this.log.debug("Created HttpInvokerProxy for invoker=" + this.jmxInvokerName + ", nameHash=" + nameHash);
/*     */ 
/* 220 */     if (this.jndiName != null)
/*     */     {
/* 222 */       InitialContext iniCtx = new InitialContext();
/* 223 */       Util.bind(iniCtx, this.jndiName, this.theProxy);
/* 224 */       this.log.debug("Bound proxy under jndiName=" + this.jndiName);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 230 */     Integer nameHash = new Integer(this.jmxInvokerName.hashCode());
/* 231 */     Registry.unbind(this.jmxInvokerName);
/* 232 */     Registry.unbind(nameHash);
/* 233 */     if (this.jndiName != null)
/*     */     {
/* 235 */       InitialContext iniCtx = new InitialContext();
/* 236 */       Util.unbind(iniCtx, this.jndiName);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected ArrayList defineDefaultInterceptors()
/*     */   {
/* 246 */     ArrayList tmp = new ArrayList();
/* 247 */     tmp.add(ClientMethodInterceptor.class);
/* 248 */     tmp.add(InvokerInterceptor.class);
/* 249 */     return tmp;
/*     */   }
/*     */ 
/*     */   protected Invoker createInvoker()
/*     */     throws Exception
/*     */   {
/* 256 */     checkInvokerURL();
/* 257 */     HttpInvokerProxy delegateInvoker = new HttpInvokerProxy(this.invokerURL);
/* 258 */     return delegateInvoker;
/*     */   }
/*     */ 
/*     */   protected void checkInvokerURL()
/*     */     throws UnknownHostException
/*     */   {
/* 268 */     if (this.invokerURL == null)
/*     */     {
/* 271 */       String host = ServerConfigUtil.getSpecificBindAddress();
/* 272 */       if (host == null)
/*     */       {
/* 274 */         InetAddress addr = InetAddress.getLocalHost();
/* 275 */         host = this.useHostName ? addr.getHostName() : addr.getHostAddress();
/*     */       }
/* 277 */       String url = this.invokerURLPrefix + host + this.invokerURLSuffix;
/* 278 */       setInvokerURL(url);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.http.server.HttpProxyFactory
 * JD-Core Version:    0.6.0
 */