/*     */ package org.jboss.invocation;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.rmi.Remote;
/*     */ import java.rmi.server.RemoteObject;
/*     */ import java.rmi.server.RemoteStub;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ 
/*     */ public class MarshalledValueOutputStream extends ObjectOutputStream
/*     */ {
/*     */   public MarshalledValueOutputStream(OutputStream os)
/*     */     throws IOException
/*     */   {
/*  52 */     super(os);
/*  53 */     EnableReplaceObjectAction.enableReplaceObject(this);
/*     */   }
/*     */ 
/*     */   protected void annotateClass(Class cl)
/*     */     throws IOException
/*     */   {
/*  61 */     super.annotateClass(cl);
/*     */   }
/*     */ 
/*     */   protected void annotateProxyClass(Class cl)
/*     */     throws IOException
/*     */   {
/*  69 */     super.annotateProxyClass(cl);
/*     */   }
/*     */ 
/*     */   protected Object replaceObject(Object obj)
/*     */     throws IOException
/*     */   {
/*  77 */     if (((obj instanceof Remote)) && (!(obj instanceof RemoteStub)))
/*     */     {
/*  79 */       Remote remote = (Remote)obj;
/*     */       try
/*     */       {
/*  82 */         obj = RemoteObject.toStub(remote);
/*     */       }
/*     */       catch (IOException ignore)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/*  89 */     return obj;
/*     */   }
/*     */ 
/*     */   private static class EnableReplaceObjectAction implements PrivilegedAction {
/*     */     MarshalledValueOutputStream os;
/*     */ 
/*     */     EnableReplaceObjectAction(MarshalledValueOutputStream os) {
/*  97 */       this.os = os;
/*     */     }
/*     */ 
/*     */     public Object run() {
/* 101 */       this.os.enableReplaceObject(true);
/* 102 */       return null;
/*     */     }
/*     */ 
/*     */     static void enableReplaceObject(MarshalledValueOutputStream os) {
/* 106 */       EnableReplaceObjectAction action = new EnableReplaceObjectAction(os);
/* 107 */       AccessController.doPrivileged(action);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.MarshalledValueOutputStream
 * JD-Core Version:    0.6.0
 */