/*     */ package org.jboss.invocation;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectStreamClass;
/*     */ import java.lang.reflect.Proxy;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.collection.WeakValueHashMap;
/*     */ 
/*     */ public class MarshalledValueInputStream extends ObjectInputStream
/*     */ {
/*  44 */   private static Logger log = Logger.getLogger(MarshalledValueInputStream.class);
/*     */   private static WeakValueHashMap classCache;
/*     */ 
/*     */   public static void useClassCache(boolean flag)
/*     */   {
/*  55 */     if (flag == true)
/*  56 */       classCache = new WeakValueHashMap();
/*     */     else
/*  58 */       classCache = null;
/*     */   }
/*     */ 
/*     */   public static void flushClassCache()
/*     */   {
/*  66 */     classCache.clear();
/*     */   }
/*     */ 
/*     */   public MarshalledValueInputStream(InputStream is)
/*     */     throws IOException
/*     */   {
/*  74 */     super(is);
/*     */   }
/*     */ 
/*     */   protected Class resolveClass(ObjectStreamClass v)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  85 */     String className = v.getName();
/*  86 */     Class resolvedClass = null;
/*     */ 
/*  88 */     if (classCache != null)
/*     */     {
/*  90 */       synchronized (classCache)
/*     */       {
/*  92 */         resolvedClass = (Class)classCache.get(className);
/*     */       }
/*     */     }
/*     */ 
/*  96 */     if (resolvedClass == null)
/*     */     {
/*  98 */       ClassLoader loader = SecurityActions.getContextClassLoader();
/*     */       try
/*     */       {
/* 101 */         resolvedClass = loader.loadClass(className);
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 109 */         resolvedClass = super.resolveClass(v);
/*     */       }
/* 111 */       if (classCache != null)
/*     */       {
/* 113 */         synchronized (classCache)
/*     */         {
/* 115 */           classCache.put(className, resolvedClass);
/*     */         }
/*     */       }
/*     */     }
/* 119 */     return (Class)resolvedClass;
/*     */   }
/*     */ 
/*     */   protected Class resolveProxyClass(String[] interfaces)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 125 */     if (log.isTraceEnabled())
/*     */     {
/* 127 */       StringBuffer tmp = new StringBuffer("[");
/* 128 */       for (int i = 0; i < interfaces.length; i++)
/*     */       {
/* 130 */         if (i > 0)
/* 131 */           tmp.append(',');
/* 132 */         tmp.append(interfaces[i]);
/*     */       }
/* 134 */       tmp.append(']');
/* 135 */       log.trace("resolveProxyClass called, ifaces=" + tmp.toString());
/*     */     }
/*     */ 
/* 139 */     ClassLoader loader = null;
/* 140 */     Class[] ifaceClasses = new Class[interfaces.length];
/* 141 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/* 143 */       Class iface = null;
/* 144 */       String className = interfaces[i];
/*     */ 
/* 146 */       if (classCache != null)
/*     */       {
/* 148 */         synchronized (classCache)
/*     */         {
/* 150 */           iface = (Class)classCache.get(className);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 155 */       if (iface == null)
/*     */       {
/* 157 */         if (loader == null)
/* 158 */           loader = Thread.currentThread().getContextClassLoader();
/* 159 */         iface = loader.loadClass(className);
/* 160 */         if (classCache != null)
/*     */         {
/* 162 */           synchronized (classCache)
/*     */           {
/* 164 */             classCache.put(className, iface);
/*     */           }
/*     */         }
/*     */       }
/* 168 */       ifaceClasses[i] = iface;
/*     */     }
/*     */ 
/* 171 */     return Proxy.getProxyClass(loader, ifaceClasses);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.MarshalledValueInputStream
 * JD-Core Version:    0.6.0
 */