/*     */ package org.jboss.invocation;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.AccessController;
/*     */ import java.security.DigestOutputStream;
/*     */ import java.security.MessageDigest;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.WeakHashMap;
/*     */ import javax.transaction.Transaction;
/*     */ 
/*     */ public class MarshalledInvocation extends Invocation
/*     */   implements Externalizable
/*     */ {
/*     */   static final long serialVersionUID = -718723094688127810L;
/*  65 */   static boolean useFullHashMode = true;
/*     */ 
/*  67 */   static Map hashMap = new WeakHashMap();
/*     */   protected Object tpc;
/*     */   protected transient Map methodMap;
/*  76 */   protected transient long methodHash = 0L;
/*  77 */   protected transient MarshalledValue marshalledArgs = null;
/*     */ 
/*     */   public static boolean getUseFullHashMode()
/*     */   {
/*  84 */     return useFullHashMode;
/*     */   }
/*     */ 
/*     */   public static void setUseFullHashMode(boolean flag)
/*     */   {
/*  99 */     useFullHashMode = flag;
/*     */   }
/*     */ 
/*     */   public static Map getInterfaceHashes(Class intf)
/*     */   {
/* 113 */     Method[] methods = null;
/* 114 */     if (System.getSecurityManager() != null)
/*     */     {
/* 116 */       DeclaredMethodsAction action = new DeclaredMethodsAction(intf);
/* 117 */       methods = (Method[])(Method[])AccessController.doPrivileged(action);
/*     */     }
/*     */     else
/*     */     {
/* 121 */       methods = intf.getDeclaredMethods();
/*     */     }
/*     */ 
/* 124 */     HashMap map = new HashMap();
/* 125 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 127 */       Method method = methods[i];
/* 128 */       Class[] parameterTypes = method.getParameterTypes();
/* 129 */       String methodDesc = method.getName() + "(";
/* 130 */       for (int j = 0; j < parameterTypes.length; j++)
/*     */       {
/* 132 */         methodDesc = methodDesc + getTypeString(parameterTypes[j]);
/*     */       }
/* 134 */       methodDesc = methodDesc + ")" + getTypeString(method.getReturnType());
/*     */       try
/*     */       {
/* 138 */         long hash = 0L;
/* 139 */         ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
/* 140 */         MessageDigest messagedigest = MessageDigest.getInstance("SHA");
/* 141 */         DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
/* 142 */         dataoutputstream.writeUTF(methodDesc);
/* 143 */         dataoutputstream.flush();
/* 144 */         byte[] abyte0 = messagedigest.digest();
/* 145 */         for (int j = 0; j < Math.min(8, abyte0.length); j++)
/* 146 */           hash += ((abyte0[j] & 0xFF) << j * 8);
/* 147 */         map.put(method.toString(), new Long(hash));
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 151 */         e.printStackTrace();
/*     */       }
/*     */     }
/*     */ 
/* 155 */     return map;
/*     */   }
/*     */ 
/*     */   public static Map getFullInterfaceHashes(Class intf)
/*     */   {
/* 168 */     Method[] methods = null;
/* 169 */     if (System.getSecurityManager() != null)
/*     */     {
/* 171 */       DeclaredMethodsAction action = new DeclaredMethodsAction(intf);
/* 172 */       methods = (Method[])(Method[])AccessController.doPrivileged(action);
/*     */     }
/*     */     else
/*     */     {
/* 176 */       methods = intf.getDeclaredMethods();
/*     */     }
/*     */ 
/* 179 */     HashMap map = new HashMap();
/* 180 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 182 */       Method method = methods[i];
/* 183 */       String methodDesc = method.toString();
/*     */       try
/*     */       {
/* 187 */         long hash = 0L;
/* 188 */         ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
/* 189 */         MessageDigest messagedigest = MessageDigest.getInstance("SHA");
/* 190 */         DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
/* 191 */         dataoutputstream.writeUTF(methodDesc);
/* 192 */         dataoutputstream.flush();
/* 193 */         byte[] abyte0 = messagedigest.digest();
/* 194 */         for (int j = 0; j < Math.min(8, abyte0.length); j++)
/* 195 */           hash += ((abyte0[j] & 0xFF) << j * 8);
/* 196 */         map.put(method.toString(), new Long(hash));
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 200 */         e.printStackTrace();
/*     */       }
/*     */     }
/*     */ 
/* 204 */     return map;
/*     */   }
/*     */ 
/*     */   public static Map methodToHashesMap(Class c)
/*     */   {
/* 217 */     Method[] methods = null;
/* 218 */     if (System.getSecurityManager() != null)
/*     */     {
/* 220 */       DeclaredMethodsAction action = new DeclaredMethodsAction(c);
/* 221 */       methods = (Method[])(Method[])AccessController.doPrivileged(action);
/*     */     }
/*     */     else
/*     */     {
/* 225 */       methods = c.getDeclaredMethods();
/*     */     }
/*     */ 
/* 228 */     HashMap map = new HashMap();
/* 229 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 231 */       Method method = methods[i];
/* 232 */       String methodDesc = method.toString();
/*     */       try
/*     */       {
/* 236 */         long hash = 0L;
/* 237 */         ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
/* 238 */         MessageDigest messagedigest = MessageDigest.getInstance("SHA");
/* 239 */         DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
/* 240 */         dataoutputstream.writeUTF(methodDesc);
/* 241 */         dataoutputstream.flush();
/* 242 */         byte[] abyte0 = messagedigest.digest();
/* 243 */         for (int j = 0; j < Math.min(8, abyte0.length); j++)
/* 244 */           hash += ((abyte0[j] & 0xFF) << j * 8);
/* 245 */         map.put(new Long(hash), method);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 249 */         e.printStackTrace();
/*     */       }
/*     */     }
/*     */ 
/* 253 */     return map;
/*     */   }
/*     */ 
/*     */   static String getTypeString(Class cl)
/*     */   {
/* 258 */     if (cl == Byte.TYPE)
/*     */     {
/* 260 */       return "B";
/*     */     }
/* 262 */     if (cl == Character.TYPE)
/*     */     {
/* 264 */       return "C";
/*     */     }
/* 266 */     if (cl == Double.TYPE)
/*     */     {
/* 268 */       return "D";
/*     */     }
/* 270 */     if (cl == Float.TYPE)
/*     */     {
/* 272 */       return "F";
/*     */     }
/* 274 */     if (cl == Integer.TYPE)
/*     */     {
/* 276 */       return "I";
/*     */     }
/* 278 */     if (cl == Long.TYPE)
/*     */     {
/* 280 */       return "J";
/*     */     }
/* 282 */     if (cl == Short.TYPE)
/*     */     {
/* 284 */       return "S";
/*     */     }
/* 286 */     if (cl == Boolean.TYPE)
/*     */     {
/* 288 */       return "Z";
/*     */     }
/* 290 */     if (cl == Void.TYPE)
/*     */     {
/* 292 */       return "V";
/*     */     }
/* 294 */     if (cl.isArray())
/*     */     {
/* 296 */       return "[" + getTypeString(cl.getComponentType());
/*     */     }
/*     */ 
/* 300 */     return "L" + cl.getName().replace('.', '/') + ";";
/*     */   }
/*     */ 
/*     */   public static long calculateHash(Method method)
/*     */   {
/* 312 */     Map methodHashes = (Map)hashMap.get(method.getDeclaringClass());
/*     */ 
/* 314 */     if (methodHashes == null)
/*     */     {
/* 317 */       if (useFullHashMode == true)
/* 318 */         methodHashes = getFullInterfaceHashes(method.getDeclaringClass());
/*     */       else
/* 320 */         methodHashes = getInterfaceHashes(method.getDeclaringClass());
/* 321 */       synchronized (hashMap)
/*     */       {
/* 323 */         hashMap.put(method.getDeclaringClass(), methodHashes);
/*     */       }
/*     */     }
/*     */ 
/* 327 */     Long hash = (Long)methodHashes.get(method.toString());
/* 328 */     return hash.longValue();
/*     */   }
/*     */ 
/*     */   public static void removeHashes(Class declaringClass)
/*     */   {
/* 337 */     synchronized (hashMap)
/*     */     {
/* 339 */       hashMap.remove(declaringClass);
/*     */     }
/*     */   }
/*     */ 
/*     */   public MarshalledInvocation()
/*     */   {
/*     */   }
/*     */ 
/*     */   public MarshalledInvocation(Invocation invocation)
/*     */   {
/* 351 */     this.payload = invocation.payload;
/* 352 */     this.as_is_payload = invocation.as_is_payload;
/* 353 */     this.method = invocation.getMethod();
/* 354 */     this.objectName = invocation.getObjectName();
/* 355 */     this.args = invocation.getArguments();
/* 356 */     this.invocationType = invocation.getType();
/*     */   }
/*     */ 
/*     */   public MarshalledInvocation(Object id, Method m, Object[] args, Transaction tx, Principal identity, Object credential)
/*     */   {
/* 368 */     super(id, m, args, tx, identity, credential);
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/* 373 */     if (this.method != null) {
/* 374 */       return this.method;
/*     */     }
/*     */ 
/* 377 */     this.method = ((Method)this.methodMap.get(new Long(this.methodHash)));
/*     */ 
/* 380 */     if (this.method == null)
/*     */     {
/* 382 */       throw new IllegalStateException("Failed to find method for hash:" + this.methodHash + " available=" + this.methodMap);
/*     */     }
/* 384 */     return this.method;
/*     */   }
/*     */ 
/*     */   public void setMethodMap(Map methods)
/*     */   {
/* 389 */     this.methodMap = methods;
/*     */   }
/*     */ 
/*     */   public void setTransactionPropagationContext(Object tpc)
/*     */   {
/* 395 */     this.tpc = tpc;
/*     */   }
/*     */ 
/*     */   public Object getTransactionPropagationContext()
/*     */   {
/* 400 */     return this.tpc;
/*     */   }
/*     */ 
/*     */   public Object getValue(Object key)
/*     */   {
/* 413 */     Object value = super.getValue(key);
/*     */ 
/* 416 */     if ((value instanceof MarshalledValue))
/*     */     {
/*     */       try
/*     */       {
/* 420 */         MarshalledValue mv = (MarshalledValue)value;
/* 421 */         value = mv.get();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 425 */         JBossLazyUnmarshallingException ise = new JBossLazyUnmarshallingException("getValue failed");
/* 426 */         ise.initCause(e);
/* 427 */         throw ise;
/*     */       }
/*     */     }
/* 430 */     return value;
/*     */   }
/*     */ 
/*     */   public Object getPayloadValue(Object key)
/*     */   {
/* 441 */     Object value = getPayload().get(key);
/*     */ 
/* 444 */     if ((value instanceof MarshalledValue))
/*     */     {
/*     */       try
/*     */       {
/* 448 */         MarshalledValue mv = (MarshalledValue)value;
/* 449 */         value = mv.get();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 453 */         JBossLazyUnmarshallingException ise = new JBossLazyUnmarshallingException("getPayloadValue failed");
/* 454 */         ise.initCause(e);
/* 455 */         throw ise;
/*     */       }
/*     */     }
/* 458 */     return value;
/*     */   }
/*     */ 
/*     */   public Object[] getArguments()
/*     */   {
/* 463 */     if (this.args == null)
/*     */     {
/*     */       try
/*     */       {
/* 467 */         this.args = ((Object[])(Object[])this.marshalledArgs.get());
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 471 */         JBossLazyUnmarshallingException ise = new JBossLazyUnmarshallingException("getArguments failed");
/* 472 */         ise.initCause(e);
/* 473 */         throw ise;
/*     */       }
/*     */     }
/* 476 */     return this.args;
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 485 */     getAsIsPayload().put(InvocationKey.TYPE, this.invocationType);
/*     */ 
/* 488 */     out.writeObject(this.tpc);
/*     */ 
/* 490 */     long methodHash = this.methodHash;
/* 491 */     if (methodHash == 0L)
/*     */     {
/* 493 */       methodHash = calculateHash(this.method);
/*     */     }
/*     */ 
/* 496 */     out.writeLong(methodHash);
/*     */ 
/* 498 */     out.writeObject(this.objectName);
/*     */ 
/* 500 */     if ((this.args == null) && (this.marshalledArgs != null))
/*     */     {
/* 502 */       out.writeObject(this.marshalledArgs);
/*     */     }
/*     */     else
/*     */     {
/* 506 */       out.writeObject(new MarshalledValue(this.args));
/*     */     }
/*     */ 
/* 518 */     if (this.payload == null) {
/* 519 */       out.writeInt(0);
/*     */     }
/*     */     else {
/* 522 */       out.writeInt(this.payload.size());
/* 523 */       Iterator keys = this.payload.keySet().iterator();
/* 524 */       while (keys.hasNext())
/*     */       {
/* 526 */         Object currentKey = keys.next();
/*     */ 
/* 531 */         out.writeObject(currentKey);
/* 532 */         Object value = this.payload.get(currentKey);
/*     */ 
/* 534 */         if (!(value instanceof MarshalledValue))
/*     */         {
/* 536 */           value = new MarshalledValue(value);
/*     */         }
/*     */ 
/* 539 */         out.writeObject(value);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 545 */     if (this.as_is_payload == null) {
/* 546 */       out.writeInt(0);
/*     */     }
/*     */     else {
/* 549 */       out.writeInt(this.as_is_payload.size());
/*     */ 
/* 551 */       Iterator keys = this.as_is_payload.keySet().iterator();
/* 552 */       while (keys.hasNext())
/*     */       {
/* 554 */         Object currentKey = keys.next();
/* 555 */         out.writeObject(currentKey);
/* 556 */         out.writeObject(this.as_is_payload.get(currentKey));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 564 */     this.tpc = in.readObject();
/* 565 */     this.methodHash = in.readLong();
/*     */ 
/* 567 */     this.objectName = in.readObject();
/*     */ 
/* 569 */     this.marshalledArgs = ((MarshalledValue)in.readObject());
/*     */ 
/* 571 */     int payloadSize = in.readInt();
/* 572 */     if (payloadSize > 0)
/*     */     {
/* 574 */       this.payload = new HashMap();
/* 575 */       for (int i = 0; i < payloadSize; i++)
/*     */       {
/* 577 */         Object key = in.readObject();
/* 578 */         Object value = in.readObject();
/* 579 */         this.payload.put(key, value);
/*     */       }
/*     */     }
/*     */ 
/* 583 */     int as_is_payloadSize = in.readInt();
/* 584 */     if (as_is_payloadSize > 0)
/*     */     {
/* 586 */       this.as_is_payload = new HashMap();
/* 587 */       for (int i = 0; i < as_is_payloadSize; i++)
/*     */       {
/* 589 */         Object key = in.readObject();
/* 590 */         Object value = in.readObject();
/* 591 */         this.as_is_payload.put(key, value);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 596 */     this.invocationType = ((InvocationType)getAsIsValue(InvocationKey.TYPE));
/*     */   }
/*     */ 
/*     */   private static class DeclaredMethodsAction implements PrivilegedAction {
/*     */     Class c;
/*     */ 
/*     */     DeclaredMethodsAction(Class c) {
/* 604 */       this.c = c;
/*     */     }
/*     */ 
/*     */     public Object run() {
/* 608 */       Method[] methods = this.c.getDeclaredMethods();
/* 609 */       this.c = null;
/* 610 */       return methods;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.MarshalledInvocation
 * JD-Core Version:    0.6.0
 */