/*     */ package org.jboss.invocation;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.proxy.Interceptor;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class InvokerInterceptor extends Interceptor
/*     */   implements Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = 2548120545997920357L;
/*  55 */   private GUID invokerID = Invoker.ID;
/*     */   protected Invoker remoteInvoker;
/*     */   protected static Invoker localInvoker;
/*     */   protected static Class invokerProxyHA;
/*     */ 
/*     */   public static Invoker getLocal()
/*     */   {
/*  83 */     return localInvoker;
/*     */   }
/*     */ 
/*     */   public static void setLocal(Invoker invoker)
/*     */   {
/*  91 */     localInvoker = invoker;
/*     */   }
/*     */ 
/*     */   public boolean isLocal()
/*     */   {
/* 109 */     return this.invokerID.equals(Invoker.ID);
/*     */   }
/*     */ 
/*     */   public boolean isLocal(Invocation invocation)
/*     */   {
/* 121 */     if (localInvoker == null) {
/* 122 */       return false;
/*     */     }
/*     */ 
/* 125 */     if (!isLocal())
/*     */     {
/* 128 */       if (!isClustered(invocation)) {
/* 129 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 133 */     return hasLocalTarget(invocation);
/*     */   }
/*     */ 
/*     */   public boolean isClustered(Invocation invocation)
/*     */   {
/* 150 */     if (invokerProxyHA == null) {
/* 151 */       return false;
/*     */     }
/*     */ 
/* 154 */     InvocationContext ctx = invocation.getInvocationContext();
/* 155 */     Invoker invoker = ctx.getInvoker();
/* 156 */     return (invoker != null) && (invokerProxyHA.isAssignableFrom(invoker.getClass()));
/*     */   }
/*     */ 
/*     */   public boolean hasLocalTarget(Invocation invocation)
/*     */   {
/* 167 */     return Registry.lookup(invocation.getObjectName()) != null;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Exception
/*     */   {
/* 178 */     if (isLocal(invocation)) {
/* 179 */       return invokeLocal(invocation);
/*     */     }
/* 181 */     return invokeInvoker(invocation);
/*     */   }
/*     */ 
/*     */   protected Object invokeLocal(Invocation invocation)
/*     */     throws Exception
/*     */   {
/* 193 */     return localInvoker.invoke(invocation);
/*     */   }
/*     */   protected Object invokeMarshalled(Invocation invocation) throws Exception {
/* 205 */     MarshalledInvocation mi = new MarshalledInvocation(invocation);
/* 206 */     MarshalledValue copy = new MarshalledValue(mi);
/* 207 */     Invocation invocationCopy = (Invocation)copy.get();
/*     */ 
/* 210 */     Transaction tx = invocation.getTransaction();
/* 211 */     invocationCopy.setTransaction(tx);
/*     */     Throwable t2;
/*     */     try { Object rtnValue = localInvoker.invoke(invocationCopy);
/* 216 */       MarshalledValue mv = new MarshalledValue(rtnValue);
/* 217 */       return mv.get();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 221 */       MarshalledValue mv = new MarshalledValue(t);
/* 222 */       t2 = (Throwable)mv.get();
/* 223 */       if ((t2 instanceof Exception))
/* 224 */         throw ((Exception)t2);
/*     */     }
/* 226 */     throw new UndeclaredThrowableException(t2);
/*     */   }
/*     */ 
/*     */   protected Object invokeInvoker(Invocation invocation)
/*     */     throws Exception
/*     */   {
/* 240 */     invocation.setInterVM(Boolean.TRUE);
/*     */ 
/* 242 */     InvocationContext ctx = invocation.getInvocationContext();
/* 243 */     Invoker invoker = ctx.getInvoker();
/* 244 */     return invoker.invoke(invocation);
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 258 */     out.writeObject(this.invokerID);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 271 */     this.invokerID = ((GUID)in.readObject());
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  71 */       invokerProxyHA = Class.forName("org.jboss.invocation.InvokerProxyHA");
/*     */     }
/*     */     catch (Throwable ignored)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.InvokerInterceptor
 * JD-Core Version:    0.6.0
 */