/*    */ package org.jboss.invocation;
/*    */ 
/*    */ import java.io.ObjectStreamException;
/*    */ import java.io.Serializable;
/*    */ 
/*    */ public final class InvocationType
/*    */   implements Serializable
/*    */ {
/*    */   private static final long serialVersionUID = 6460196085190851775L;
/* 38 */   private static final String[] INTERFACE_NAMES = { "Remote", "Local", "Home", "LocalHome", "ServiceEndpoint" };
/*    */   private static final int MAX_TYPE_ID = 4;
/* 49 */   private static final InvocationType[] values = new InvocationType[5];
/* 50 */   public static final InvocationType REMOTE = new InvocationType("REMOTE", 0);
/*    */ 
/* 52 */   public static final InvocationType LOCAL = new InvocationType("LOCAL", 1);
/*    */ 
/* 54 */   public static final InvocationType HOME = new InvocationType("HOME", 2);
/*    */ 
/* 56 */   public static final InvocationType LOCALHOME = new InvocationType("LOCALHOME", 3);
/*    */ 
/* 58 */   public static final InvocationType SERVICE_ENDPOINT = new InvocationType("SERVICE_ENDPOINT", 4);
/*    */   private final transient String name;
/*    */   private final int ordinal;
/*    */ 
/*    */   private InvocationType(String name, int ordinal)
/*    */   {
/* 68 */     this.name = name;
/* 69 */     this.ordinal = ordinal;
/* 70 */     values[ordinal] = this;
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 75 */     return this.name;
/*    */   }
/*    */ 
/*    */   public String toInterfaceString()
/*    */   {
/* 83 */     return INTERFACE_NAMES[this.ordinal];
/*    */   }
/*    */ 
/*    */   Object readResolve() throws ObjectStreamException
/*    */   {
/* 88 */     return values[this.ordinal];
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.InvocationType
 * JD-Core Version:    0.6.0
 */