/*     */ package org.jboss.invocation;
/*     */ 
/*     */ import java.io.ObjectStreamException;
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public final class InvocationKey
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -5117370636698417671L;
/*     */   private static final int MAX_KEY_ID = 21;
/*  48 */   private static final InvocationKey[] values = new InvocationKey[22];
/*     */ 
/*  53 */   public static final InvocationKey TRANSACTION = new InvocationKey("TRANSACTION", 0);
/*     */ 
/*  59 */   public static final InvocationKey PRINCIPAL = new InvocationKey("PRINCIPAL", 1);
/*     */ 
/*  65 */   public static final InvocationKey CREDENTIAL = new InvocationKey("CREDENTIAL", 2);
/*     */ 
/*  69 */   public static final InvocationKey SUBJECT = new InvocationKey("SUBJECT", 14);
/*     */ 
/*  75 */   public static final InvocationKey OBJECT_NAME = new InvocationKey("CONTAINER", 3);
/*     */ 
/*  81 */   public static final InvocationKey TYPE = new InvocationKey("TYPE", 4);
/*     */ 
/*  87 */   public static final InvocationKey CACHE_ID = new InvocationKey("CACHE_ID", 5);
/*     */ 
/*  92 */   public static final InvocationKey METHOD = new InvocationKey("METHOD", 6);
/*     */ 
/*  97 */   public static final InvocationKey ARGUMENTS = new InvocationKey("ARGUMENTS", 7);
/*     */ 
/* 103 */   public static final InvocationKey INVOCATION_CONTEXT = new InvocationKey("INVOCATION_CONTEXT", 8);
/*     */ 
/* 109 */   public static final InvocationKey ENTERPRISE_CONTEXT = new InvocationKey("ENTERPRISE_CONTEXT", 9);
/*     */ 
/* 115 */   public static final InvocationKey INVOKER_PROXY_BINDING = new InvocationKey("INVOKER_PROXY_BINDING", 10);
/*     */ 
/* 121 */   public static final InvocationKey INVOKER = new InvocationKey("INVOKER", 11);
/*     */ 
/* 126 */   public static final InvocationKey JNDI_NAME = new InvocationKey("JNDI_NAME", 12);
/*     */ 
/* 132 */   public static final InvocationKey EJB_METADATA = new InvocationKey("EJB_METADATA", 13);
/*     */ 
/* 136 */   public static final InvocationKey EJB_HOME = new InvocationKey("EJB_HOME", 14);
/*     */ 
/* 140 */   public static final InvocationKey SOAP_MESSAGE_CONTEXT = new InvocationKey("SOAP_MESSAGE_CONTEXT", 15);
/*     */ 
/* 144 */   public static final InvocationKey SOAP_MESSAGE = new InvocationKey("SOAP_MESSAGE", 16);
/*     */ 
/* 148 */   public static final InvocationKey JACC_CONTEXT_ID = new InvocationKey("JACC_CONTEXT_ID", 17);
/*     */ 
/* 154 */   public static final InvocationKey SECURITY_CONTEXT = new InvocationKey("SECURITY_CONTEXT", 18);
/*     */ 
/* 160 */   public static final InvocationKey SECURE = new InvocationKey("SECURE", 19);
/*     */ 
/* 166 */   public static final InvocationKey INTERVM = new InvocationKey("INTERVM", 20);
/*     */   private final transient String name;
/*     */   private final int ordinal;
/*     */ 
/*     */   private InvocationKey(String name, int ordinal)
/*     */   {
/* 177 */     this.name = name;
/* 178 */     this.ordinal = ordinal;
/* 179 */     values[ordinal] = this;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 184 */     return this.name;
/*     */   }
/*     */ 
/*     */   Object readResolve() throws ObjectStreamException
/*     */   {
/* 189 */     return values[this.ordinal];
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.InvocationKey
 * JD-Core Version:    0.6.0
 */