/*     */ package org.jboss.invocation;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.Principal;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.security.SecurityContext;
/*     */ 
/*     */ public class Invocation
/*     */ {
/*  54 */   public static final String[] INVOKE_SIGNATURE = { "org.jboss.invocation.Invocation" };
/*     */   public Map transient_payload;
/*     */   public Map as_is_payload;
/*     */   public Map payload;
/*     */   public InvocationContext invocationContext;
/*     */   public Object[] args;
/*     */   public Object objectName;
/*     */   public Method method;
/*     */   public InvocationType invocationType;
/*     */ 
/*     */   public Invocation()
/*     */   {
/*     */   }
/*     */ 
/*     */   public Invocation(Object id, Method m, Object[] args, Transaction tx, Principal identity, Object credential)
/*     */   {
/*  98 */     setId(id);
/*  99 */     setMethod(m);
/* 100 */     setArguments(args);
/* 101 */     setTransaction(tx);
/* 102 */     setPrincipal(identity);
/* 103 */     setCredential(credential);
/*     */   }
/*     */ 
/*     */   public void setValue(Object key, Object value)
/*     */   {
/* 116 */     setValue(key, value, PayloadKey.PAYLOAD);
/*     */   }
/*     */ 
/*     */   public void setValue(Object key, Object value, PayloadKey type)
/*     */   {
/* 129 */     if (type == PayloadKey.TRANSIENT)
/*     */     {
/* 131 */       getTransientPayload().put(key, value);
/*     */     }
/* 133 */     else if (type == PayloadKey.AS_IS)
/*     */     {
/* 135 */       getAsIsPayload().put(key, value);
/*     */     }
/* 137 */     else if (type == PayloadKey.PAYLOAD)
/*     */     {
/* 139 */       getPayload().put(key, value);
/*     */     }
/*     */     else
/*     */     {
/* 143 */       throw new IllegalArgumentException("Unknown PayloadKey: " + type);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getValue(Object key)
/*     */   {
/* 153 */     Object rtn = getPayloadValue(key);
/* 154 */     if (rtn != null) return rtn;
/*     */ 
/* 156 */     rtn = getAsIsValue(key);
/* 157 */     if (rtn != null) return rtn;
/*     */ 
/* 159 */     rtn = getTransientValue(key);
/* 160 */     return rtn;
/*     */   }
/*     */ 
/*     */   public Object getPayloadValue(Object key)
/*     */   {
/* 165 */     if (this.payload == null) return null;
/* 166 */     return this.payload.get(key);
/*     */   }
/*     */ 
/*     */   public Object getTransientValue(Object key)
/*     */   {
/* 171 */     if (this.transient_payload == null) return null;
/* 172 */     return this.transient_payload.get(key);
/*     */   }
/*     */ 
/*     */   public Object getAsIsValue(Object key)
/*     */   {
/* 177 */     if (this.as_is_payload == null) return null;
/* 178 */     return this.as_is_payload.get(key);
/*     */   }
/*     */ 
/*     */   public void setTransaction(Transaction tx)
/*     */   {
/* 197 */     if ((tx instanceof Serializable))
/* 198 */       getAsIsPayload().put(InvocationKey.TRANSACTION, tx);
/*     */     else
/* 200 */       getTransientPayload().put(InvocationKey.TRANSACTION, tx);
/*     */   }
/*     */ 
/*     */   public Transaction getTransaction()
/*     */   {
/* 208 */     Transaction tx = (Transaction)getAsIsPayload().get(InvocationKey.TRANSACTION);
/* 209 */     if (tx == null)
/* 210 */       tx = (Transaction)getTransientPayload().get(InvocationKey.TRANSACTION);
/* 211 */     return tx;
/*     */   }
/*     */ 
/*     */   public void setPrincipal(Principal principal)
/*     */   {
/* 219 */     getAsIsPayload().put(InvocationKey.PRINCIPAL, principal);
/*     */   }
/*     */ 
/*     */   public Principal getPrincipal()
/*     */   {
/* 224 */     return (Principal)getAsIsPayload().get(InvocationKey.PRINCIPAL);
/*     */   }
/*     */ 
/*     */   public void setCredential(Object credential)
/*     */   {
/* 232 */     getPayload().put(InvocationKey.CREDENTIAL, credential);
/*     */   }
/*     */ 
/*     */   public Object getCredential()
/*     */   {
/* 237 */     return getPayloadValue(InvocationKey.CREDENTIAL);
/*     */   }
/*     */ 
/*     */   public void setObjectName(Object objectName)
/*     */   {
/* 245 */     this.objectName = objectName;
/*     */   }
/*     */ 
/*     */   public Object getObjectName()
/*     */   {
/* 250 */     return this.objectName;
/*     */   }
/*     */ 
/*     */   public void setType(InvocationType type)
/*     */   {
/* 258 */     this.invocationType = type;
/*     */   }
/*     */ 
/*     */   public InvocationType getType()
/*     */   {
/* 263 */     if (this.invocationType == null) return InvocationType.LOCAL;
/* 264 */     return this.invocationType;
/*     */   }
/*     */ 
/*     */   public void setId(Object id)
/*     */   {
/* 272 */     getPayload().put(InvocationKey.CACHE_ID, id);
/*     */   }
/*     */ 
/*     */   public Object getId()
/*     */   {
/* 277 */     return getPayloadValue(InvocationKey.CACHE_ID);
/*     */   }
/*     */ 
/*     */   public void setMethod(Method method)
/*     */   {
/* 285 */     this.method = method;
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/* 293 */     return this.method;
/*     */   }
/*     */ 
/*     */   public void setArguments(Object[] arguments)
/*     */   {
/* 301 */     this.args = arguments;
/*     */   }
/*     */ 
/*     */   public Object[] getArguments()
/*     */   {
/* 306 */     return this.args;
/*     */   }
/*     */ 
/*     */   public InvocationContext getInvocationContext()
/*     */   {
/* 311 */     return this.invocationContext;
/*     */   }
/*     */ 
/*     */   public void setInvocationContext(InvocationContext ctx)
/*     */   {
/* 316 */     this.invocationContext = ctx;
/*     */   }
/*     */ 
/*     */   public void setEnterpriseContext(Object ctx)
/*     */   {
/* 321 */     getTransientPayload().put(InvocationKey.ENTERPRISE_CONTEXT, ctx);
/*     */   }
/*     */ 
/*     */   public Object getEnterpriseContext()
/*     */   {
/* 326 */     return getTransientPayload().get(InvocationKey.ENTERPRISE_CONTEXT);
/*     */   }
/*     */ 
/*     */   public SecurityContext getSecurityContext()
/*     */   {
/* 331 */     return (SecurityContext)getAsIsPayload().get(InvocationKey.SECURITY_CONTEXT);
/*     */   }
/*     */ 
/*     */   public void setSecurityContext(SecurityContext sc)
/*     */   {
/* 336 */     getAsIsPayload().put(InvocationKey.SECURITY_CONTEXT, sc);
/*     */   }
/*     */ 
/*     */   public boolean isInterVM()
/*     */   {
/* 341 */     Boolean b = (Boolean)getAsIsPayload().get(InvocationKey.INTERVM);
/* 342 */     return (b != null) && (b == Boolean.TRUE);
/*     */   }
/*     */ 
/*     */   public void setInterVM(Boolean boolValue)
/*     */   {
/* 347 */     getAsIsPayload().put(InvocationKey.INTERVM, boolValue);
/*     */   }
/*     */ 
/*     */   public void setSecure(Boolean secure)
/*     */   {
/* 356 */     getAsIsPayload().put(InvocationKey.SECURE, secure);
/*     */   }
/*     */ 
/*     */   public Map getTransientPayload()
/*     */   {
/* 362 */     if (this.transient_payload == null) this.transient_payload = new HashMap();
/* 363 */     return this.transient_payload;
/*     */   }
/*     */ 
/*     */   public Map getAsIsPayload()
/*     */   {
/* 368 */     if (this.as_is_payload == null) this.as_is_payload = new HashMap();
/* 369 */     return this.as_is_payload;
/*     */   }
/*     */ 
/*     */   public Map getPayload()
/*     */   {
/* 374 */     if (this.payload == null) this.payload = new HashMap();
/* 375 */     return this.payload;
/*     */   }
/*     */ 
/*     */   public Object performCall(Object instance, Method m, Object[] arguments)
/*     */     throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, Exception
/*     */   {
/* 386 */     return m.invoke(instance, arguments);
/*     */   }
/*     */ 
/*     */   public boolean isLocal()
/*     */   {
/* 396 */     InvocationType type = getType();
/* 397 */     return (type == InvocationType.LOCAL) || (type == InvocationType.LOCALHOME) || (type == InvocationType.SERVICE_ENDPOINT);
/*     */   }
/*     */ 
/*     */   public Boolean isSecure()
/*     */   {
/* 407 */     return (Boolean)getAsIsPayload().get(InvocationKey.SECURE);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.Invocation
 * JD-Core Version:    0.6.0
 */