/*     */ package org.jboss.injection;
/*     */ 
/*     */ import java.lang.reflect.AccessibleObject;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.naming.Context;
/*     */ import javax.xml.ws.WebServiceRef;
/*     */ import javax.xml.ws.WebServiceRefs;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.javaee.jboss.JBossServiceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironment;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
/*     */ 
/*     */ public class WebServiceRefHandler<X extends RemoteEnvironment>
/*     */   implements InjectionHandler<X>
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(WebServiceRefHandler.class);
/*  50 */   private Map<String, ServiceReferenceMetaData> srefMap = new HashMap();
/*     */ 
/*     */   public void loadXml(X xml, InjectionContainer container)
/*     */   {
/*  54 */     if (xml == null) return;
/*  55 */     ServiceReferencesMetaData serviceRefs = xml.getServiceReferences();
/*  56 */     if (serviceRefs == null) return;
/*  57 */     for (ServiceReferenceMetaData sref : serviceRefs)
/*     */     {
/*  59 */       log.debug("service-ref: " + sref);
/*  60 */       if (this.srefMap.get(sref.getServiceRefName()) != null) {
/*  61 */         throw new IllegalStateException("Duplicate <service-ref-name> in " + sref);
/*     */       }
/*  63 */       this.srefMap.put(sref.getServiceRefName(), sref);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void handleClassAnnotations(Class<?> type, InjectionContainer container)
/*     */   {
/*  69 */     WebServiceRef wsref = (WebServiceRef)container.getAnnotation(WebServiceRef.class, type);
/*  70 */     if (wsref != null)
/*     */     {
/*  72 */       bindRefOnType(type, container, wsref);
/*     */     }
/*     */ 
/*  75 */     WebServiceRefs refs = (WebServiceRefs)container.getAnnotation(WebServiceRefs.class, type);
/*  76 */     if (refs != null)
/*     */     {
/*  78 */       for (WebServiceRef refItem : refs.value())
/*     */       {
/*  80 */         bindRefOnType(type, container, refItem);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void bindRefOnType(Class<?> type, InjectionContainer container, WebServiceRef wsref)
/*     */   {
/*  87 */     String name = wsref.name();
/*  88 */     if (name.equals("")) {
/*  89 */       name = InjectionUtil.getEncName(type).substring(4);
/*     */     }
/*  91 */     if (!container.getEncInjectors().containsKey(name))
/*     */     {
/*  93 */       String encName = "env/" + name;
/*  94 */       ServiceReferenceMetaData sref = getServiceRef(name);
/*  95 */       container.getEncInjectors().put(name, new ServiceRefInjector(encName, type, sref));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors)
/*     */   {
/* 101 */     WebServiceRef wsref = (WebServiceRef)method.getAnnotation(WebServiceRef.class);
/* 102 */     if (wsref == null) return;
/*     */ 
/* 104 */     if (!method.getName().startsWith("set")) {
/* 105 */       throw new RuntimeException("@WebServiceRef can only be used with a set method: " + method);
/*     */     }
/* 107 */     String name = wsref.name();
/* 108 */     if (name.equals("")) {
/* 109 */       name = InjectionUtil.getEncName(method).substring(4);
/*     */     }
/* 111 */     String encName = "env/" + name;
/* 112 */     Context encCtx = container.getEnc();
/* 113 */     if (!container.getEncInjectors().containsKey(name))
/*     */     {
/* 115 */       ServiceReferenceMetaData sref = getServiceRef(name);
/* 116 */       container.getEncInjectors().put(name, new ServiceRefInjector(encName, method, sref));
/*     */     }
/*     */ 
/* 119 */     injectors.put(method, new JndiMethodInjector(method, encName, encCtx));
/*     */   }
/*     */ 
/*     */   public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors)
/*     */   {
/* 124 */     WebServiceRef wsref = (WebServiceRef)field.getAnnotation(WebServiceRef.class);
/* 125 */     if (wsref == null) return;
/*     */ 
/* 127 */     String name = wsref.name();
/* 128 */     if (name.equals("")) {
/* 129 */       name = InjectionUtil.getEncName(field).substring(4);
/*     */     }
/* 131 */     String encName = "env/" + name;
/* 132 */     Context encCtx = container.getEnc();
/* 133 */     if (!container.getEncInjectors().containsKey(name))
/*     */     {
/* 135 */       ServiceReferenceMetaData sref = getServiceRef(name);
/* 136 */       container.getEncInjectors().put(name, new ServiceRefInjector(encName, field, sref));
/*     */     }
/*     */ 
/* 139 */     injectors.put(field, new JndiFieldInjector(field, encName, encCtx));
/*     */   }
/*     */ 
/*     */   private ServiceReferenceMetaData getServiceRef(String name)
/*     */   {
/* 144 */     ServiceReferenceMetaData sref = (ServiceReferenceMetaData)this.srefMap.get(name);
/* 145 */     if (sref == null)
/*     */     {
/* 147 */       log.debug("No override for @WebServiceRef.name: " + name);
/* 148 */       sref = new JBossServiceReferenceMetaData();
/* 149 */       sref.setServiceRefName(name);
/*     */     }
/* 151 */     return sref;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.WebServiceRefHandler
 * JD-Core Version:    0.6.0
 */