/*     */ package org.jboss.injection;
/*     */ 
/*     */ import java.lang.reflect.AccessibleObject;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.Collection;
/*     */ import java.util.Map;
/*     */ import javax.annotation.Resource;
/*     */ import javax.annotation.Resources;
/*     */ import javax.ejb.EJBContext;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.TimerService;
/*     */ import javax.transaction.UserTransaction;
/*     */ import javax.xml.ws.WebServiceContext;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.injection.lang.reflect.BeanProperty;
/*     */ import org.jboss.injection.lang.reflect.FieldBeanProperty;
/*     */ import org.jboss.injection.lang.reflect.MethodBeanProperty;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironment;
/*     */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
/*     */ import org.jboss.reflect.plugins.ValueConvertor;
/*     */ import org.omg.CORBA.ORB;
/*     */ 
/*     */ public class ResourceHandler<X extends RemoteEnvironment>
/*     */   implements InjectionHandler<X>
/*     */ {
/*     */   private static final Logger log;
/*     */   private boolean checkEncInjectors;
/*     */ 
/*     */   public ResourceHandler()
/*     */   {
/*  65 */     this(true);
/*     */   }
/*     */ 
/*     */   public ResourceHandler(boolean checkEncInjectors)
/*     */   {
/*  70 */     this.checkEncInjectors = checkEncInjectors;
/*     */   }
/*     */ 
/*     */   private void createURLInjector(String encName, String mappedName, InjectionContainer container)
/*     */   {
/*  75 */     assert (encName.length() > 0) : "encName is empty";
/*  76 */     assert (mappedName.length() > 0) : "mappedName is empty";
/*     */     try
/*     */     {
/*  81 */       URL url = new URL(mappedName.trim());
/*  82 */       container.getEncInjectors().put(encName, new ValueEncInjector(encName, url, "@Resource"));
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/*  86 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void loadEnvEntry(InjectionContainer container, Collection<EnvironmentEntryMetaData> envEntries)
/*     */   {
/*  92 */     for (EnvironmentEntryMetaData envEntry : envEntries)
/*     */     {
/*  94 */       String encName = "env/" + envEntry.getEnvEntryName();
/*     */ 
/*  97 */       if (envEntry.getValue() == null)
/*     */       {
/*  99 */         log.debug("ignoring env-entry " + envEntry);
/* 100 */         continue;
/*     */       }
/* 102 */       InjectionUtil.injectionTarget(encName, envEntry, container, container.getEncInjections());
/* 103 */       if (!container.getEncInjectors().containsKey(encName)) {
/* 104 */         log.trace("adding env-entry injector " + encName);
/* 105 */         container.getEncInjectors().put(encName, new EnvEntryEncInjector(encName, envEntry.getType(), envEntry.getValue()));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void loadXmlResourceRefs(InjectionContainer container, Collection<ResourceReferenceMetaData> refs) {
/* 111 */     for (ResourceReferenceMetaData envRef : refs)
/*     */     {
/* 113 */       String encName = "env/" + envRef.getResourceRefName();
/* 114 */       if (container.getEncInjectors().containsKey(encName)) {
/*     */         continue;
/*     */       }
/* 117 */       if ((envRef.getMappedName() == null) || (envRef.getMappedName().equals("")))
/*     */       {
/* 119 */         if (envRef.getResUrl() != null)
/*     */         {
/*     */           try
/*     */           {
/* 123 */             container.getEncInjectors().put(encName, new ValueEncInjector(encName, new URL(envRef.getResUrl().trim()), "<resource-ref>"));
/*     */           }
/*     */           catch (MalformedURLException e)
/*     */           {
/* 127 */             throw new RuntimeException(e);
/*     */           }
/*     */         }
/* 130 */         else if (UserTransaction.class.getName().equals(envRef.getType()))
/*     */         {
/* 132 */           InjectionContainer ic = container;
/* 133 */           InjectorFactory factory = new InjectorFactory(ic)
/*     */           {
/*     */             public UserTransactionPropertyInjector create(BeanProperty property)
/*     */             {
/* 137 */               return new UserTransactionPropertyInjector(property, this.val$ic);
/*     */             }
/*     */           };
/* 140 */           if (envRef.getInjectionTargets() != null)
/*     */           {
/* 142 */             InjectionUtil.createInjectors(container.getInjectors(), container.getClassloader(), factory, envRef.getInjectionTargets());
/* 143 */             continue;
/*     */           }
/*     */ 
/* 147 */           encName = "java:comp/UserTransaction";
/*     */         }
/* 150 */         else if (ORB.class.getName().equals(envRef.getType()))
/*     */         {
/* 152 */           encName = "java:comp/ORB";
/*     */         }
/*     */         else
/*     */         {
/* 156 */           throw new RuntimeException("mapped-name is required for " + envRef.getResourceRefName() + " of deployment " + container.getIdentifier());
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 161 */         container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, envRef.getMappedName(), "<resource-ref>"));
/*     */       }
/* 163 */       InjectionUtil.injectionTarget(encName, envRef, container, container.getEncInjections());
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void loadXmlResourceEnvRefs(InjectionContainer container, Collection<ResourceEnvironmentReferenceMetaData> refs)
/*     */   {
/* 169 */     for (ResourceEnvironmentReferenceMetaData envRef : refs)
/*     */     {
/* 173 */       String resTypeName = envRef.getType();
/* 174 */       String mappedName = envRef.getMappedName();
/*     */       try
/*     */       {
/* 177 */         if (resTypeName != null)
/*     */         {
/* 179 */           Class resType = Class.forName(resTypeName);
/* 180 */           if (EJBContext.class.isAssignableFrom(resType))
/*     */           {
/* 182 */             InjectorFactory factory = new InjectorFactory()
/*     */             {
/*     */               public EJBContextPropertyInjector create(BeanProperty property)
/*     */               {
/* 186 */                 return new EJBContextPropertyInjector(property);
/*     */               }
/*     */             };
/* 189 */             InjectionUtil.createInjectors(container.getInjectors(), container.getClassloader(), factory, envRef.getInjectionTargets());
/* 190 */             continue;
/*     */           }
/* 192 */           if (resType.equals(UserTransaction.class))
/*     */           {
/* 194 */             InjectionContainer ic = container;
/* 195 */             InjectorFactory factory = new InjectorFactory(ic)
/*     */             {
/*     */               public UserTransactionPropertyInjector create(BeanProperty property)
/*     */               {
/* 199 */                 return new UserTransactionPropertyInjector(property, this.val$ic);
/*     */               }
/*     */             };
/* 202 */             if (envRef.getInjectionTargets() != null)
/*     */             {
/* 204 */               InjectionUtil.createInjectors(container.getInjectors(), container.getClassloader(), factory, envRef.getInjectionTargets());
/* 205 */               continue;
/*     */             }
/*     */ 
/* 209 */             mappedName = "java:comp/UserTransaction";
/*     */           }
/* 212 */           else if (resType.equals(ORB.class))
/*     */           {
/* 214 */             mappedName = "java:comp/ORB";
/* 215 */             continue;
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 221 */         throw new EJBException(e);
/*     */       }
/*     */ 
/* 224 */       String encName = "env/" + envRef.getResourceEnvRefName();
/* 225 */       if (!container.getEncInjectors().containsKey(encName)) {
/* 226 */         if ((mappedName == null) || (mappedName.equals("")))
/*     */         {
/* 228 */           throw new RuntimeException("mapped-name is required for " + envRef.getResourceEnvRefName() + " of deployment " + container.getIdentifier());
/*     */         }
/* 230 */         container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, envRef.getMappedName(), "<resource-ref>"));
/* 231 */         InjectionUtil.injectionTarget(encName, envRef, container, container.getEncInjections());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void loadXmlMessageDestinationRefs(InjectionContainer container, Collection<MessageDestinationReferenceMetaData> refs) {
/* 237 */     for (MessageDestinationReferenceMetaData envRef : refs)
/*     */     {
/* 239 */       String encName = "env/" + envRef.getMessageDestinationRefName();
/* 240 */       if (!container.getEncInjectors().containsKey(encName)) {
/* 241 */         String jndiName = envRef.getMappedName();
/* 242 */         if ((jndiName == null) || (jndiName.equals("")))
/*     */         {
/* 245 */           String link = envRef.getLink();
/* 246 */           if (link != null)
/*     */           {
/* 248 */             jndiName = container.resolveMessageDestination(link);
/* 249 */             if (jndiName == null)
/* 250 */               throw new RuntimeException("message-destination-link not found " + link + " of deployment " + container.getIdentifier());
/*     */           }
/*     */           else
/*     */           {
/* 254 */             throw new RuntimeException("mapped-name or message-destination-link is required for " + envRef.getMessageDestinationRefName() + " of deployment " + container.getIdentifier());
/*     */           }
/*     */         }
/* 256 */         container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, jndiName, "<message-destination-ref>"));
/* 257 */         InjectionUtil.injectionTarget(encName, envRef, container, container.getEncInjections());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void loadXml(X xml, InjectionContainer container) {
/* 263 */     if (xml == null)
/* 264 */       return;
/* 265 */     if (xml.getMessageDestinationReferences() != null)
/* 266 */       loadXmlMessageDestinationRefs(container, xml.getMessageDestinationReferences());
/* 267 */     if (xml.getResourceEnvironmentReferences() != null)
/* 268 */       loadXmlResourceEnvRefs(container, xml.getResourceEnvironmentReferences());
/* 269 */     if (xml.getResourceReferences() != null)
/* 270 */       loadXmlResourceRefs(container, xml.getResourceReferences());
/* 271 */     if (xml.getEnvironmentEntries() != null)
/* 272 */       loadEnvEntry(container, xml.getEnvironmentEntries());
/*     */   }
/*     */ 
/*     */   public void handleClassAnnotations(Class<?> clazz, InjectionContainer container)
/*     */   {
/* 277 */     Resources resources = (Resources)container.getAnnotation(Resources.class, clazz);
/* 278 */     if (resources != null)
/*     */     {
/* 280 */       for (Resource ref : resources.value())
/*     */       {
/* 282 */         handleClassAnnotation(ref, container, clazz);
/*     */       }
/*     */     }
/* 285 */     Resource res = (Resource)container.getAnnotation(Resource.class, clazz);
/* 286 */     if (res != null) handleClassAnnotation(res, container, clazz);
/*     */   }
/*     */ 
/*     */   private void handleClassAnnotation(Resource ref, InjectionContainer container, Class<?> clazz)
/*     */   {
/* 291 */     String encName = ref.name();
/* 292 */     if ((encName == null) || (encName.equals("")))
/*     */     {
/* 294 */       throw new RuntimeException("JBoss requires name() for class level @Resource");
/*     */     }
/* 296 */     encName = "env/" + ref.name();
/* 297 */     if (container.getEncInjectors().containsKey(encName)) return;
/*     */ 
/* 299 */     String mappedName = ref.mappedName();
/* 300 */     if ((mappedName == null) || (mappedName.equals("")))
/*     */     {
/* 303 */       if (ORB.class.isAssignableFrom(ref.type()))
/*     */       {
/* 305 */         mappedName = "java:comp/ORB";
/*     */       }
/*     */     }
/* 308 */     if ((mappedName == null) || (mappedName.equals("")))
/*     */     {
/* 310 */       throw new RuntimeException("You did not specify a @Resource.mappedName() for name: " + ref.name() + ", class: " + clazz.getName() + " and there is no binding for that enc name in XML");
/*     */     }
/*     */ 
/* 314 */     if (ref.type() == URL.class)
/*     */     {
/* 316 */       createURLInjector(encName, mappedName, container);
/*     */     }
/*     */     else
/*     */     {
/* 320 */       container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, ref.mappedName(), "@Resource"));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors)
/*     */   {
/* 326 */     Resource ref = (Resource)container.getAnnotation(Resource.class, method);
/* 327 */     if (ref == null) return;
/*     */ 
/* 329 */     log.trace("method " + method + " has @Resource");
/*     */ 
/* 331 */     handlePropertyAnnotation(ref, new MethodBeanProperty(method), container, injectors);
/*     */   }
/*     */ 
/*     */   public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors)
/*     */   {
/* 423 */     Resource ref = (Resource)container.getAnnotation(Resource.class, field);
/* 424 */     if (ref == null) return;
/*     */ 
/* 426 */     log.trace("field " + field + " has @Resource");
/*     */ 
/* 428 */     handlePropertyAnnotation(ref, new FieldBeanProperty(field), container, injectors);
/*     */   }
/*     */ 
/*     */   private void handlePropertyAnnotation(Resource ref, BeanProperty property, InjectionContainer container, Map<AccessibleObject, Injector> injectors)
/*     */   {
/* 518 */     assert (ref != null);
/* 519 */     assert (property != null);
/* 520 */     assert (container != null);
/* 521 */     assert (injectors != null);
/*     */ 
/* 523 */     String encName = ref.name();
/* 524 */     if ((encName == null) || (encName.equals("")))
/*     */     {
/* 527 */       encName = property.getDeclaringClass().getName() + "/" + property.getName();
/*     */     }
/* 529 */     if (!encName.startsWith("env/"))
/*     */     {
/* 531 */       encName = "env/" + encName;
/*     */     }
/*     */ 
/* 534 */     AccessibleObject accObj = property.getAccessibleObject();
/*     */ 
/* 536 */     Class type = property.getType();
/* 537 */     if (!ref.type().equals(Object.class))
/*     */     {
/* 539 */       type = ref.type();
/*     */     }
/*     */ 
/* 542 */     if (type.equals(UserTransaction.class))
/*     */     {
/* 544 */       injectors.put(accObj, new UserTransactionPropertyInjector(property, container));
/*     */     }
/* 546 */     else if (type.equals(TimerService.class))
/*     */     {
/* 548 */       injectors.put(accObj, new TimerServicePropertyInjector(property, (Container)container));
/*     */     }
/* 550 */     else if ((type.equals(URL.class)) && (ref.mappedName() != null) && (ref.mappedName().length() > 0))
/*     */     {
/* 552 */       createURLInjector(encName, ref.mappedName(), container);
/* 553 */       injectors.put(accObj, new JndiPropertyInjector(property, encName, container.getEnc()));
/*     */     }
/* 555 */     else if (type.equals(WebServiceContext.class))
/*     */     {
/* 557 */       injectors.put(accObj, new WebServiceContextPropertyInjector(property));
/*     */     }
/* 559 */     else if ((type.equals(String.class)) || (type.equals(Character.class)) || (type.equals(Byte.class)) || (type.equals(Short.class)) || (type.equals(Integer.class)) || (type.equals(Long.class)) || (type.equals(Boolean.class)) || (type.equals(Double.class)) || (type.equals(Float.class)) || (type.isPrimitive()))
/*     */     {
/* 572 */       if (container.getEncInjectors().containsKey(encName))
/*     */       {
/* 574 */         injectors.put(accObj, new JndiPropertyInjector(property, encName, container.getEnc()));
/*     */       }
/* 576 */       else if ((ref.mappedName() != null) && (ref.mappedName().length() > 0))
/*     */       {
/* 579 */         String s = ref.mappedName().trim();
/*     */         try
/*     */         {
/* 582 */           Object value = ValueConvertor.convertValue(type, s);
/* 583 */           container.getEncInjectors().put(encName, new ValueEncInjector(encName, value, "@Resource"));
/* 584 */           injectors.put(accObj, new JndiPropertyInjector(property, encName, container.getEnc()));
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 588 */           throw new RuntimeException("Failed to convert: " + ref.mappedName() + " to type:" + type, t);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 593 */         log.warn("Not injecting " + property.getName() + ", no matching enc injector " + encName + " found");
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 598 */       if ((this.checkEncInjectors) && (!container.getEncInjectors().containsKey(encName)))
/*     */       {
/* 600 */         String mappedName = ref.mappedName();
/* 601 */         if ((mappedName == null) || (mappedName.equals("")))
/*     */         {
/* 610 */           if (ORB.class.isAssignableFrom(type))
/* 611 */             mappedName = "java:comp/ORB";
/* 612 */           else if (EJBContext.class.isAssignableFrom(type))
/* 613 */             mappedName = "java:comp/EJBContext";
/*     */           else
/* 615 */             throw new RuntimeException("You did not specify a @Resource.mappedName() on " + accObj + " and there is no binding for enc name " + encName + " in XML");
/*     */         }
/* 617 */         container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, mappedName, "@Resource"));
/*     */       }
/* 619 */       injectors.put(accObj, new JndiPropertyInjector(property, encName, container.getEnc()));
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  59 */     log = Logger.getLogger(ResourceHandler.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.ResourceHandler
 * JD-Core Version:    0.6.0
 */