/*    */ package org.jboss.injection;
/*    */ 
/*    */ import javax.naming.Context;
/*    */ import javax.naming.NamingException;
/*    */ import org.jboss.ejb3.BeanContext;
/*    */ import org.jboss.ejb3.JndiUtil;
/*    */ import org.jboss.injection.lang.reflect.BeanProperty;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class JndiPropertyInjector extends AbstractPropertyInjector
/*    */   implements PojoInjector
/*    */ {
/* 42 */   private static final Logger log = Logger.getLogger(JndiPropertyInjector.class);
/*    */   private String jndiName;
/*    */   private Context ctx;
/*    */ 
/*    */   public JndiPropertyInjector(BeanProperty property, String jndiName, Context ctx)
/*    */   {
/* 49 */     super(property);
/* 50 */     this.jndiName = jndiName;
/* 51 */     this.ctx = ctx;
/*    */   }
/*    */ 
/*    */   public void inject(BeanContext bctx)
/*    */   {
/* 56 */     inject(bctx, bctx.getInstance());
/*    */   }
/*    */ 
/*    */   public Class<?> getInjectionClass()
/*    */   {
/* 61 */     return this.property.getType();
/*    */   }
/*    */ 
/*    */   protected Object lookup(String jndiName)
/*    */   {
/* 66 */     Object dependency = null;
/*    */     try
/*    */     {
/* 70 */       dependency = JndiUtil.lookup(this.ctx, jndiName);
/*    */     }
/*    */     catch (NamingException e)
/*    */     {
/* 74 */       Throwable cause = e;
/* 75 */       while (cause.getCause() != null)
/* 76 */         cause = cause.getCause();
/* 77 */       throw new RuntimeException("Unable to inject jndi dependency: " + jndiName + " into property " + this.property + ": " + cause.getMessage(), e);
/*    */     }
/* 79 */     return dependency;
/*    */   }
/*    */ 
/*    */   public void inject(BeanContext bctx, Object instance)
/*    */   {
/* 84 */     inject(instance);
/*    */   }
/*    */ 
/*    */   public void inject(Object instance)
/*    */   {
/* 89 */     Object value = lookup(this.jndiName);
/* 90 */     log.trace("injecting " + value + " from " + this.jndiName + " into " + this.property + " of " + instance);
/* 91 */     this.property.set(instance, value);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.JndiPropertyInjector
 * JD-Core Version:    0.6.0
 */