/*    */ package org.jboss.injection;
/*    */ 
/*    */ import java.lang.reflect.AccessibleObject;
/*    */ import java.lang.reflect.Field;
/*    */ import java.lang.reflect.Method;
/*    */ import java.util.Map;
/*    */ import org.jboss.ejb3.annotation.JndiInject;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
/*    */ import org.jboss.metadata.javaee.jboss.JndiRefMetaData;
/*    */ import org.jboss.metadata.javaee.jboss.JndiRefsMetaData;
/*    */ import org.jboss.metadata.javaee.spec.RemoteEnvironment;
/*    */ 
/*    */ public class JndiInjectHandler<X extends RemoteEnvironment>
/*    */   implements InjectionHandler<X>
/*    */ {
/* 45 */   private static final Logger log = Logger.getLogger(JndiInjectHandler.class);
/*    */ 
/*    */   public void loadXml(X xml, InjectionContainer container)
/*    */   {
/* 49 */     if (xml == null) return;
/* 50 */     if (!(xml instanceof JBossEnterpriseBeanMetaData)) return;
/* 51 */     JndiRefsMetaData jndiRefs = ((JBossEnterpriseBeanMetaData)xml).getJndiRefs();
/* 52 */     if (jndiRefs == null) return;
/* 53 */     for (JndiRefMetaData ref : jndiRefs)
/*    */     {
/* 55 */       if ((ref.getMappedName() == null) || (ref.getMappedName().equals(""))) {
/* 56 */         throw new RuntimeException("mapped-name is required for " + ref.getJndiRefName() + " of container " + container.getIdentifier());
/*    */       }
/* 58 */       String encName = "env/" + ref.getJndiRefName();
/* 59 */       if (!container.getEncInjectors().containsKey(encName))
/*    */       {
/* 61 */         container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, ref.getMappedName(), "jndi ref"));
/*    */       }
/* 63 */       InjectionUtil.injectionTarget(encName, ref, container, container.getEncInjections());
/*    */     }
/*    */   }
/*    */ 
/*    */   public void handleClassAnnotations(Class<?> clazz, InjectionContainer container)
/*    */   {
/*    */   }
/*    */ 
/*    */   public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors)
/*    */   {
/* 74 */     JndiInject ref = (JndiInject)method.getAnnotation(JndiInject.class);
/* 75 */     if (ref != null)
/*    */     {
/* 77 */       if (!method.getName().startsWith("set"))
/* 78 */         throw new RuntimeException("@EJB can only be used with a set method: " + method);
/* 79 */       String encName = InjectionUtil.getEncName(method);
/* 80 */       if (!container.getEncInjectors().containsKey(encName))
/*    */       {
/* 82 */         container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, ref.jndiName(), "@JndiInject"));
/*    */       }
/* 84 */       injectors.put(method, new JndiMethodInjector(method, encName, container.getEnc()));
/*    */     }
/*    */   }
/*    */ 
/*    */   public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors)
/*    */   {
/* 90 */     JndiInject ref = (JndiInject)field.getAnnotation(JndiInject.class);
/* 91 */     if (ref != null)
/*    */     {
/* 93 */       String encName = InjectionUtil.getEncName(field);
/* 94 */       if (!container.getEncInjectors().containsKey(encName))
/*    */       {
/* 96 */         container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, ref.jndiName(), "@JndiInject"));
/*    */       }
/* 98 */       injectors.put(field, new JndiFieldInjector(field, encName, container.getEnc()));
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.JndiInjectHandler
 * JD-Core Version:    0.6.0
 */