package org.jboss.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.virtual.VirtualFile;

public abstract interface InjectionContainer
{
  public abstract String getIdentifier();

  public abstract String getDeploymentDescriptorType();

  public abstract ClassLoader getClassloader();

  public abstract Map<String, EncInjector> getEncInjectors();

  public abstract Map<String, Map<AccessibleObject, Injector>> getEncInjections();

  public abstract List<Injector> getInjectors();

  public abstract VirtualFile getRootFile();

  public abstract Context getEnc();

  public abstract PersistenceUnitDeployment getPersistenceUnitDeployment(String paramString)
    throws NameNotFoundException;

  public abstract Container resolveEjbContainer(String paramString, Class<?> paramClass);

  public abstract Container resolveEjbContainer(Class<?> paramClass)
    throws NameNotFoundException;

  public abstract String getEjbJndiName(Class<?> paramClass)
    throws NameNotFoundException;

  public abstract String getEjbJndiName(String paramString, Class<?> paramClass);

  public abstract String resolveMessageDestination(String paramString);

  public abstract <T extends Annotation> T getAnnotation(Class<T> paramClass, Class<?> paramClass1);

  public abstract <T extends Annotation> T getAnnotation(Class<T> paramClass, Class<?> paramClass1, Method paramMethod);

  public abstract <T extends Annotation> T getAnnotation(Class<T> paramClass, Method paramMethod);

  public abstract <T extends Annotation> T getAnnotation(Class<T> paramClass, Class<?> paramClass1, Field paramField);

  public abstract <T extends Annotation> T getAnnotation(Class<T> paramClass, Field paramField);

  public abstract DependencyPolicy getDependencyPolicy();

  public abstract RemoteEnvironment getEnvironmentRefGroup();

  public abstract boolean hasJNDIBinding(String paramString);
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.InjectionContainer
 * JD-Core Version:    0.6.0
 */