/*    */ package org.jboss.injection;
/*    */ 
/*    */ import javax.naming.Context;
/*    */ import javax.naming.LinkRef;
/*    */ import javax.naming.NameNotFoundException;
/*    */ import javax.naming.NamingException;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.naming.Util;
/*    */ 
/*    */ public class EjbEncInjector
/*    */   implements EncInjector
/*    */ {
/* 40 */   private static final Logger log = Logger.getLogger(EjbEncInjector.class);
/*    */   private String ejbLink;
/*    */   private Class refClass;
/*    */   private String jndiName;
/*    */   private String error;
/*    */   private String encName;
/*    */ 
/*    */   public EjbEncInjector(String name, String mappedName, String error)
/*    */   {
/* 50 */     this.jndiName = mappedName;
/* 51 */     this.error = error;
/* 52 */     this.encName = name;
/*    */   }
/*    */ 
/*    */   public EjbEncInjector(String name, Class refClass, String ejbLink, String error)
/*    */   {
/* 57 */     this.refClass = refClass;
/* 58 */     this.ejbLink = ejbLink;
/* 59 */     this.error = error;
/* 60 */     this.encName = name;
/* 61 */     if ((refClass == null) && (ejbLink == null))
/* 62 */       throw new RuntimeException("cannot have null refClass and ejbLink for encName: " + name);
/*    */   }
/*    */ 
/*    */   public void inject(InjectionContainer container)
/*    */   {
/* 68 */     if ((this.jndiName == null) || (this.jndiName.equals("")))
/*    */     {
/* 70 */       if ((this.ejbLink != null) && (!"".equals(this.ejbLink)))
/*    */       {
/* 72 */         this.jndiName = container.getEjbJndiName(this.ejbLink, this.refClass);
/*    */       }
/*    */       else
/*    */       {
/*    */         try
/*    */         {
/* 78 */           if (this.refClass != null)
/*    */           {
/* 80 */             this.jndiName = container.getEjbJndiName(this.refClass);
/*    */           }
/*    */           else
/*    */           {
/* 84 */             throw new RuntimeException("searching for @EJB" + this.encName + " has null refClass and null ejbLink.");
/*    */           }
/*    */         }
/*    */         catch (NameNotFoundException e)
/*    */         {
/* 89 */           throw new RuntimeException("could not resolve global JNDI name for " + this.error + " for container " + container.getIdentifier() + ": reference class: " + this.refClass.getName() + " ejbLink: " + this.ejbLink + " " + e.getMessage());
/*    */         }
/*    */       }
/*    */     }
/*    */     try
/*    */     {
/* 95 */       if (this.jndiName == null)
/* 96 */         throw new RuntimeException("Failed to populate ENC: " + this.encName + " global jndi name was null");
/* 97 */       log.debug(" " + this.encName + " --> " + this.jndiName);
/* 98 */       Context enc = container.getEnc();
/* 99 */       Util.rebind(enc, this.encName, new LinkRef(this.jndiName));
/*    */     }
/*    */     catch (NamingException e)
/*    */     {
/* 103 */       throw new RuntimeException("could not bind enc name '" + this.encName + "' for " + this.error + " for container " + container.getIdentifier() + ": reference class: " + this.refClass.getName() + " ejbLink: " + this.ejbLink + " " + e.getMessage());
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.EjbEncInjector
 * JD-Core Version:    0.6.0
 */