/*     */ package org.jboss.injection;
/*     */ 
/*     */ import java.lang.reflect.AccessibleObject;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.Map;
/*     */ import javax.ejb.EJB;
/*     */ import javax.ejb.EJBs;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.annotation.IgnoreDependency;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.javaee.spec.AbstractEJBReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironment;
/*     */ 
/*     */ public class EJBRemoteHandler<X extends RemoteEnvironment> extends EJBInjectionHandler<X>
/*     */ {
/*  50 */   private static final Logger log = Logger.getLogger(EJBRemoteHandler.class);
/*     */ 
/*     */   public void loadXml(X xml, InjectionContainer container)
/*     */   {
/*  54 */     if (xml != null)
/*     */     {
/*  56 */       log.trace("ejbRefs = " + xml.getEjbReferences());
/*  57 */       if (xml.getEjbReferences() != null) loadEjbRefXml(xml.getEjbReferences(), container);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void loadEjbRefXml(Collection<EJBReferenceMetaData> refs, InjectionContainer container)
/*     */   {
/*  63 */     for (EJBReferenceMetaData ref : refs)
/*     */     {
/*  65 */       String interfaceName = ref.getRemote();
/*  66 */       String errorType = "<ejb-ref>";
/*     */ 
/*  68 */       ejbRefXml(ref, interfaceName, container, errorType);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void ejbRefXml(AbstractEJBReferenceMetaData ref, String interfaceName, InjectionContainer container, String errorType)
/*     */   {
/*  74 */     String encName = "env/" + ref.getEjbRefName();
/*  75 */     InjectionUtil.injectionTarget(encName, ref, container, container.getEncInjections());
/*  76 */     if (container.getEncInjectors().containsKey(encName)) {
/*  77 */       return;
/*     */     }
/*  79 */     String mappedName = ref.getMappedName();
/*  80 */     if ((mappedName != null) && (mappedName.equals(""))) mappedName = null;
/*     */ 
/*  82 */     String link = ref.getLink();
/*  83 */     if ((link != null) && (link.trim().equals(""))) link = null;
/*     */ 
/*  85 */     Class refClass = null;
/*     */ 
/*  87 */     if (interfaceName != null)
/*     */     {
/*     */       try
/*     */       {
/*  91 */         refClass = container.getClassloader().loadClass(interfaceName);
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/*  95 */         throw new RuntimeException("could not find " + errorType + "'s local interface " + interfaceName + " in " + container.getDeploymentDescriptorType() + " of " + container.getIdentifier());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 101 */     if ((mappedName != null) || (refClass != null) || (link != null))
/*     */     {
/* 108 */       ejbRefEncInjector(mappedName, encName, refClass, link, errorType, container);
/* 109 */       if (ref.getIgnoreDependency() != null)
/*     */       {
/* 111 */         log.debug("IGNORING <ejb-ref> DEPENDENCY: " + encName);
/* 112 */         return;
/*     */       }
/*     */ 
/* 115 */       ejbRefDependency(mappedName, link, container, refClass, errorType, encName);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void ejbRefDependency(String mappedName, String link, InjectionContainer container, Class<?> refClass, String errorType, String encName)
/*     */   {
/* 121 */     if ((mappedName != null) && (mappedName.length() == 0)) mappedName = null;
/* 122 */     if ((refClass != null) && ((refClass.equals(Object.class)) || (refClass.equals(Void.TYPE)))) refClass = null;
/*     */ 
/* 124 */     if (mappedName != null)
/*     */     {
/* 126 */       addJNDIDependency(container, mappedName);
/* 127 */       return;
/*     */     }
/*     */ 
/* 130 */     if (refClass != null)
/*     */     {
/* 132 */       if ((link != null) && (!link.trim().equals("")))
/*     */       {
/* 134 */         addDependency(container, link, refClass);
/*     */       }
/*     */       else
/*     */       {
/* 138 */         addDependency(container, refClass);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 143 */       String msg = "IGNORING DEPENDENCY: unable to resolve dependency of EJB, there is too little information";
/* 144 */       log.warn(msg);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void ejbRefEncInjector(String mappedName, String encName, Class refClass, String link, String errorType, InjectionContainer container)
/*     */   {
/* 150 */     if ((refClass != null) && ((refClass.equals(Object.class)) || (refClass.equals(Void.TYPE)))) refClass = null;
/* 151 */     if ((mappedName != null) && (mappedName.trim().equals(""))) mappedName = null;
/*     */ 
/* 153 */     EncInjector injector = null;
/*     */ 
/* 155 */     if (mappedName == null)
/*     */     {
/* 157 */       injector = new EjbEncInjector(encName, refClass, link, errorType);
/*     */     }
/*     */     else
/*     */     {
/* 161 */       injector = new EjbEncInjector(encName, mappedName, errorType);
/*     */     }
/*     */ 
/* 164 */     container.getEncInjectors().put(encName, injector);
/*     */   }
/*     */ 
/*     */   public static EJBContainer getEjbContainer(EJB ref, InjectionContainer container, Class<?> memberType)
/*     */   {
/* 169 */     EJBContainer rtn = null;
/*     */ 
/* 171 */     if ((ref.mappedName() != null) && (!"".equals(ref.mappedName())))
/*     */     {
/* 173 */       return null;
/*     */     }
/*     */ 
/* 176 */     if ((ref.beanName().equals("")) && (memberType == null)) {
/* 177 */       throw new RuntimeException("For deployment " + container.getIdentifier() + "not enough information for @EJB.  Please fill out the beanName and/or businessInterface attributes");
/*     */     }
/* 179 */     Class businessInterface = memberType;
/* 180 */     if (!ref.beanInterface().getName().equals(Object.class.getName()))
/*     */     {
/* 182 */       businessInterface = ref.beanInterface();
/*     */     }
/*     */ 
/* 185 */     if (ref.beanName().equals(""))
/*     */     {
/*     */       try
/*     */       {
/* 189 */         rtn = (EJBContainer)container.resolveEjbContainer(businessInterface);
/*     */       }
/*     */       catch (NameNotFoundException e)
/*     */       {
/* 193 */         log.warn("For deployment " + container.getIdentifier() + " could not find jndi binding based on interface only for @EJB(" + businessInterface.getName() + ") " + e.getMessage());
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 198 */       rtn = (EJBContainer)container.resolveEjbContainer(ref.beanName(), businessInterface);
/*     */     }
/*     */ 
/* 201 */     return rtn;
/*     */   }
/*     */ 
/*     */   public static String getJndiName(EJB ref, InjectionContainer container, Class<?> memberType)
/*     */   {
/* 208 */     if ((ref.mappedName() != null) && (!"".equals(ref.mappedName())))
/*     */     {
/* 210 */       return ref.mappedName();
/*     */     }
/*     */ 
/* 213 */     if ((ref.beanName().equals("")) && (memberType == null)) {
/* 214 */       throw new RuntimeException("For deployment " + container.getIdentifier() + "not enough information for @EJB.  Please fill out the beanName and/or businessInterface attributes");
/*     */     }
/* 216 */     Class businessInterface = memberType;
/* 217 */     if (!ref.beanInterface().getName().equals(Object.class.getName()))
/*     */     {
/* 219 */       businessInterface = ref.beanInterface();
/*     */     }
/*     */     String jndiName;
/* 222 */     if (ref.beanName().equals("")) {
/*     */       String jndiName;
/*     */       try {
/* 226 */         jndiName = container.getEjbJndiName(businessInterface);
/*     */       }
/*     */       catch (NameNotFoundException e)
/*     */       {
/* 230 */         throw new RuntimeException("For deployment " + container.getIdentifier() + " could not find jndi binding based on interface only for @EJB(" + businessInterface.getName() + ") " + e.getMessage());
/*     */       }
/* 232 */       if (jndiName == null)
/*     */       {
/* 234 */         throw new RuntimeException("For deployment " + container.getIdentifier() + " could not find jndi binding based on interface only for @EJB(" + businessInterface.getName() + ")");
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 239 */       jndiName = container.getEjbJndiName(ref.beanName(), businessInterface);
/* 240 */       if (jndiName == null)
/*     */       {
/* 242 */         throw new RuntimeException("For EJB " + container.getIdentifier() + "could not find jndi binding based on beanName and business interface for @EJB(" + ref.beanName() + ", " + businessInterface.getName() + ")");
/*     */       }
/*     */     }
/*     */ 
/* 246 */     return jndiName;
/*     */   }
/*     */ 
/*     */   public void handleClassAnnotations(Class<?> clazz, InjectionContainer container)
/*     */   {
/* 251 */     EJBs ref = (EJBs)container.getAnnotation(EJBs.class, clazz);
/* 252 */     if (ref != null)
/*     */     {
/* 254 */       EJB[] ejbs = ref.value();
/*     */ 
/* 256 */       for (EJB ejb : ejbs)
/*     */       {
/* 258 */         handleClassAnnotation(ejb, clazz, container);
/*     */       }
/*     */     }
/* 261 */     EJB ejbref = (EJB)container.getAnnotation(EJB.class, clazz);
/* 262 */     if (ejbref != null) handleClassAnnotation(ejbref, clazz, container);
/*     */   }
/*     */ 
/*     */   protected void handleClassAnnotation(EJB ejb, Class<?> clazz, InjectionContainer container)
/*     */   {
/* 267 */     String encName = ejb.name();
/* 268 */     if ((encName == null) || (encName.equals("")))
/*     */     {
/* 270 */       throw new RuntimeException("JBoss requires the name of the @EJB in the @EJBs: " + clazz);
/*     */     }
/* 272 */     encName = "env/" + encName;
/*     */ 
/* 274 */     if (container.getEncInjectors().containsKey(encName)) return;
/* 275 */     ejbRefEncInjector(ejb.mappedName(), encName, ejb.beanInterface(), ejb.beanName(), "@EJB", container);
/*     */ 
/* 279 */     if (isIgnoreDependency(container, ejb))
/* 280 */       log.debug("IGNORING <ejb-ref> DEPENDENCY: " + encName);
/*     */     else
/* 282 */       ejbRefDependency(ejb.mappedName(), ejb.beanName(), container, ejb.beanInterface(), "@EJB", encName);
/*     */   }
/*     */ 
/*     */   public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors)
/*     */   {
/* 287 */     EJB ref = (EJB)container.getAnnotation(EJB.class, method);
/* 288 */     if (ref != null)
/*     */     {
/* 290 */       if (!method.getName().startsWith("set"))
/* 291 */         throw new RuntimeException("@EJB can only be used with a set method: " + method);
/* 292 */       String encName = getEncName(ref, method);
/* 293 */       if (!container.getEncInjectors().containsKey(encName))
/*     */       {
/* 295 */         ejbRefEncInjector(ref.mappedName(), encName, method.getParameterTypes()[0], ref.beanName(), "@EJB", container);
/*     */ 
/* 297 */         if (container.getAnnotation(IgnoreDependency.class, method) == null)
/*     */         {
/* 299 */           if (isIgnoreDependency(container, ref))
/* 300 */             log.debug("IGNORING <ejb-ref> DEPENDENCY: " + encName);
/*     */           else {
/* 302 */             ejbRefDependency(ref.mappedName(), ref.beanName(), container, method.getParameterTypes()[0], "@EJB", encName);
/*     */           }
/*     */         }
/*     */       }
/* 306 */       super.handleMethodAnnotations(method, container, injectors);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors)
/*     */   {
/* 312 */     EJB ref = (EJB)container.getAnnotation(EJB.class, field);
/* 313 */     if (ref != null)
/*     */     {
/* 315 */       String encName = getEncName(ref, field);
/* 316 */       if (!container.getEncInjectors().containsKey(encName))
/*     */       {
/* 318 */         if (container.getAnnotation(IgnoreDependency.class, field) == null)
/*     */         {
/* 320 */           if (isIgnoreDependency(container, ref))
/* 321 */             log.debug("IGNORING <ejb-ref> DEPENDENCY: " + encName);
/*     */           else
/* 323 */             ejbRefDependency(ref.mappedName(), ref.beanName(), container, field.getType(), "@EJB", encName);
/*     */         }
/* 325 */         ejbRefEncInjector(ref.mappedName(), encName, field.getType(), ref.beanName(), "@EJB", container);
/*     */       }
/* 327 */       super.handleFieldAnnotations(field, container, injectors);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean isIgnoreDependency(InjectionContainer container, EJB ref)
/*     */   {
/* 333 */     RemoteEnvironment refGroup = container.getEnvironmentRefGroup();
/*     */ 
/* 335 */     if (refGroup != null)
/*     */     {
/* 337 */       if (refGroup.getEjbReferences() != null) {
/* 338 */         for (EJBReferenceMetaData ejbRef : refGroup.getEjbReferences())
/*     */         {
/* 340 */           if (ejbRef.getEjbRefName().equals(ref.name()))
/*     */           {
/* 342 */             return ejbRef.getIgnoreDependency() != null;
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 349 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.EJBRemoteHandler
 * JD-Core Version:    0.6.0
 */