/*    */ package org.jboss.injection;
/*    */ 
/*    */ import java.lang.reflect.InvocationTargetException;
/*    */ import java.lang.reflect.Method;
/*    */ import java.util.ArrayList;
/*    */ import javax.management.MBeanServer;
/*    */ import javax.management.MBeanServerFactory;
/*    */ import javax.management.ObjectName;
/*    */ import org.jboss.ejb3.BeanContext;
/*    */ import org.jboss.mx.util.MBeanProxyExt;
/*    */ 
/*    */ public class DependsMethodInjector
/*    */   implements Injector
/*    */ {
/*    */   Method method;
/*    */   ObjectName on;
/*    */ 
/*    */   public DependsMethodInjector(Method method, ObjectName on)
/*    */   {
/* 43 */     this.method = method;
/* 44 */     this.on = on;
/* 45 */     method.setAccessible(true);
/*    */   }
/*    */ 
/*    */   public void inject(BeanContext ctx)
/*    */   {
/* 50 */     Object instance = ctx.getInstance();
/* 51 */     inject(instance);
/*    */   }
/*    */ 
/*    */   public void inject(Object instance)
/*    */   {
/* 56 */     Class clazz = this.method.getParameterTypes()[0];
/* 57 */     Object value = null;
/*    */ 
/* 59 */     if (clazz == ObjectName.class)
/*    */     {
/* 61 */       value = this.on;
/*    */     }
/*    */     else
/*    */     {
/* 65 */       MBeanServer server = (MBeanServer)MBeanServerFactory.findMBeanServer(null).get(0);
/* 66 */       value = MBeanProxyExt.create(clazz, this.on, server);
/*    */     }
/*    */ 
/*    */     try
/*    */     {
/* 71 */       this.method.invoke(instance, new Object[] { value });
/*    */     }
/*    */     catch (InvocationTargetException e)
/*    */     {
/* 75 */       throw new RuntimeException(e);
/*    */     }
/*    */     catch (IllegalAccessException e)
/*    */     {
/* 79 */       throw new RuntimeException(e);
/*    */     }
/*    */   }
/*    */ 
/*    */   public Class getInjectionClass()
/*    */   {
/* 85 */     return this.method.getParameterTypes()[0];
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.DependsMethodInjector
 * JD-Core Version:    0.6.0
 */