/*     */ package org.jboss.injection;
/*     */ 
/*     */ import java.lang.reflect.AccessibleObject;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Map;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.ejb3.DependencyPolicy;
/*     */ import org.jboss.ejb3.annotation.Depends;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironment;
/*     */ 
/*     */ public class DependsHandler<X extends RemoteEnvironment>
/*     */   implements InjectionHandler<X>
/*     */ {
/*  43 */   private static final Logger log = Logger.getLogger(DependsHandler.class);
/*     */ 
/*     */   public void loadXml(X xml, InjectionContainer container)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors)
/*     */   {
/*  51 */     Depends dep = (Depends)container.getAnnotation(Depends.class, method.getDeclaringClass(), method);
/*  52 */     if (dep != null)
/*     */     {
/*  54 */       if (!method.getName().startsWith("set"))
/*  55 */         throw new RuntimeException("@EJB can only be used with a set method: " + method);
/*  56 */       String[] names = dep.value();
/*  57 */       if (names.length != 1)
/*  58 */         throw new RuntimeException("@Depends on a field can only take one object name: " + method);
/*  59 */       ObjectName on = null;
/*     */       try
/*     */       {
/*  62 */         on = new ObjectName(names[0]);
/*     */       }
/*     */       catch (MalformedObjectNameException e)
/*     */       {
/*  66 */         throw new RuntimeException(e);
/*     */       }
/*     */ 
/*  70 */       if (injectors.get(method) == null) {
/*  71 */         injectors.put(method, new DependsMethodInjector(method, on));
/*     */       }
/*  73 */       container.getDependencyPolicy().addDependency(names[0]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors)
/*     */   {
/*  79 */     Depends dep = (Depends)container.getAnnotation(Depends.class, field.getDeclaringClass(), field);
/*  80 */     if (dep != null)
/*     */     {
/*  82 */       String[] names = dep.value();
/*  83 */       if (names.length != 1)
/*  84 */         throw new RuntimeException("@Depends on a field can only take one object name: " + field);
/*  85 */       ObjectName on = null;
/*     */       try
/*     */       {
/*  88 */         on = new ObjectName(names[0]);
/*     */       }
/*     */       catch (MalformedObjectNameException e)
/*     */       {
/*  92 */         throw new RuntimeException(e);
/*     */       }
/*     */ 
/*  96 */       if (injectors.get(field) == null) {
/*  97 */         injectors.put(field, new DependsFieldInjector(field, on));
/*     */       }
/*  99 */       container.getDependencyPolicy().addDependency(names[0]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void handleClassAnnotations(Class<?> clazz, InjectionContainer container)
/*     */   {
/* 105 */     Depends dep = (Depends)container.getAnnotation(Depends.class, clazz);
/* 106 */     if (dep == null) return;
/* 107 */     for (String dependency : dep.value())
/*     */     {
/* 109 */       container.getDependencyPolicy().addDependency(dependency);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.DependsHandler
 * JD-Core Version:    0.6.0
 */