/*    */ package org.jboss.injection;
/*    */ 
/*    */ import javax.naming.NameNotFoundException;
/*    */ import org.jboss.ejb3.EJBContainer;
/*    */ import org.jboss.ejb3.deployers.JBoss5DependencyPolicy;
/*    */ import org.jboss.metadata.javaee.spec.RemoteEnvironment;
/*    */ 
/*    */ public abstract class AbstractHandler<X extends RemoteEnvironment>
/*    */   implements InjectionHandler<X>
/*    */ {
/*    */   protected void addDependency(InjectionContainer container, Class businessIntf)
/*    */   {
/* 47 */     EJBContainer refCon = null;
/*    */     try
/*    */     {
/* 50 */       refCon = (EJBContainer)container.resolveEjbContainer(businessIntf);
/*    */     }
/*    */     catch (NameNotFoundException e)
/*    */     {
/*    */     }
/*    */ 
/* 57 */     if (container.equals(refCon)) {
/* 58 */       return;
/*    */     }
/* 60 */     ((JBoss5DependencyPolicy)container.getDependencyPolicy()).addDependency(businessIntf);
/*    */   }
/*    */ 
/*    */   protected void addDependency(InjectionContainer container, String link, Class<?> businessIntf)
/*    */   {
/* 65 */     EJBContainer refCon = (EJBContainer)container.resolveEjbContainer(link, businessIntf);
/*    */ 
/* 68 */     if (container.equals(refCon)) {
/* 69 */       return;
/*    */     }
/* 71 */     ((JBoss5DependencyPolicy)container.getDependencyPolicy()).addDependency(link, businessIntf);
/*    */   }
/*    */ 
/*    */   protected void addJNDIDependency(InjectionContainer container, String jndiName)
/*    */   {
/* 77 */     if (container.hasJNDIBinding(jndiName))
/* 78 */       return;
/* 79 */     ClassLoader loader = container.getClassloader();
/* 80 */     ((JBoss5DependencyPolicy)container.getDependencyPolicy()).addJNDIName(jndiName, loader);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.AbstractHandler
 * JD-Core Version:    0.6.0
 */