/*     */ package org.jboss.iiop.rmi.marshal.strategy;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.UnexpectedException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.rmi.PortableRemoteObject;
/*     */ import org.jboss.iiop.rmi.marshal.CDRStream;
/*     */ import org.jboss.iiop.rmi.marshal.CDRStreamReader;
/*     */ import org.jboss.iiop.rmi.marshal.CDRStreamWriter;
/*     */ import org.omg.CORBA.UserException;
/*     */ import org.omg.CORBA.portable.IDLEntity;
/*     */ import org.omg.CORBA_2_3.portable.OutputStream;
/*     */ 
/*     */ public class StubStrategy
/*     */ {
/*     */   private CDRStreamWriter[] paramWriters;
/*     */   private List exceptionList;
/*     */   private Map exceptionMap;
/*     */   private CDRStreamReader retvalReader;
/*     */   private Class retvalRemoteInterface;
/*     */ 
/*     */   public static StubStrategy forMethod(String[] paramTypes, String[] excepIds, String[] excepTypes, String retvalType, ClassLoader cl)
/*     */   {
/* 115 */     return new StubStrategy(paramTypes, excepIds, excepTypes, retvalType, cl);
/*     */   }
/*     */ 
/*     */   private StubStrategy(String[] paramTypes, String[] excepIds, String[] excepTypes, String retvalType, ClassLoader cl)
/*     */   {
/* 145 */     if (cl == null) {
/* 146 */       cl = Thread.currentThread().getContextClassLoader();
/*     */     }
/*     */ 
/* 150 */     int len = paramTypes.length;
/* 151 */     this.paramWriters = new CDRStreamWriter[len];
/* 152 */     for (int i = 0; i < len; i++) {
/* 153 */       this.paramWriters[i] = CDRStream.writerFor(paramTypes[i], cl);
/*     */     }
/*     */ 
/* 157 */     this.exceptionList = new ArrayList();
/* 158 */     this.exceptionMap = new HashMap();
/* 159 */     len = excepIds.length;
/* 160 */     for (int i = 0; i < len; i++) {
/*     */       try {
/* 162 */         Class clz = cl.loadClass(excepTypes[i]);
/* 163 */         this.exceptionList.add(clz);
/* 164 */         ExceptionReader exceptionReader = new ExceptionReader(clz, excepIds[i]);
/*     */ 
/* 166 */         this.exceptionMap.put(exceptionReader.getReposId(), exceptionReader);
/*     */       }
/*     */       catch (ClassNotFoundException e) {
/* 169 */         throw new RuntimeException("Error loading class " + excepTypes[i] + ": " + e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 175 */     this.retvalReader = CDRStream.readerFor(retvalType, cl);
/*     */ 
/* 178 */     if (retvalType.charAt(0) == 'R')
/*     */       try {
/* 180 */         this.retvalRemoteInterface = cl.loadClass(retvalType.substring(1));
/*     */       }
/*     */       catch (ClassNotFoundException e) {
/* 183 */         throw new RuntimeException("Error loading class " + retvalType.substring(1) + ": " + e);
/*     */       }
/*     */   }
/*     */ 
/*     */   public void writeParams(OutputStream out, Object[] params)
/*     */   {
/* 199 */     int len = params.length;
/*     */ 
/* 201 */     if (len != this.paramWriters.length) {
/* 202 */       throw new RuntimeException("Cannot marshal parameters: unexpected number of parameters");
/*     */     }
/*     */ 
/* 205 */     for (int i = 0; i < len; i++)
/* 206 */       this.paramWriters[i].write(out, params[i]);
/*     */   }
/*     */ 
/*     */   public boolean isNonVoid()
/*     */   {
/* 215 */     return this.retvalReader != null;
/*     */   }
/*     */ 
/*     */   public Object readRetval(org.omg.CORBA_2_3.portable.InputStream in)
/*     */   {
/* 226 */     return this.retvalReader.read(in);
/*     */   }
/*     */ 
/*     */   public Exception readException(String id, org.omg.CORBA_2_3.portable.InputStream in)
/*     */   {
/* 238 */     ExceptionReader exceptionReader = (ExceptionReader)this.exceptionMap.get(id);
/* 239 */     if (exceptionReader == null) {
/* 240 */       return new UnexpectedException(id);
/*     */     }
/*     */ 
/* 243 */     return exceptionReader.read(in);
/*     */   }
/*     */ 
/*     */   public boolean isDeclaredException(Throwable t)
/*     */   {
/* 258 */     Iterator iterator = this.exceptionList.iterator();
/* 259 */     while (iterator.hasNext()) {
/* 260 */       if (((Class)iterator.next()).isInstance(t)) {
/* 261 */         return true;
/*     */       }
/*     */     }
/* 264 */     return false;
/*     */   }
/*     */ 
/*     */   public Object convertLocalRetval(Object obj)
/*     */   {
/* 277 */     if (this.retvalRemoteInterface == null) {
/* 278 */       return obj;
/*     */     }
/* 280 */     return PortableRemoteObject.narrow(obj, this.retvalRemoteInterface);
/*     */   }
/*     */ 
/*     */   private static class ExceptionReader
/*     */   {
/*     */     private Class clz;
/*     */     private String reposId;
/* 307 */     private Method readMethod = null;
/*     */ 
/*     */     ExceptionReader(Class clz, String reposId)
/*     */     {
/* 315 */       this.clz = clz;
/* 316 */       if ((IDLEntity.class.isAssignableFrom(clz)) && (UserException.class.isAssignableFrom(clz)))
/*     */       {
/* 320 */         String helperClassName = clz.getName() + "Helper";
/*     */         try {
/* 322 */           Class helperClass = clz.getClassLoader().loadClass(helperClassName);
/*     */ 
/* 324 */           Class[] paramTypes = { org.omg.CORBA.portable.InputStream.class };
/*     */ 
/* 326 */           this.readMethod = helperClass.getMethod("read", paramTypes);
/*     */ 
/* 330 */           Method idMethod = helperClass.getMethod("id", null);
/*     */ 
/* 332 */           this.reposId = ((String)idMethod.invoke(null, null));
/*     */         }
/*     */         catch (ClassNotFoundException e) {
/* 335 */           throw new RuntimeException("Error loading class " + helperClassName + ": " + e);
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/* 339 */           throw new RuntimeException("No read/id method in helper class " + helperClassName + ": " + e);
/*     */         }
/*     */         catch (IllegalAccessException e)
/*     */         {
/* 343 */           throw new RuntimeException("Internal error: " + e);
/*     */         }
/*     */         catch (InvocationTargetException e) {
/* 346 */           throw new RuntimeException("Exception in call to " + helperClassName + ": " + e.getTargetException());
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 354 */         this.reposId = reposId;
/*     */       }
/*     */     }
/*     */ 
/*     */     public String getReposId()
/*     */     {
/* 360 */       return this.reposId;
/*     */     }
/*     */ 
/*     */     public Exception read(org.omg.CORBA_2_3.portable.InputStream in)
/*     */     {
/* 368 */       if (this.readMethod != null) {
/*     */         try {
/* 370 */           return (Exception)this.readMethod.invoke(null, new Object[] { in });
/*     */         }
/*     */         catch (IllegalAccessException e) {
/* 373 */           throw new RuntimeException("Internal error: " + e);
/*     */         }
/*     */         catch (InvocationTargetException e) {
/* 376 */           throw new RuntimeException("Exception unmarshaling IDLEntity: " + e.getTargetException());
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 381 */       in.read_string();
/* 382 */       return (Exception)in.read_value(this.clz);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.marshal.strategy.StubStrategy
 * JD-Core Version:    0.6.0
 */