/*     */ package org.jboss.iiop.rmi.marshal.strategy;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import org.jboss.iiop.rmi.ExceptionAnalysis;
/*     */ import org.jboss.iiop.rmi.RMIIIOPViolationException;
/*     */ import org.jboss.iiop.rmi.marshal.CDRStream;
/*     */ import org.jboss.iiop.rmi.marshal.CDRStreamReader;
/*     */ import org.jboss.iiop.rmi.marshal.CDRStreamWriter;
/*     */ import org.omg.CORBA.UserException;
/*     */ import org.omg.CORBA.portable.IDLEntity;
/*     */ import org.omg.CORBA.portable.UnknownException;
/*     */ import org.omg.CORBA_2_3.portable.InputStream;
/*     */ 
/*     */ public class SkeletonStrategy
/*     */ {
/*     */   private CDRStreamReader[] paramReaders;
/*     */   private Method m;
/*     */   private ExceptionWriter[] excepWriters;
/*     */   private CDRStreamWriter retvalWriter;
/*     */ 
/*     */   public SkeletonStrategy(Method m)
/*     */   {
/*  85 */     this.m = m;
/*     */ 
/*  88 */     Class[] paramTypes = m.getParameterTypes();
/*  89 */     int len = paramTypes.length;
/*  90 */     this.paramReaders = new CDRStreamReader[len];
/*  91 */     for (int i = 0; i < len; i++) {
/*  92 */       this.paramReaders[i] = CDRStream.readerFor(paramTypes[i]);
/*     */     }
/*     */ 
/*  96 */     Class[] excepTypes = m.getExceptionTypes();
/*  97 */     len = excepTypes.length;
/*  98 */     int n = 0;
/*  99 */     for (int i = 0; i < len; i++) {
/* 100 */       if (!RemoteException.class.isAssignableFrom(excepTypes[i])) {
/* 101 */         n++;
/*     */       }
/*     */     }
/* 104 */     this.excepWriters = new ExceptionWriter[n];
/* 105 */     int j = 0;
/* 106 */     for (int i = 0; i < len; i++) {
/* 107 */       if (!RemoteException.class.isAssignableFrom(excepTypes[i])) {
/* 108 */         this.excepWriters[(j++)] = new ExceptionWriter(excepTypes[i]);
/*     */       }
/*     */     }
/* 111 */     ExceptionWriter.arraysort(this.excepWriters);
/*     */ 
/* 114 */     this.retvalWriter = CDRStream.writerFor(m.getReturnType());
/*     */   }
/*     */ 
/*     */   public Object[] readParams(InputStream in)
/*     */   {
/* 125 */     int len = this.paramReaders.length;
/* 126 */     Object[] params = new Object[len];
/* 127 */     for (int i = 0; i < len; i++) {
/* 128 */       params[i] = this.paramReaders[i].read(in);
/*     */     }
/* 130 */     return params;
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/* 138 */     return this.m;
/*     */   }
/*     */ 
/*     */   public boolean isNonVoid()
/*     */   {
/* 147 */     return this.retvalWriter != null;
/*     */   }
/*     */ 
/*     */   public void writeRetval(org.omg.CORBA_2_3.portable.OutputStream out, Object retVal)
/*     */   {
/* 158 */     this.retvalWriter.write(out, retVal);
/*     */   }
/*     */ 
/*     */   public void writeException(org.omg.CORBA_2_3.portable.OutputStream out, Exception e)
/*     */   {
/* 169 */     int len = this.excepWriters.length;
/* 170 */     for (int i = 0; i < len; i++) {
/* 171 */       if (this.excepWriters[i].getExceptionClass().isInstance(e)) {
/* 172 */         this.excepWriters[i].write(out, e);
/* 173 */         return;
/*     */       }
/*     */     }
/* 176 */     throw new UnknownException(e);
/*     */   }
/*     */ 
/*     */   private static class ExceptionWriter
/*     */     implements CDRStreamWriter
/*     */   {
/*     */     private Class clz;
/* 199 */     private Method writeMethod = null;
/*     */     private String reposId;
/*     */ 
/*     */     ExceptionWriter(Class clz)
/*     */     {
/* 215 */       this.clz = clz;
/* 216 */       if ((IDLEntity.class.isAssignableFrom(clz)) && (UserException.class.isAssignableFrom(clz)))
/*     */       {
/* 220 */         String helperClassName = clz.getName() + "Helper";
/*     */         try {
/* 222 */           Class helperClass = clz.getClassLoader().loadClass(helperClassName);
/*     */ 
/* 224 */           Class[] paramTypes = { org.omg.CORBA.portable.OutputStream.class, clz };
/*     */ 
/* 226 */           this.writeMethod = helperClass.getMethod("write", paramTypes);
/*     */         }
/*     */         catch (ClassNotFoundException e) {
/* 229 */           throw new RuntimeException("Error loading class " + helperClassName + ": " + e);
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/* 233 */           throw new RuntimeException("No write method in helper class " + helperClassName + ": " + e);
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/* 242 */           this.reposId = ExceptionAnalysis.getExceptionAnalysis(clz).getExceptionRepositoryId();
/*     */         }
/*     */         catch (RMIIIOPViolationException e)
/*     */         {
/* 246 */           throw new RuntimeException("Cannot obtain exception repository id for " + clz.getName() + ":\n" + e);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     Class getExceptionClass()
/*     */     {
/* 258 */       return this.clz;
/*     */     }
/*     */ 
/*     */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, Object excep)
/*     */     {
/* 266 */       if (this.writeMethod != null) {
/*     */         try {
/* 268 */           this.writeMethod.invoke(null, new Object[] { out, excep });
/*     */         }
/*     */         catch (IllegalAccessException e) {
/* 271 */           throw new RuntimeException("Internal error: " + e);
/*     */         }
/*     */         catch (InvocationTargetException e) {
/* 274 */           throw new RuntimeException("Exception marshaling IDLEntity: " + e.getTargetException());
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 279 */         out.write_string(this.reposId);
/* 280 */         out.write_value((Exception)excep, this.clz);
/*     */       }
/*     */     }
/*     */ 
/*     */     static void arraysort(ExceptionWriter[] a)
/*     */     {
/* 290 */       int len = a.length;
/*     */ 
/* 292 */       for (int i = 0; i < len - 1; i++)
/* 293 */         for (int j = i + 1; j < len; j++)
/* 294 */           if (a[i].clz.isAssignableFrom(a[j].clz)) {
/* 295 */             ExceptionWriter tmp = a[i];
/*     */ 
/* 297 */             a[i] = a[j];
/* 298 */             a[j] = tmp;
/*     */           }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.marshal.strategy.SkeletonStrategy
 * JD-Core Version:    0.6.0
 */