/*     */ package org.jboss.iiop.rmi.ir;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ import org.omg.CORBA.AliasDef;
/*     */ import org.omg.CORBA.Any;
/*     */ import org.omg.CORBA.AttributeDef;
/*     */ import org.omg.CORBA.AttributeDescription;
/*     */ import org.omg.CORBA.AttributeMode;
/*     */ import org.omg.CORBA.BAD_INV_ORDER;
/*     */ import org.omg.CORBA.ConstantDef;
/*     */ import org.omg.CORBA.Contained;
/*     */ import org.omg.CORBA.ContainedOperations;
/*     */ import org.omg.CORBA.DefinitionKind;
/*     */ import org.omg.CORBA.EnumDef;
/*     */ import org.omg.CORBA.ExceptionDef;
/*     */ import org.omg.CORBA.IDLType;
/*     */ import org.omg.CORBA.IRObject;
/*     */ import org.omg.CORBA.Initializer;
/*     */ import org.omg.CORBA.InterfaceDef;
/*     */ import org.omg.CORBA.InterfaceDefHelper;
/*     */ import org.omg.CORBA.ModuleDef;
/*     */ import org.omg.CORBA.NativeDef;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CORBA.OperationDef;
/*     */ import org.omg.CORBA.OperationDescription;
/*     */ import org.omg.CORBA.OperationMode;
/*     */ import org.omg.CORBA.ParameterDescription;
/*     */ import org.omg.CORBA.StructDef;
/*     */ import org.omg.CORBA.StructMember;
/*     */ import org.omg.CORBA.TCKind;
/*     */ import org.omg.CORBA.TypeCode;
/*     */ import org.omg.CORBA.TypeCodePackage.BadKind;
/*     */ import org.omg.CORBA.UnionDef;
/*     */ import org.omg.CORBA.UnionMember;
/*     */ import org.omg.CORBA.ValueBoxDef;
/*     */ import org.omg.CORBA.ValueDef;
/*     */ import org.omg.CORBA.ValueDefHelper;
/*     */ import org.omg.CORBA.ValueDefOperations;
/*     */ import org.omg.CORBA.ValueDefPOATie;
/*     */ import org.omg.CORBA.ValueDefPackage.FullValueDescription;
/*     */ import org.omg.CORBA.ValueDescription;
/*     */ import org.omg.CORBA.ValueDescriptionHelper;
/*     */ import org.omg.CORBA.ValueMember;
/*     */ import org.omg.CORBA.ValueMemberDef;
/*     */ 
/*     */ class ValueDefImpl extends ContainedImpl
/*     */   implements ValueDefOperations, LocalContainer, LocalContainedIDLType
/*     */ {
/*  85 */   private static final Logger logger = Logger.getLogger(ValueDefImpl.class);
/*     */   private ContainerImplDelegate delegate;
/* 535 */   private ValueDef ref = null;
/*     */   private boolean is_abstract;
/*     */   private boolean is_custom;
/*     */   private String[] supported_interfaces;
/*     */   private InterfaceDef[] supported_interfaces_ref;
/*     */   private String baseValue;
/*     */   private TypeCode baseValueTypeCode;
/*     */   private ValueDef base_value_ref;
/*     */   private String[] abstract_base_valuetypes;
/*     */   private ValueDef[] abstract_base_valuetypes_ref;
/*     */   private TypeCode typeCode;
/*     */   private ValueMember[] valueMembers;
/*     */   private FullValueDescription fullValueDescription;
/*     */ 
/*     */   ValueDefImpl(String id, String name, String version, LocalContainer defined_in, boolean is_abstract, boolean is_custom, String[] supported_interfaces, String[] abstract_base_valuetypes, TypeCode baseValueTypeCode, RepositoryImpl repository)
/*     */   {
/*  98 */     super(id, name, version, defined_in, DefinitionKind.dk_Value, repository);
/*     */ 
/* 101 */     this.is_abstract = is_abstract;
/* 102 */     this.is_custom = is_custom;
/* 103 */     this.supported_interfaces = supported_interfaces;
/* 104 */     this.abstract_base_valuetypes = abstract_base_valuetypes;
/* 105 */     this.baseValueTypeCode = baseValueTypeCode;
/* 106 */     this.delegate = new ContainerImplDelegate(this);
/*     */   }
/*     */ 
/*     */   public LocalContained _lookup(String search_name)
/*     */   {
/* 115 */     return this.delegate._lookup(search_name);
/*     */   }
/*     */ 
/*     */   public LocalContained[] _contents(DefinitionKind limit_type, boolean exclude_inherited)
/*     */   {
/* 121 */     return this.delegate._contents(limit_type, exclude_inherited);
/*     */   }
/*     */ 
/*     */   public LocalContained[] _lookup_name(String search_name, int levels_to_search, DefinitionKind limit_type, boolean exclude_inherited)
/*     */   {
/* 129 */     return this.delegate._lookup_name(search_name, levels_to_search, limit_type, exclude_inherited);
/*     */   }
/*     */ 
/*     */   public void add(String name, LocalContained contained)
/*     */     throws IRConstructionException
/*     */   {
/* 136 */     this.delegate.add(name, contained);
/*     */   }
/*     */ 
/*     */   public IRObject getReference()
/*     */   {
/* 143 */     if (this.ref == null) {
/* 144 */       this.ref = ValueDefHelper.narrow(servantToReference(new ValueDefPOATie(this)));
/*     */     }
/*     */ 
/* 147 */     return this.ref;
/*     */   }
/*     */ 
/*     */   public void allDone()
/*     */     throws IRConstructionException
/*     */   {
/* 153 */     getReference();
/* 154 */     this.delegate.allDone();
/*     */ 
/* 156 */     logger.debug("ValueDefImpl.allDone(): baseValueTypeCode is " + (this.baseValueTypeCode == null ? "null" : "NOT null"));
/*     */ 
/* 158 */     if (this.baseValueTypeCode != null) {
/* 159 */       logger.debug("ValueDefImpl.allDone(): baseValueTypeCode.kind().value()=" + this.baseValueTypeCode.kind().value());
/*     */     }
/*     */ 
/* 162 */     if ((this.baseValueTypeCode != null) && (this.baseValueTypeCode.kind() != TCKind.tk_null))
/*     */     {
/*     */       try {
/* 165 */         this.baseValue = this.baseValueTypeCode.id();
/* 166 */         logger.debug("ValueDefImpl.allDone(): baseValue=\"" + this.baseValue + "\".");
/*     */       }
/*     */       catch (BadKind ex) {
/* 169 */         throw new IRConstructionException("Bad kind for super-valuetype of " + id());
/*     */       }
/*     */ 
/* 172 */       Contained c = this.repository.lookup_id(this.baseValue);
/* 173 */       logger.debug("ValueDefImpl.allDone(): c is " + (c == null ? "null" : "NOT null"));
/*     */ 
/* 175 */       this.base_value_ref = ValueDefHelper.narrow(c);
/* 176 */       logger.debug("ValueDefImpl.allDone(): base_value_ref is " + (this.base_value_ref == null ? "null" : "NOT null"));
/*     */     }
/*     */     else
/*     */     {
/* 180 */       this.baseValue = "IDL:omg.org/CORBA/ValueBase:1.0";
/*     */     }
/*     */ 
/* 183 */     this.supported_interfaces_ref = new InterfaceDef[this.supported_interfaces.length];
/* 184 */     for (int i = 0; i < this.supported_interfaces.length; i++) {
/* 185 */       InterfaceDef iDef = InterfaceDefHelper.narrow(this.repository.lookup_id(this.supported_interfaces[i]));
/*     */ 
/* 187 */       if (iDef == null) {
/* 188 */         throw new IRConstructionException("ValueDef \"" + id() + "\" unable to resolve " + "reference to implemented interface \"" + this.supported_interfaces[i] + "\".");
/*     */       }
/*     */ 
/* 192 */       this.supported_interfaces_ref[i] = iDef;
/*     */     }
/*     */ 
/* 196 */     this.abstract_base_valuetypes_ref = new ValueDef[this.abstract_base_valuetypes.length];
/*     */ 
/* 198 */     for (int i = 0; i < this.abstract_base_valuetypes.length; i++) {
/* 199 */       ValueDef vDef = ValueDefHelper.narrow(this.repository.lookup_id(this.abstract_base_valuetypes[i]));
/*     */ 
/* 201 */       if (vDef == null) {
/* 202 */         throw new IRConstructionException("ValueDef \"" + id() + "\" unable to resolve " + "reference to abstract base valuetype \"" + this.abstract_base_valuetypes[i] + "\".");
/*     */       }
/*     */ 
/* 206 */       this.abstract_base_valuetypes_ref[i] = vDef;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/* 212 */     this.delegate.shutdown();
/* 213 */     super.shutdown();
/*     */   }
/*     */ 
/*     */   public Contained lookup(String search_name)
/*     */   {
/* 221 */     logger.debug("ValueDefImpl.lookup(\"" + search_name + "\") entered.");
/* 222 */     Contained res = this.delegate.lookup(search_name);
/* 223 */     logger.debug("ValueDefImpl.lookup(\"" + search_name + "\") returning " + (res == null ? "null" : "non-null"));
/*     */ 
/* 225 */     return res;
/*     */   }
/*     */ 
/*     */   public Contained[] contents(DefinitionKind limit_type, boolean exclude_inherited)
/*     */   {
/* 232 */     logger.debug("ValueDefImpl.contents() entered.");
/* 233 */     Contained[] res = this.delegate.contents(limit_type, exclude_inherited);
/* 234 */     logger.debug("ValueDefImpl.contents() " + res.length + " contained to return.");
/*     */ 
/* 236 */     for (int i = 0; i < res.length; i++)
/* 237 */       logger.debug("  ValueDefImpl.contents() [" + i + "]: " + res[i].id());
/* 238 */     return res;
/*     */   }
/*     */ 
/*     */   public Contained[] lookup_name(String search_name, int levels_to_search, DefinitionKind limit_type, boolean exclude_inherited)
/*     */   {
/* 246 */     return this.delegate.lookup_name(search_name, levels_to_search, limit_type, exclude_inherited);
/*     */   }
/*     */ 
/*     */   public org.omg.CORBA.ContainerPackage.Description[] describe_contents(DefinitionKind limit_type, boolean exclude_inherited, int max_returned_objs)
/*     */   {
/* 255 */     return this.delegate.describe_contents(limit_type, exclude_inherited, max_returned_objs);
/*     */   }
/*     */ 
/*     */   public ModuleDef create_module(String id, String name, String version)
/*     */   {
/* 261 */     return this.delegate.create_module(id, name, version);
/*     */   }
/*     */ 
/*     */   public ConstantDef create_constant(String id, String name, String version, IDLType type, Any value)
/*     */   {
/* 267 */     return this.delegate.create_constant(id, name, version, type, value);
/*     */   }
/*     */ 
/*     */   public StructDef create_struct(String id, String name, String version, StructMember[] members)
/*     */   {
/* 273 */     return this.delegate.create_struct(id, name, version, members);
/*     */   }
/*     */ 
/*     */   public UnionDef create_union(String id, String name, String version, IDLType discriminator_type, UnionMember[] members)
/*     */   {
/* 280 */     return this.delegate.create_union(id, name, version, discriminator_type, members);
/*     */   }
/*     */ 
/*     */   public EnumDef create_enum(String id, String name, String version, String[] members)
/*     */   {
/* 287 */     return this.delegate.create_enum(id, name, version, members);
/*     */   }
/*     */ 
/*     */   public AliasDef create_alias(String id, String name, String version, IDLType original_type)
/*     */   {
/* 293 */     return this.delegate.create_alias(id, name, version, original_type);
/*     */   }
/*     */ 
/*     */   public InterfaceDef create_interface(String id, String name, String version, InterfaceDef[] base_interfaces, boolean is_abstract)
/*     */   {
/* 300 */     return this.delegate.create_interface(id, name, version, base_interfaces, is_abstract);
/*     */   }
/*     */ 
/*     */   public ValueDef create_value(String id, String name, String version, boolean is_custom, boolean is_abstract, ValueDef base_value, boolean is_truncatable, ValueDef[] abstract_base_values, InterfaceDef[] supported_interfaces, Initializer[] initializers)
/*     */   {
/* 311 */     return this.delegate.create_value(id, name, version, is_custom, is_abstract, base_value, is_truncatable, abstract_base_values, supported_interfaces, initializers);
/*     */   }
/*     */ 
/*     */   public ValueBoxDef create_value_box(String id, String name, String version, IDLType original_type_def)
/*     */   {
/* 320 */     return this.delegate.create_value_box(id, name, version, original_type_def);
/*     */   }
/*     */ 
/*     */   public ExceptionDef create_exception(String id, String name, String version, StructMember[] members)
/*     */   {
/* 326 */     return this.delegate.create_exception(id, name, version, members);
/*     */   }
/*     */ 
/*     */   public NativeDef create_native(String id, String name, String version)
/*     */   {
/* 331 */     return this.delegate.create_native(id, name, version);
/*     */   }
/*     */ 
/*     */   public InterfaceDef[] supported_interfaces()
/*     */   {
/* 339 */     return this.supported_interfaces_ref;
/*     */   }
/*     */ 
/*     */   public void supported_interfaces(InterfaceDef[] arg)
/*     */   {
/* 344 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public Initializer[] initializers()
/*     */   {
/* 351 */     return new Initializer[0];
/*     */   }
/*     */ 
/*     */   public void initializers(Initializer[] arg)
/*     */   {
/* 356 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public ValueDef base_value()
/*     */   {
/* 361 */     logger.debug("ValueDefImpl[" + this.id + "].base_value() entered.");
/* 362 */     if (this.base_value_ref == null)
/* 363 */       logger.debug("ValueDefImpl[" + this.id + "].base_value() returning NULL.");
/*     */     else {
/* 365 */       logger.debug("ValueDefImpl[" + this.id + "].base_value() returning \"" + this.base_value_ref.id() + "\".");
/*     */     }
/* 367 */     return this.base_value_ref;
/*     */   }
/*     */ 
/*     */   public void base_value(ValueDef arg)
/*     */   {
/* 372 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public ValueDef[] abstract_base_values()
/*     */   {
/* 377 */     return this.abstract_base_valuetypes_ref;
/*     */   }
/*     */ 
/*     */   public void abstract_base_values(ValueDef[] arg)
/*     */   {
/* 382 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public boolean is_abstract()
/*     */   {
/* 387 */     return this.is_abstract;
/*     */   }
/*     */ 
/*     */   public void is_abstract(boolean arg)
/*     */   {
/* 392 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public boolean is_custom()
/*     */   {
/* 397 */     return this.is_custom;
/*     */   }
/*     */ 
/*     */   public void is_custom(boolean arg)
/*     */   {
/* 402 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public boolean is_truncatable()
/*     */   {
/* 407 */     return false;
/*     */   }
/*     */ 
/*     */   public void is_truncatable(boolean arg)
/*     */   {
/* 412 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public boolean is_a(String id)
/*     */   {
/* 418 */     return id().equals(id);
/*     */   }
/*     */ 
/*     */   public FullValueDescription describe_value()
/*     */   {
/* 423 */     if (this.fullValueDescription != null) {
/* 424 */       return this.fullValueDescription;
/*     */     }
/*     */ 
/* 429 */     OperationDescription[] operations = new OperationDescription[0];
/* 430 */     AttributeDescription[] attributes = new AttributeDescription[0];
/*     */ 
/* 432 */     String defined_in_id = "IDL:Global:1.0";
/* 433 */     if ((this.defined_in instanceof ContainedOperations)) {
/* 434 */       defined_in_id = ((ContainedOperations)this.defined_in).id();
/*     */     }
/* 436 */     this.fullValueDescription = new FullValueDescription(this.name, this.id, this.is_abstract, this.is_custom, defined_in_id, this.version, operations, attributes, getValueMembers(), new Initializer[0], this.supported_interfaces, this.abstract_base_valuetypes, false, this.baseValue, this.typeCode);
/*     */ 
/* 448 */     return this.fullValueDescription;
/*     */   }
/*     */ 
/*     */   public ValueMemberDef create_value_member(String id, String name, String version, IDLType type, short access)
/*     */   {
/* 455 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public AttributeDef create_attribute(String id, String name, String version, IDLType type, AttributeMode mode)
/*     */   {
/* 461 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public OperationDef create_operation(String id, String name, String version, IDLType result, OperationMode mode, ParameterDescription[] params, ExceptionDef[] exceptions, String[] contexts)
/*     */   {
/* 470 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public TypeCode type()
/*     */   {
/* 478 */     logger.debug("ValueDefImpl.type() entered.");
/* 479 */     if (this.typeCode == null) {
/* 480 */       short modifier = 0;
/* 481 */       if (this.is_custom)
/* 482 */         modifier = 1;
/* 483 */       else if (this.is_abstract) {
/* 484 */         modifier = 2;
/*     */       }
/* 486 */       this.typeCode = getORB().create_value_tc(this.id, this.name, modifier, this.baseValueTypeCode, getValueMembersForTypeCode());
/*     */     }
/*     */ 
/* 490 */     logger.debug("ValueDefImpl.type() returning.");
/* 491 */     return this.typeCode;
/*     */   }
/*     */ 
/*     */   public org.omg.CORBA.ContainedPackage.Description describe()
/*     */   {
/* 499 */     String defined_in_id = "IR";
/*     */ 
/* 501 */     if ((this.defined_in instanceof ContainedOperations)) {
/* 502 */       defined_in_id = ((ContainedOperations)this.defined_in).id();
/*     */     }
/* 504 */     ValueDescription md = new ValueDescription(this.name, this.id, this.is_abstract, this.is_custom, defined_in_id, this.version, this.supported_interfaces, this.abstract_base_valuetypes, false, this.baseValue);
/*     */ 
/* 512 */     Any any = getORB().create_any();
/*     */ 
/* 514 */     ValueDescriptionHelper.insert(any, md);
/*     */ 
/* 516 */     return new org.omg.CORBA.ContainedPackage.Description(DefinitionKind.dk_Value, any);
/*     */   }
/*     */ 
/*     */   private ValueMember[] getValueMembers()
/*     */   {
/* 603 */     if (this.valueMembers != null) {
/* 604 */       return this.valueMembers;
/*     */     }
/* 606 */     LocalContained[] c = _contents(DefinitionKind.dk_ValueMember, false);
/* 607 */     this.valueMembers = new ValueMember[c.length];
/* 608 */     for (int i = 0; i < c.length; i++) {
/* 609 */       ValueMemberDefImpl vmdi = (ValueMemberDefImpl)c[i];
/*     */ 
/* 611 */       this.valueMembers[i] = new ValueMember(vmdi.name(), vmdi.id(), ((LocalContained)vmdi.defined_in).id(), vmdi.version(), vmdi.type(), vmdi.type_def(), vmdi.access());
/*     */     }
/*     */ 
/* 618 */     return this.valueMembers;
/*     */   }
/*     */ 
/*     */   private ValueMember[] getValueMembersForTypeCode()
/*     */   {
/* 626 */     LocalContained[] c = _contents(DefinitionKind.dk_ValueMember, false);
/* 627 */     ValueMember[] vms = new ValueMember[c.length];
/* 628 */     for (int i = 0; i < c.length; i++) {
/* 629 */       ValueMemberDefImpl vmdi = (ValueMemberDefImpl)c[i];
/*     */ 
/* 631 */       vms[i] = new ValueMember(vmdi.name(), null, null, null, vmdi.type(), null, vmdi.access());
/*     */     }
/*     */ 
/* 640 */     return vms;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.ir.ValueDefImpl
 * JD-Core Version:    0.6.0
 */