/*     */ package org.jboss.iiop.rmi.ir;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.omg.CORBA.DefinitionKind;
/*     */ import org.omg.CORBA.IRObject;
/*     */ import org.omg.CORBA.PrimitiveDef;
/*     */ import org.omg.CORBA.PrimitiveDefHelper;
/*     */ import org.omg.CORBA.PrimitiveDefOperations;
/*     */ import org.omg.CORBA.PrimitiveDefPOATie;
/*     */ import org.omg.CORBA.PrimitiveKind;
/*     */ import org.omg.CORBA.TCKind;
/*     */ import org.omg.CORBA.TypeCode;
/*     */ 
/*     */ class PrimitiveDefImpl extends IDLTypeImpl
/*     */   implements PrimitiveDefOperations, LocalIDLType
/*     */ {
/*  94 */   private PrimitiveDef ref = null;
/*     */ 
/* 103 */   private static Map primitiveTCKindMap = new HashMap();
/*     */ 
/*     */   PrimitiveDefImpl(TypeCode typeCode, RepositoryImpl repository)
/*     */   {
/*  57 */     super(typeCode, DefinitionKind.dk_Primitive, repository);
/*     */   }
/*     */ 
/*     */   public IRObject getReference()
/*     */   {
/*  67 */     if (this.ref == null) {
/*  68 */       this.ref = PrimitiveDefHelper.narrow(servantToReference(new PrimitiveDefPOATie(this)));
/*     */     }
/*     */ 
/*  71 */     return this.ref;
/*     */   }
/*     */ 
/*     */   public PrimitiveKind kind()
/*     */   {
/*  79 */     return (PrimitiveKind)primitiveTCKindMap.get(type().kind());
/*     */   }
/*     */ 
/*     */   static boolean isPrimitiveTCKind(TCKind tcKind)
/*     */   {
/*  86 */     return primitiveTCKindMap.containsKey(tcKind);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 104 */     primitiveTCKindMap.put(TCKind.tk_null, PrimitiveKind.pk_null);
/* 105 */     primitiveTCKindMap.put(TCKind.tk_void, PrimitiveKind.pk_void);
/* 106 */     primitiveTCKindMap.put(TCKind.tk_short, PrimitiveKind.pk_short);
/* 107 */     primitiveTCKindMap.put(TCKind.tk_long, PrimitiveKind.pk_long);
/* 108 */     primitiveTCKindMap.put(TCKind.tk_ushort, PrimitiveKind.pk_ushort);
/* 109 */     primitiveTCKindMap.put(TCKind.tk_ulong, PrimitiveKind.pk_ulong);
/* 110 */     primitiveTCKindMap.put(TCKind.tk_float, PrimitiveKind.pk_float);
/* 111 */     primitiveTCKindMap.put(TCKind.tk_double, PrimitiveKind.pk_double);
/* 112 */     primitiveTCKindMap.put(TCKind.tk_boolean, PrimitiveKind.pk_boolean);
/* 113 */     primitiveTCKindMap.put(TCKind.tk_char, PrimitiveKind.pk_char);
/* 114 */     primitiveTCKindMap.put(TCKind.tk_octet, PrimitiveKind.pk_octet);
/* 115 */     primitiveTCKindMap.put(TCKind.tk_any, PrimitiveKind.pk_any);
/* 116 */     primitiveTCKindMap.put(TCKind.tk_TypeCode, PrimitiveKind.pk_TypeCode);
/* 117 */     primitiveTCKindMap.put(TCKind.tk_Principal, PrimitiveKind.pk_Principal);
/* 118 */     primitiveTCKindMap.put(TCKind.tk_objref, PrimitiveKind.pk_objref);
/* 119 */     primitiveTCKindMap.put(TCKind.tk_string, PrimitiveKind.pk_string);
/* 120 */     primitiveTCKindMap.put(TCKind.tk_longlong, PrimitiveKind.pk_longlong);
/* 121 */     primitiveTCKindMap.put(TCKind.tk_ulonglong, PrimitiveKind.pk_ulonglong);
/* 122 */     primitiveTCKindMap.put(TCKind.tk_longdouble, PrimitiveKind.pk_longdouble);
/* 123 */     primitiveTCKindMap.put(TCKind.tk_wchar, PrimitiveKind.pk_wchar);
/* 124 */     primitiveTCKindMap.put(TCKind.tk_wstring, PrimitiveKind.pk_wstring);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.ir.PrimitiveDefImpl
 * JD-Core Version:    0.6.0
 */