/*     */ package org.jboss.iiop.rmi.ir;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ import org.omg.CORBA.AliasDef;
/*     */ import org.omg.CORBA.Any;
/*     */ import org.omg.CORBA.AttributeDef;
/*     */ import org.omg.CORBA.AttributeDescription;
/*     */ import org.omg.CORBA.AttributeMode;
/*     */ import org.omg.CORBA.BAD_INV_ORDER;
/*     */ import org.omg.CORBA.ConstantDef;
/*     */ import org.omg.CORBA.Contained;
/*     */ import org.omg.CORBA.ContainedOperations;
/*     */ import org.omg.CORBA.DefinitionKind;
/*     */ import org.omg.CORBA.EnumDef;
/*     */ import org.omg.CORBA.ExceptionDef;
/*     */ import org.omg.CORBA.IDLType;
/*     */ import org.omg.CORBA.IRObject;
/*     */ import org.omg.CORBA.Initializer;
/*     */ import org.omg.CORBA.InterfaceDef;
/*     */ import org.omg.CORBA.InterfaceDefHelper;
/*     */ import org.omg.CORBA.InterfaceDefOperations;
/*     */ import org.omg.CORBA.InterfaceDefPOATie;
/*     */ import org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescription;
/*     */ import org.omg.CORBA.InterfaceDescription;
/*     */ import org.omg.CORBA.InterfaceDescriptionHelper;
/*     */ import org.omg.CORBA.ModuleDef;
/*     */ import org.omg.CORBA.NativeDef;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CORBA.OperationDef;
/*     */ import org.omg.CORBA.OperationDescription;
/*     */ import org.omg.CORBA.OperationMode;
/*     */ import org.omg.CORBA.ParameterDescription;
/*     */ import org.omg.CORBA.StructDef;
/*     */ import org.omg.CORBA.StructMember;
/*     */ import org.omg.CORBA.TypeCode;
/*     */ import org.omg.CORBA.UnionDef;
/*     */ import org.omg.CORBA.UnionMember;
/*     */ import org.omg.CORBA.ValueBoxDef;
/*     */ import org.omg.CORBA.ValueDef;
/*     */ 
/*     */ class InterfaceDefImpl extends ContainedImpl
/*     */   implements InterfaceDefOperations, LocalContainer
/*     */ {
/*  76 */   private static final Logger logger = Logger.getLogger(InterfaceDefImpl.class);
/*     */ 
/* 391 */   protected InterfaceDef ref = null;
/*     */   protected TypeCode typeCode;
/*     */   private ContainerImplDelegate delegate;
/*     */   private boolean is_abstract;
/*     */   private String[] base_interfaces;
/*     */   private InterfaceDef[] base_interfaces_ref;
/*     */   private FullInterfaceDescription fullInterfaceDescription;
/*     */ 
/*     */   InterfaceDefImpl(String id, String name, String version, LocalContainer defined_in, String[] base_interfaces, RepositoryImpl repository)
/*     */   {
/*  85 */     super(id, name, version, defined_in, DefinitionKind.dk_Interface, repository);
/*     */ 
/*  88 */     this.base_interfaces = base_interfaces;
/*  89 */     this.delegate = new ContainerImplDelegate(this);
/*     */   }
/*     */ 
/*     */   public LocalContained _lookup(String search_name)
/*     */   {
/*  98 */     return this.delegate._lookup(search_name);
/*     */   }
/*     */ 
/*     */   public LocalContained[] _contents(DefinitionKind limit_type, boolean exclude_inherited)
/*     */   {
/* 104 */     return this.delegate._contents(limit_type, exclude_inherited);
/*     */   }
/*     */ 
/*     */   public LocalContained[] _lookup_name(String search_name, int levels_to_search, DefinitionKind limit_type, boolean exclude_inherited)
/*     */   {
/* 112 */     return this.delegate._lookup_name(search_name, levels_to_search, limit_type, exclude_inherited);
/*     */   }
/*     */ 
/*     */   public void add(String name, LocalContained contained)
/*     */     throws IRConstructionException
/*     */   {
/* 119 */     this.delegate.add(name, contained);
/*     */   }
/*     */ 
/*     */   public IRObject getReference()
/*     */   {
/* 126 */     if (this.ref == null) {
/* 127 */       this.ref = InterfaceDefHelper.narrow(servantToReference(new InterfaceDefPOATie(this)));
/*     */     }
/*     */ 
/* 130 */     return this.ref;
/*     */   }
/*     */ 
/*     */   public void allDone()
/*     */     throws IRConstructionException
/*     */   {
/* 136 */     getReference();
/* 137 */     this.delegate.allDone();
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/* 142 */     this.delegate.shutdown();
/* 143 */     super.shutdown();
/*     */   }
/*     */ 
/*     */   public Contained lookup(String search_name)
/*     */   {
/* 150 */     logger.debug("InterfaceDefImpl.lookup(\"" + search_name + "\") entered.");
/*     */ 
/* 152 */     Contained res = this.delegate.lookup(search_name);
/* 153 */     logger.debug("InterfaceDefImpl.lookup(\"" + search_name + "\") returning " + (res == null ? "null" : "non-null"));
/*     */ 
/* 155 */     return res;
/*     */   }
/*     */ 
/*     */   public Contained[] contents(DefinitionKind limit_type, boolean exclude_inherited)
/*     */   {
/* 162 */     logger.debug("InterfaceDefImpl.contents() entered.");
/* 163 */     Contained[] res = this.delegate.contents(limit_type, exclude_inherited);
/* 164 */     logger.debug("InterfaceDefImpl.contents() " + res.length + " contained to return.");
/*     */ 
/* 166 */     for (int i = 0; i < res.length; i++) {
/* 167 */       logger.debug("  InterfaceDefImpl.contents() [" + i + "]: " + res[i].id());
/*     */     }
/* 169 */     return res;
/*     */   }
/*     */ 
/*     */   public Contained[] lookup_name(String search_name, int levels_to_search, DefinitionKind limit_type, boolean exclude_inherited)
/*     */   {
/* 177 */     return this.delegate.lookup_name(search_name, levels_to_search, limit_type, exclude_inherited);
/*     */   }
/*     */ 
/*     */   public org.omg.CORBA.ContainerPackage.Description[] describe_contents(DefinitionKind limit_type, boolean exclude_inherited, int max_returned_objs)
/*     */   {
/* 186 */     return this.delegate.describe_contents(limit_type, exclude_inherited, max_returned_objs);
/*     */   }
/*     */ 
/*     */   public ModuleDef create_module(String id, String name, String version)
/*     */   {
/* 192 */     return this.delegate.create_module(id, name, version);
/*     */   }
/*     */ 
/*     */   public ConstantDef create_constant(String id, String name, String version, IDLType type, Any value)
/*     */   {
/* 198 */     return this.delegate.create_constant(id, name, version, type, value);
/*     */   }
/*     */ 
/*     */   public StructDef create_struct(String id, String name, String version, StructMember[] members)
/*     */   {
/* 204 */     return this.delegate.create_struct(id, name, version, members);
/*     */   }
/*     */ 
/*     */   public UnionDef create_union(String id, String name, String version, IDLType discriminator_type, UnionMember[] members)
/*     */   {
/* 211 */     return this.delegate.create_union(id, name, version, discriminator_type, members);
/*     */   }
/*     */ 
/*     */   public EnumDef create_enum(String id, String name, String version, String[] members)
/*     */   {
/* 218 */     return this.delegate.create_enum(id, name, version, members);
/*     */   }
/*     */ 
/*     */   public AliasDef create_alias(String id, String name, String version, IDLType original_type)
/*     */   {
/* 224 */     return this.delegate.create_alias(id, name, version, original_type);
/*     */   }
/*     */ 
/*     */   public InterfaceDef create_interface(String id, String name, String version, InterfaceDef[] base_interfaces, boolean is_abstract)
/*     */   {
/* 231 */     return this.delegate.create_interface(id, name, version, base_interfaces, is_abstract);
/*     */   }
/*     */ 
/*     */   public ValueDef create_value(String id, String name, String version, boolean is_custom, boolean is_abstract, ValueDef base_value, boolean is_truncatable, ValueDef[] abstract_base_values, InterfaceDef[] supported_interfaces, Initializer[] initializers)
/*     */   {
/* 242 */     return this.delegate.create_value(id, name, version, is_custom, is_abstract, base_value, is_truncatable, abstract_base_values, supported_interfaces, initializers);
/*     */   }
/*     */ 
/*     */   public ValueBoxDef create_value_box(String id, String name, String version, IDLType original_type_def)
/*     */   {
/* 251 */     return this.delegate.create_value_box(id, name, version, original_type_def);
/*     */   }
/*     */ 
/*     */   public ExceptionDef create_exception(String id, String name, String version, StructMember[] members)
/*     */   {
/* 257 */     return this.delegate.create_exception(id, name, version, members);
/*     */   }
/*     */ 
/*     */   public NativeDef create_native(String id, String name, String version)
/*     */   {
/* 262 */     return this.delegate.create_native(id, name, version);
/*     */   }
/*     */ 
/*     */   public InterfaceDef[] base_interfaces()
/*     */   {
/* 270 */     if (this.base_interfaces_ref == null) {
/* 271 */       this.base_interfaces_ref = new InterfaceDef[this.base_interfaces.length];
/* 272 */       for (int i = 0; i < this.base_interfaces_ref.length; i++) {
/* 273 */         logger.debug("InterfaceDefImpl.base_interfaces(): looking up \"" + this.base_interfaces[i] + "\".");
/*     */ 
/* 275 */         Contained c = this.repository.lookup_id(this.base_interfaces[i]);
/* 276 */         logger.debug("InterfaceDefImpl.base_interfaces(): Got: " + (c == null ? "null" : c.id()));
/*     */ 
/* 278 */         this.base_interfaces_ref[i] = InterfaceDefHelper.narrow(c);
/* 279 */         logger.debug("InterfaceDefImpl.base_interfaces(): ref: " + (c == null ? "null" : "not null"));
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 284 */     return this.base_interfaces_ref;
/*     */   }
/*     */ 
/*     */   public void base_interfaces(InterfaceDef[] arg)
/*     */   {
/* 289 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public boolean is_abstract()
/*     */   {
/* 294 */     return false;
/*     */   }
/*     */ 
/*     */   public void is_abstract(boolean arg)
/*     */   {
/* 299 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public boolean is_a(String interface_id)
/*     */   {
/* 305 */     return false;
/*     */   }
/*     */ 
/*     */   public FullInterfaceDescription describe_interface()
/*     */   {
/* 310 */     if (this.fullInterfaceDescription != null) {
/* 311 */       return this.fullInterfaceDescription;
/*     */     }
/*     */ 
/* 316 */     OperationDescription[] operations = new OperationDescription[0];
/* 317 */     AttributeDescription[] attributes = new AttributeDescription[0];
/*     */ 
/* 319 */     String defined_in_id = "IDL:Global:1.0";
/* 320 */     if ((this.defined_in instanceof ContainedOperations)) {
/* 321 */       defined_in_id = ((ContainedOperations)this.defined_in).id();
/*     */     }
/* 323 */     this.fullInterfaceDescription = new FullInterfaceDescription(this.name, this.id, defined_in_id, this.version, operations, attributes, this.base_interfaces, type(), this.is_abstract);
/*     */ 
/* 332 */     return this.fullInterfaceDescription;
/*     */   }
/*     */ 
/*     */   public AttributeDef create_attribute(String id, String name, String version, IDLType type, AttributeMode mode)
/*     */   {
/* 339 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public OperationDef create_operation(String id, String name, String version, IDLType result, OperationMode mode, ParameterDescription[] params, ExceptionDef[] exceptions, String[] contexts)
/*     */   {
/* 348 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public TypeCode type()
/*     */   {
/* 356 */     if (this.typeCode == null) {
/* 357 */       this.typeCode = getORB().create_interface_tc(this.id, this.name);
/*     */     }
/* 359 */     return this.typeCode;
/*     */   }
/*     */ 
/*     */   public org.omg.CORBA.ContainedPackage.Description describe()
/*     */   {
/* 366 */     String defined_in_id = "IR";
/*     */ 
/* 368 */     if ((this.defined_in instanceof ContainedOperations)) {
/* 369 */       defined_in_id = ((ContainedOperations)this.defined_in).id();
/*     */     }
/* 371 */     InterfaceDescription md = new InterfaceDescription(this.name, this.id, defined_in_id, this.version, this.base_interfaces, false);
/*     */ 
/* 375 */     Any any = getORB().create_any();
/*     */ 
/* 377 */     InterfaceDescriptionHelper.insert(any, md);
/*     */ 
/* 379 */     return new org.omg.CORBA.ContainedPackage.Description(DefinitionKind.dk_Interface, any);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.ir.InterfaceDefImpl
 * JD-Core Version:    0.6.0
 */