/*     */ package org.jboss.iiop.rmi.ir;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ import org.omg.CORBA.BAD_INV_ORDER;
/*     */ import org.omg.CORBA.CompletionStatus;
/*     */ import org.omg.CORBA.DefinitionKind;
/*     */ import org.omg.CORBA.IRObject;
/*     */ import org.omg.CORBA.IRObjectOperations;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CORBA.UserException;
/*     */ import org.omg.PortableServer.POA;
/*     */ import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
/*     */ import org.omg.PortableServer.POAPackage.ObjectNotActive;
/*     */ import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
/*     */ import org.omg.PortableServer.POAPackage.WrongPolicy;
/*     */ import org.omg.PortableServer.Servant;
/*     */ 
/*     */ abstract class IRObjectImpl
/*     */   implements IRObjectOperations
/*     */ {
/*     */   protected RepositoryImpl repository;
/*     */   protected DefinitionKind def_kind;
/*  58 */   private static final Logger logger = Logger.getLogger(IRObjectImpl.class);
/*     */ 
/*     */   IRObjectImpl(DefinitionKind def_kind, RepositoryImpl repository)
/*     */   {
/*  65 */     this.def_kind = def_kind;
/*  66 */     this.repository = repository;
/*     */   }
/*     */ 
/*     */   public DefinitionKind def_kind()
/*     */   {
/*  75 */     logger.trace("IRObjectImpl.def_kind() entered.");
/*  76 */     return this.def_kind;
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*  81 */     throw new BAD_INV_ORDER("Cannot destroy RMI/IIOP mapping.", 2, CompletionStatus.COMPLETED_NO);
/*     */   }
/*     */ 
/*     */   public abstract IRObject getReference();
/*     */ 
/*     */   public void allDone()
/*     */     throws IRConstructionException
/*     */   {
/*  92 */     getReference();
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/* 100 */     POA poa = getPOA();
/*     */     try
/*     */     {
/* 103 */       poa.deactivate_object(poa.reference_to_id(getReference()));
/*     */     } catch (UserException ex) {
/* 105 */       logger.warn("Could not deactivate IR object", ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public RepositoryImpl getRepository()
/*     */   {
/* 111 */     return this.repository;
/*     */   }
/*     */ 
/*     */   protected ORB getORB()
/*     */   {
/* 123 */     return this.repository.orb;
/*     */   }
/*     */ 
/*     */   protected POA getPOA()
/*     */   {
/* 131 */     return this.repository.poa;
/*     */   }
/*     */ 
/*     */   protected abstract byte[] getObjectId();
/*     */ 
/*     */   protected org.omg.CORBA.Object servantToReference(Servant servant)
/*     */   {
/* 144 */     byte[] id = getObjectId();
/*     */     try
/*     */     {
/* 153 */       logger.debug("#### IRObject.srv2ref: id=[" + new String(id) + "]");
/* 154 */       this.repository.poa.activate_object_with_id(id, servant);
/* 155 */       org.omg.CORBA.Object ref = this.repository.poa.id_to_reference(id);
/* 156 */       logger.debug("#### IRObject.srv2ref: returning ref.");
/*     */ 
/* 158 */       return ref;
/*     */     } catch (WrongPolicy ex) {
/* 160 */       logger.debug("Exception converting CORBA servant to reference", ex);
/*     */     } catch (ServantAlreadyActive ex) {
/* 162 */       logger.debug("Exception converting CORBA servant to reference", ex);
/*     */     } catch (ObjectAlreadyActive ex) {
/* 164 */       logger.debug("Exception converting CORBA servant to reference", ex);
/*     */     } catch (ObjectNotActive ex) {
/* 166 */       logger.debug("Exception converting CORBA servant to reference", ex);
/*     */     }
/*     */ 
/* 170 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.ir.IRObjectImpl
 * JD-Core Version:    0.6.0
 */