/*     */ package org.jboss.iiop.rmi.ir;
/*     */ 
/*     */ import org.omg.CORBA.DefinitionKind;
/*     */ import org.omg.CORBA.TCKind;
/*     */ import org.omg.CORBA.TypeCode;
/*     */ import org.omg.CORBA.TypeCodePackage.BadKind;
/*     */ 
/*     */ abstract class IDLTypeImpl extends IRObjectImpl
/*     */   implements LocalIDLType
/*     */ {
/*     */   private TypeCode typeCode;
/*     */ 
/*     */   IDLTypeImpl(TypeCode typeCode, DefinitionKind def_kind, RepositoryImpl repository)
/*     */   {
/*  50 */     super(def_kind, repository);
/*     */ 
/*  52 */     this.typeCode = typeCode;
/*     */   }
/*     */ 
/*     */   public TypeCode type()
/*     */   {
/*  61 */     return this.typeCode;
/*     */   }
/*     */ 
/*     */   static LocalIDLType getIDLType(TypeCode typeCode, RepositoryImpl repository)
/*     */   {
/*  71 */     TCKind tcKind = typeCode.kind();
/*     */ 
/*  73 */     if (PrimitiveDefImpl.isPrimitiveTCKind(tcKind)) {
/*  74 */       return new PrimitiveDefImpl(typeCode, repository);
/*     */     }
/*  76 */     if (tcKind == TCKind.tk_sequence) {
/*  77 */       return repository.getSequenceImpl(typeCode);
/*     */     }
/*  79 */     if ((tcKind == TCKind.tk_value) || (tcKind == TCKind.tk_value_box) || (tcKind == TCKind.tk_alias) || (tcKind == TCKind.tk_struct) || (tcKind == TCKind.tk_union) || (tcKind == TCKind.tk_enum) || (tcKind == TCKind.tk_objref))
/*     */     {
/*     */       try
/*     */       {
/*  84 */         return (LocalIDLType)repository._lookup_id(typeCode.id());
/*     */       } catch (BadKind ex) {
/*  86 */         throw new RuntimeException("Bad kind for TypeCode.id()");
/*     */       }
/*     */     }
/*     */ 
/*  90 */     throw new RuntimeException("TODO: tcKind=" + tcKind.value());
/*     */   }
/*     */ 
/*     */   protected byte[] getObjectId()
/*     */   {
/* 101 */     return this.repository.getNextObjectId();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.ir.IDLTypeImpl
 * JD-Core Version:    0.6.0
 */