/*     */ package org.jboss.iiop.rmi.ir;
/*     */ 
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.omg.CORBA.BAD_INV_ORDER;
/*     */ import org.omg.CORBA.ContainedPackage.Description;
/*     */ import org.omg.CORBA.Container;
/*     */ import org.omg.CORBA.ContainerHelper;
/*     */ import org.omg.CORBA.DefinitionKind;
/*     */ import org.omg.CORBA.Repository;
/*     */ import org.omg.CORBA.RepositoryHelper;
/*     */ 
/*     */ abstract class ContainedImpl extends IRObjectImpl
/*     */   implements LocalContained
/*     */ {
/*  51 */   private static final Logger logger = Logger.getLogger(ContainedImpl.class);
/*     */   protected String id;
/*     */   protected String name;
/* 157 */   protected String version = "1.0";
/*     */   protected LocalContainer defined_in;
/*     */   protected String absolute_name;
/*     */ 
/*     */   ContainedImpl(String id, String name, String version, LocalContainer defined_in, DefinitionKind def_kind, RepositoryImpl repository)
/*     */   {
/*  60 */     super(def_kind, repository);
/*  61 */     this.id = id;
/*  62 */     this.name = name;
/*  63 */     this.version = version;
/*  64 */     this.defined_in = defined_in;
/*     */ 
/*  66 */     if ((defined_in instanceof LocalContained)) {
/*  67 */       this.absolute_name = (((LocalContained)defined_in).absolute_name() + "::" + name);
/*     */     }
/*     */     else
/*  70 */       this.absolute_name = ("::" + name);
/*     */   }
/*     */ 
/*     */   public String id()
/*     */   {
/*  79 */     logger.trace("ContainedImpl[" + this.id + "].id() entered.");
/*  80 */     return this.id;
/*     */   }
/*     */ 
/*     */   public void id(String id)
/*     */   {
/*  85 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public String name()
/*     */   {
/*  90 */     logger.trace("ContainedImpl[" + this.id + "].name() entered.");
/*  91 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void name(String name)
/*     */   {
/*  96 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public String version()
/*     */   {
/* 101 */     logger.trace("ContainedImpl[" + this.id + "].version() entered.");
/* 102 */     return this.version;
/*     */   }
/*     */ 
/*     */   public void version(String version)
/*     */   {
/* 107 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public Container defined_in()
/*     */   {
/* 112 */     logger.debug("ContainedImpl[" + this.id + "].defined_in() entered.");
/* 113 */     return ContainerHelper.narrow(this.defined_in.getReference());
/*     */   }
/*     */ 
/*     */   public String absolute_name()
/*     */   {
/* 118 */     logger.trace("ContainedImpl[" + this.id + "].absolute_name() returning \"" + this.absolute_name + "\".");
/*     */ 
/* 120 */     return this.absolute_name;
/*     */   }
/*     */ 
/*     */   public Repository containing_repository()
/*     */   {
/* 125 */     logger.debug("ContainedImpl[" + this.id + "].containing_repository() entered.");
/*     */ 
/* 127 */     return RepositoryHelper.narrow(this.repository.getReference());
/*     */   }
/*     */ 
/*     */   public abstract Description describe();
/*     */ 
/*     */   public void move(Container new_container, String new_name, String new_version)
/*     */   {
/* 135 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   protected byte[] getObjectId()
/*     */   {
/*     */     try
/*     */     {
/* 179 */       return (getRepository().getObjectIdPrefix() + this.id).getBytes("UTF-8"); } catch (UnsupportedEncodingException ex) {
/*     */     }
/* 181 */     throw new RuntimeException("UTF-8 encoding not supported.");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.ir.ContainedImpl
 * JD-Core Version:    0.6.0
 */