/*     */ package org.jboss.iiop.rmi.ir;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ import org.omg.CORBA.Any;
/*     */ import org.omg.CORBA.BAD_INV_ORDER;
/*     */ import org.omg.CORBA.ConstantDef;
/*     */ import org.omg.CORBA.ConstantDefHelper;
/*     */ import org.omg.CORBA.ConstantDefOperations;
/*     */ import org.omg.CORBA.ConstantDefPOATie;
/*     */ import org.omg.CORBA.ConstantDescription;
/*     */ import org.omg.CORBA.ConstantDescriptionHelper;
/*     */ import org.omg.CORBA.ContainedOperations;
/*     */ import org.omg.CORBA.ContainedPackage.Description;
/*     */ import org.omg.CORBA.DefinitionKind;
/*     */ import org.omg.CORBA.IDLType;
/*     */ import org.omg.CORBA.IDLTypeHelper;
/*     */ import org.omg.CORBA.IRObject;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CORBA.TypeCode;
/*     */ 
/*     */ public class ConstantDefImpl extends ContainedImpl
/*     */   implements ConstantDefOperations
/*     */ {
/*  55 */   private static final Logger logger = Logger.getLogger(ConstantDefImpl.class);
/*     */ 
/* 166 */   private ConstantDef ref = null;
/*     */   private TypeCode typeCode;
/*     */   private LocalIDLType type_def;
/*     */   private Any value;
/*     */ 
/*     */   ConstantDefImpl(String id, String name, String version, TypeCode typeCode, Any value, LocalContainer defined_in, RepositoryImpl repository)
/*     */   {
/*  64 */     super(id, name, version, defined_in, DefinitionKind.dk_Constant, repository);
/*     */ 
/*  67 */     this.typeCode = typeCode;
/*  68 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public IRObject getReference()
/*     */   {
/*  78 */     if (this.ref == null) {
/*  79 */       this.ref = ConstantDefHelper.narrow(servantToReference(new ConstantDefPOATie(this)));
/*     */     }
/*     */ 
/*  82 */     return this.ref;
/*     */   }
/*     */ 
/*     */   public void allDone()
/*     */     throws IRConstructionException
/*     */   {
/*  89 */     this.type_def = IDLTypeImpl.getIDLType(this.typeCode, this.repository);
/*  90 */     if (this.type_def == null)
/*  91 */       logger.debug("Got type_def: [NULL]");
/*     */     else {
/*  93 */       logger.debug("Got type_def: [" + this.type_def.toString() + "]");
/*     */     }
/*  95 */     getReference();
/*     */   }
/*     */ 
/*     */   public TypeCode type()
/*     */   {
/* 103 */     logger.debug("ConstantDefImpl.type(): entered.");
/* 104 */     return this.typeCode;
/*     */   }
/*     */ 
/*     */   public IDLType type_def()
/*     */   {
/* 109 */     logger.debug("ConstantDefImpl.type_def(): entered.");
/*     */     try {
/* 111 */       IDLType localIDLType = IDLTypeHelper.narrow(this.type_def.getReference());
/*     */       return localIDLType; } finally { logger.debug("ConstantDefImpl.type_def(): returning."); } throw localObject;
/*     */   }
/*     */ 
/*     */   public void type_def(IDLType arg)
/*     */   {
/* 119 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public Any value()
/*     */   {
/* 124 */     logger.debug("ConstantDefImpl.value(): entered.");
/* 125 */     return this.value;
/*     */   }
/*     */ 
/*     */   public void value(Any arg)
/*     */   {
/* 130 */     throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
/*     */   }
/*     */ 
/*     */   public Description describe()
/*     */   {
/* 138 */     logger.debug("ConstantDefImpl.describe(): entered.");
/* 139 */     String defined_in_id = "IR";
/*     */ 
/* 141 */     if ((this.defined_in instanceof ContainedOperations)) {
/* 142 */       defined_in_id = ((ContainedOperations)this.defined_in).id();
/*     */     }
/* 144 */     ConstantDescription d = new ConstantDescription(this.name, this.id, defined_in_id, this.version, this.typeCode, this.value);
/*     */ 
/* 148 */     Any any = getORB().create_any();
/*     */ 
/* 150 */     ConstantDescriptionHelper.insert(any, d);
/*     */ 
/* 152 */     return new Description(DefinitionKind.dk_Constant, any);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.ir.ConstantDefImpl
 * JD-Core Version:    0.6.0
 */