/*     */ package org.jboss.iiop.rmi;
/*     */ 
/*     */ import java.lang.ref.SoftReference;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.WeakHashMap;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ class WorkCacheManager
/*     */ {
/*  63 */   private static final Logger logger = Logger.getLogger(WorkCacheManager.class);
/*     */   Constructor constructor;
/*     */   Method initializer;
/*     */   Map workDone;
/*     */   Map workInProgress;
/*     */ 
/*     */   WorkCacheManager(Class cls)
/*     */   {
/*  75 */     logger.debug("Class: " + cls.getName());
/*     */     try
/*     */     {
/*  78 */       this.constructor = cls.getDeclaredConstructor(new Class[] { Class.class });
/*  79 */       this.initializer = cls.getDeclaredMethod("doAnalyze", null);
/*     */     } catch (NoSuchMethodException ex) {
/*  81 */       throw new IllegalArgumentException("Bad Class: " + ex.toString());
/*     */     }
/*     */ 
/*  84 */     this.workDone = new WeakHashMap();
/*  85 */     this.workInProgress = new HashMap();
/*     */   }
/*     */ 
/*     */   ContainerAnalysis getAnalysis(Class cls)
/*     */     throws RMIIIOPViolationException
/*     */   {
/*     */     ContainerAnalysis ret;
/* 101 */     synchronized (this) {
/* 102 */       ret = lookupDone(cls);
/* 103 */       if (ret != null) {
/* 104 */         return ret;
/*     */       }
/*     */ 
/* 107 */       InProgress inProgress = (InProgress)this.workInProgress.get(cls);
/* 108 */       if ((inProgress != null) && 
/* 109 */         (inProgress.thread == Thread.currentThread())) {
/* 110 */         return inProgress.analysis;
/*     */       }
/*     */ 
/* 116 */       ret = createWorkInProgress(cls);
/*     */     }
/*     */ 
/* 120 */     doTheWork(cls, ret);
/*     */ 
/* 123 */     synchronized (this) {
/* 124 */       this.workInProgress.remove(cls);
/* 125 */       this.workDone.put(cls, new SoftReference(ret));
/* 126 */       notifyAll();
/*     */     }
/*     */ 
/* 129 */     return ret;
/*     */   }
/*     */ 
/*     */   private ContainerAnalysis lookupDone(Class cls)
/*     */   {
/* 163 */     SoftReference ref = (SoftReference)this.workDone.get(cls);
/* 164 */     if (ref == null)
/* 165 */       return null;
/* 166 */     ContainerAnalysis ret = (ContainerAnalysis)ref.get();
/* 167 */     if (ret == null)
/* 168 */       this.workDone.remove(cls);
/* 169 */     return ret;
/*     */   }
/*     */ 
/*     */   private ContainerAnalysis createWorkInProgress(Class cls)
/*     */   {
/*     */     ContainerAnalysis analysis;
/*     */     try
/*     */     {
/* 179 */       analysis = (ContainerAnalysis)this.constructor.newInstance(new Object[] { cls });
/*     */     } catch (InstantiationException ex) {
/* 181 */       throw new RuntimeException(ex.toString());
/*     */     } catch (IllegalAccessException ex) {
/* 183 */       throw new RuntimeException(ex.toString());
/*     */     } catch (InvocationTargetException ex) {
/* 185 */       throw new RuntimeException(ex.toString());
/*     */     }
/*     */ 
/* 188 */     this.workInProgress.put(cls, new InProgress(analysis, Thread.currentThread()));
/*     */ 
/* 190 */     return analysis;
/*     */   }
/*     */ 
/*     */   private void doTheWork(Class cls, ContainerAnalysis ret) throws RMIIIOPViolationException
/*     */   {
/*     */     try
/*     */     {
/* 197 */       this.initializer.invoke(ret, new Object[0]);
/*     */     } catch (Throwable t) {
/* 199 */       synchronized (this) {
/* 200 */         this.workInProgress.remove(cls);
/*     */       }
/* 202 */       if ((t instanceof InvocationTargetException)) {
/* 203 */         t = ((InvocationTargetException)t).getTargetException();
/*     */       }
/* 205 */       if ((t instanceof RMIIIOPViolationException))
/* 206 */         throw ((RMIIIOPViolationException)t);
/* 207 */       if ((t instanceof RuntimeException))
/* 208 */         throw ((RuntimeException)t);
/* 209 */       if ((t instanceof Error))
/* 210 */         throw ((Error)t);
/* 211 */       throw new RuntimeException(t.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class InProgress
/*     */   {
/*     */     ContainerAnalysis analysis;
/*     */     Thread thread;
/*     */ 
/*     */     InProgress(ContainerAnalysis analysis, Thread thread)
/*     */     {
/* 225 */       this.analysis = analysis;
/* 226 */       this.thread = thread;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.WorkCacheManager
 * JD-Core Version:    0.6.0
 */