/*    */ package org.jboss.iiop.rmi;
/*    */ 
/*    */ public class PrimitiveAnalysis extends ClassAnalysis
/*    */ {
/* 74 */   public static PrimitiveAnalysis voidAnalysis = new PrimitiveAnalysis(Void.TYPE, "void", "void");
/* 75 */   public static PrimitiveAnalysis booleanAnalysis = new PrimitiveAnalysis(Boolean.TYPE, "boolean", "boolean");
/* 76 */   public static PrimitiveAnalysis charAnalysis = new PrimitiveAnalysis(Character.TYPE, "wchar", "char");
/* 77 */   public static PrimitiveAnalysis byteAnalysis = new PrimitiveAnalysis(Byte.TYPE, "octet", "byte");
/* 78 */   public static PrimitiveAnalysis shortAnalysis = new PrimitiveAnalysis(Short.TYPE, "short", "short");
/* 79 */   public static PrimitiveAnalysis intAnalysis = new PrimitiveAnalysis(Integer.TYPE, "long", "int");
/* 80 */   public static PrimitiveAnalysis longAnalysis = new PrimitiveAnalysis(Long.TYPE, "long_long", "long");
/* 81 */   public static PrimitiveAnalysis floatAnalysis = new PrimitiveAnalysis(Float.TYPE, "float", "float");
/* 82 */   public static PrimitiveAnalysis doubleAnalysis = new PrimitiveAnalysis(Double.TYPE, "double", "double");
/*    */ 
/*    */   public static PrimitiveAnalysis getPrimitiveAnalysis(Class cls)
/*    */   {
/* 48 */     if (cls == null) {
/* 49 */       throw new IllegalArgumentException("Null class");
/*    */     }
/* 51 */     if (cls == Void.TYPE)
/* 52 */       return voidAnalysis;
/* 53 */     if (cls == Boolean.TYPE)
/* 54 */       return booleanAnalysis;
/* 55 */     if (cls == Character.TYPE)
/* 56 */       return charAnalysis;
/* 57 */     if (cls == Byte.TYPE)
/* 58 */       return byteAnalysis;
/* 59 */     if (cls == Short.TYPE)
/* 60 */       return shortAnalysis;
/* 61 */     if (cls == Integer.TYPE)
/* 62 */       return intAnalysis;
/* 63 */     if (cls == Long.TYPE)
/* 64 */       return longAnalysis;
/* 65 */     if (cls == Float.TYPE)
/* 66 */       return floatAnalysis;
/* 67 */     if (cls == Double.TYPE) {
/* 68 */       return doubleAnalysis;
/*    */     }
/* 70 */     throw new IllegalArgumentException("Not a primitive type: " + cls.getName());
/*    */   }
/*    */ 
/*    */   private PrimitiveAnalysis(Class cls, String idlName, String javaName)
/*    */   {
/* 88 */     super(cls, idlName, javaName);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.PrimitiveAnalysis
 * JD-Core Version:    0.6.0
 */