/*     */ package org.jboss.iiop.rmi;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.Remote;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.ArrayList;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class OperationAnalysis extends AbstractAnalysis
/*     */ {
/*  50 */   private static final Logger logger = Logger.getLogger(OperationAnalysis.class);
/*     */   private Method method;
/*     */   private ExceptionAnalysis[] mappedExceptions;
/*     */   private ParameterAnalysis[] parameters;
/*     */ 
/*     */   OperationAnalysis(Method method)
/*     */     throws RMIIIOPViolationException
/*     */   {
/*  58 */     super(method.getName());
/*  59 */     logger.debug("new OperationAnalysis: " + method.getName());
/*  60 */     this.method = method;
/*     */ 
/*  63 */     Class retCls = method.getReturnType();
/*  64 */     if ((retCls.isInterface()) && (Remote.class.isAssignableFrom(retCls))) {
/*  65 */       Util.isValidRMIIIOP(retCls);
/*     */     }
/*     */ 
/*  68 */     Class[] ex = method.getExceptionTypes();
/*  69 */     boolean gotRemoteException = false;
/*  70 */     ArrayList a = new ArrayList();
/*  71 */     for (int i = 0; i < ex.length; i++) {
/*  72 */       if (ex[i].isAssignableFrom(RemoteException.class))
/*  73 */         gotRemoteException = true;
/*  74 */       if ((!Exception.class.isAssignableFrom(ex[i])) || (RuntimeException.class.isAssignableFrom(ex[i])) || (RemoteException.class.isAssignableFrom(ex[i]))) {
/*     */         continue;
/*     */       }
/*  77 */       a.add(ExceptionAnalysis.getExceptionAnalysis(ex[i]));
/*     */     }
/*  79 */     if ((!gotRemoteException) && (Remote.class.isAssignableFrom(method.getDeclaringClass())))
/*     */     {
/*  81 */       throw new RMIIIOPViolationException("All interface methods must throw java.rmi.RemoteException, or a superclass of java.rmi.RemoteException, but method " + getJavaName() + " of interface " + method.getDeclaringClass().getName() + " does not.", "1.2.3");
/*     */     }
/*     */ 
/*  86 */     this.mappedExceptions = new ExceptionAnalysis[a.size()];
/*  87 */     this.mappedExceptions = ((ExceptionAnalysis[])(ExceptionAnalysis[])a.toArray(this.mappedExceptions));
/*     */ 
/*  90 */     Class[] params = method.getParameterTypes();
/*  91 */     this.parameters = new ParameterAnalysis[params.length];
/*  92 */     for (int i = 0; i < params.length; i++) {
/*  93 */       logger.debug("OperationAnalysis: " + method.getName() + " has parameter [" + params[i].getName() + "]");
/*     */ 
/*  95 */       this.parameters[i] = new ParameterAnalysis("param" + (i + 1), params[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Class getReturnType()
/*     */   {
/* 106 */     return this.method.getReturnType();
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/* 114 */     return this.method;
/*     */   }
/*     */ 
/*     */   public ExceptionAnalysis[] getMappedExceptions()
/*     */   {
/* 122 */     return (ExceptionAnalysis[])(ExceptionAnalysis[])this.mappedExceptions.clone();
/*     */   }
/*     */ 
/*     */   public ParameterAnalysis[] getParameters()
/*     */   {
/* 130 */     return (ParameterAnalysis[])(ParameterAnalysis[])this.parameters.clone();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.OperationAnalysis
 * JD-Core Version:    0.6.0
 */