/*     */ package org.jboss.iiop.rmi;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ExceptionAnalysis extends ValueAnalysis
/*     */ {
/*  42 */   private static final Logger logger = Logger.getLogger(ExceptionAnalysis.class);
/*     */ 
/*  45 */   private static WorkCacheManager cache = new WorkCacheManager(ExceptionAnalysis.class);
/*     */   private String exceptionRepositoryId;
/*     */ 
/*     */   public static ExceptionAnalysis getExceptionAnalysis(Class cls)
/*     */     throws RMIIIOPViolationException
/*     */   {
/*  51 */     return (ExceptionAnalysis)cache.getAnalysis(cls);
/*     */   }
/*     */ 
/*     */   protected ExceptionAnalysis(Class cls)
/*     */   {
/*  58 */     super(cls);
/*  59 */     logger.debug("ExceptionAnalysis(\"" + cls.getName() + "\") entered.");
/*     */   }
/*     */ 
/*     */   protected void doAnalyze()
/*     */     throws RMIIIOPViolationException
/*     */   {
/*  65 */     super.doAnalyze();
/*     */ 
/*  67 */     if ((!Exception.class.isAssignableFrom(this.cls)) || (RuntimeException.class.isAssignableFrom(this.cls)))
/*     */     {
/*  69 */       throw new RMIIIOPViolationException("Exception type " + this.cls.getName() + " must be a checked exception class.", "1.2.6");
/*     */     }
/*     */ 
/*  74 */     StringBuffer b = new StringBuffer("IDL:");
/*  75 */     String pkgName = this.cls.getPackage().getName();
/*     */ 
/*  77 */     while (!"".equals(pkgName)) {
/*  78 */       int idx = pkgName.indexOf('.');
/*  79 */       String n = idx == -1 ? pkgName : pkgName.substring(0, idx);
/*  80 */       b.append(Util.javaToIDLName(n)).append('/');
/*  81 */       pkgName = idx == -1 ? "" : pkgName.substring(idx + 1);
/*     */     }
/*     */ 
/*  84 */     String base = this.cls.getName();
/*  85 */     base = base.substring(base.lastIndexOf('.') + 1);
/*  86 */     if (base.endsWith("Exception"))
/*  87 */       base = base.substring(0, base.length() - 9);
/*  88 */     base = Util.javaToIDLName(base + "Ex");
/*     */ 
/*  90 */     b.append(base).append(":1.0");
/*  91 */     this.exceptionRepositoryId = b.toString();
/*     */   }
/*     */ 
/*     */   public String getExceptionRepositoryId()
/*     */   {
/* 102 */     return this.exceptionRepositoryId;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.ExceptionAnalysis
 * JD-Core Version:    0.6.0
 */