/*     */ package org.jboss.iiop.rmi;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.ObjectStreamClass;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.rmi.Remote;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.ArrayList;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.omg.CORBA.portable.IDLEntity;
/*     */ 
/*     */ public abstract class ContainerAnalysis extends ClassAnalysis
/*     */ {
/*  48 */   protected final byte M_OVERLOADED = 1;
/*     */ 
/*  51 */   protected final byte M_READ = 2;
/*     */ 
/*  54 */   protected final byte M_WRITE = 4;
/*     */ 
/*  57 */   protected final byte M_READONLY = 8;
/*     */ 
/*  60 */   protected final byte M_INHERITED = 16;
/*     */ 
/*  66 */   protected final byte M_WRITEOBJECT = 32;
/*     */ 
/*  70 */   protected final byte F_CONSTANT = 1;
/*     */ 
/*  76 */   protected final byte F_SPFFIELD = 2;
/*     */   protected Method[] methods;
/*     */   protected byte[] m_flags;
/*     */   protected int[] mutators;
/*     */   protected Field[] fields;
/*     */   protected byte[] f_flags;
/* 112 */   protected long classHashCode = 0L;
/*     */   protected String repositoryId;
/*     */   protected String memberPrefix;
/*     */   protected String memberPostfix;
/*     */   protected InterfaceAnalysis[] interfaces;
/*     */   protected ValueAnalysis[] abstractBaseValuetypes;
/*     */   protected AttributeAnalysis[] attributes;
/*     */   protected ConstantAnalysis[] constants;
/*     */   protected OperationAnalysis[] operations;
/* 156 */   private static final Logger logger = Logger.getLogger(ContainerAnalysis.class);
/*     */ 
/* 838 */   private String idlModuleName = null;
/*     */ 
/*     */   protected ContainerAnalysis(Class cls)
/*     */   {
/* 163 */     super(cls);
/*     */ 
/* 165 */     if ((cls == java.lang.Object.class) || (cls == Serializable.class) || (cls == Externalizable.class))
/*     */     {
/* 168 */       throw new IllegalArgumentException("Cannot analyze special class: " + cls.getName());
/*     */     }
/*     */ 
/* 171 */     this.cls = cls;
/*     */   }
/*     */ 
/*     */   protected void doAnalyze()
/*     */     throws RMIIIOPViolationException
/*     */   {
/* 177 */     analyzeInterfaces();
/* 178 */     analyzeMethods();
/* 179 */     analyzeFields();
/* 180 */     calculateClassHashCode();
/* 181 */     calculateRepositoryId();
/* 182 */     analyzeAttributes();
/* 183 */     analyzeConstants();
/* 184 */     analyzeOperations();
/* 185 */     fixupOverloadedOperationNames();
/*     */   }
/*     */ 
/*     */   public InterfaceAnalysis[] getInterfaces()
/*     */   {
/* 195 */     logger.debug(this.cls + " Interface count: " + this.interfaces.length);
/* 196 */     return (InterfaceAnalysis[])(InterfaceAnalysis[])this.interfaces.clone();
/*     */   }
/*     */ 
/*     */   public ValueAnalysis[] getAbstractBaseValuetypes()
/*     */   {
/* 204 */     logger.debug(this.cls + " Abstract base valuetype count: " + this.abstractBaseValuetypes.length);
/* 205 */     return (ValueAnalysis[])(ValueAnalysis[])this.abstractBaseValuetypes.clone();
/*     */   }
/*     */ 
/*     */   public AttributeAnalysis[] getAttributes()
/*     */   {
/* 213 */     logger.debug(this.cls + " Attribute count: " + this.attributes.length);
/* 214 */     return (AttributeAnalysis[])(AttributeAnalysis[])this.attributes.clone();
/*     */   }
/*     */ 
/*     */   public ConstantAnalysis[] getConstants()
/*     */   {
/* 222 */     logger.debug(this.cls + " Constants count: " + this.constants.length);
/* 223 */     return (ConstantAnalysis[])(ConstantAnalysis[])this.constants.clone();
/*     */   }
/*     */ 
/*     */   public OperationAnalysis[] getOperations()
/*     */   {
/* 231 */     logger.debug(this.cls + " Operations count: " + this.operations.length);
/* 232 */     return (OperationAnalysis[])(OperationAnalysis[])this.operations.clone();
/*     */   }
/*     */ 
/*     */   public String getRepositoryId()
/*     */   {
/* 240 */     return this.repositoryId;
/*     */   }
/*     */ 
/*     */   public String getMemberRepositoryId(String memberName)
/*     */   {
/* 250 */     return this.memberPrefix + escapeIRName(memberName) + this.memberPostfix;
/*     */   }
/*     */ 
/*     */   public String getIDLModuleName()
/*     */   {
/* 259 */     if (this.idlModuleName == null) {
/* 260 */       String pkgName = this.cls.getPackage().getName();
/* 261 */       StringBuffer b = new StringBuffer();
/*     */ 
/* 263 */       while (!"".equals(pkgName)) {
/* 264 */         int idx = pkgName.indexOf('.');
/* 265 */         String n = idx == -1 ? pkgName : pkgName.substring(0, idx);
/*     */ 
/* 267 */         b.append("::").append(Util.javaToIDLName(n));
/*     */ 
/* 269 */         pkgName = idx == -1 ? "" : pkgName.substring(idx + 1);
/*     */       }
/* 271 */       this.idlModuleName = b.toString();
/*     */     }
/* 273 */     return this.idlModuleName;
/*     */   }
/*     */ 
/*     */   protected String toHexString(int i)
/*     */   {
/* 283 */     String s = Integer.toHexString(i).toUpperCase();
/*     */ 
/* 285 */     if (s.length() < 8) {
/* 286 */       return "00000000".substring(0, 8 - s.length()) + s;
/*     */     }
/* 288 */     return s;
/*     */   }
/*     */ 
/*     */   protected String toHexString(long l)
/*     */   {
/* 295 */     String s = Long.toHexString(l).toUpperCase();
/*     */ 
/* 297 */     if (s.length() < 16) {
/* 298 */       return "0000000000000000".substring(0, 16 - s.length()) + s;
/*     */     }
/* 300 */     return s;
/*     */   }
/*     */ 
/*     */   protected boolean isAccessor(Method m)
/*     */   {
/* 308 */     Class returnType = m.getReturnType();
/*     */ 
/* 310 */     String name = m.getName();
/* 311 */     if (((!name.startsWith("get")) || (name.length() <= "get".length())) && (
/* 312 */       (!name.startsWith("is")) || (name.length() <= "is".length()) || (returnType != Boolean.TYPE)))
/*     */     {
/* 314 */       return false;
/* 315 */     }if (returnType == Void.TYPE)
/* 316 */       return false;
/* 317 */     if (m.getParameterTypes().length != 0) {
/* 318 */       return false;
/*     */     }
/* 320 */     return hasNonAppExceptions(m);
/*     */   }
/*     */ 
/*     */   protected boolean isMutator(Method m)
/*     */   {
/* 329 */     String name = m.getName();
/* 330 */     if ((!name.startsWith("set")) || (name.length() <= "set".length()))
/* 331 */       return false;
/* 332 */     if (m.getReturnType() != Void.TYPE)
/* 333 */       return false;
/* 334 */     if (m.getParameterTypes().length != 1)
/* 335 */       return false;
/* 336 */     return hasNonAppExceptions(m);
/*     */   }
/*     */ 
/*     */   protected boolean hasNonAppExceptions(Method m)
/*     */   {
/* 345 */     Class[] ex = m.getExceptionTypes();
/*     */ 
/* 347 */     for (int i = 0; i < ex.length; i++)
/* 348 */       if (!RemoteException.class.isAssignableFrom(ex[i]))
/* 349 */         return false;
/* 350 */     return true;
/*     */   }
/*     */ 
/*     */   protected void analyzeFields()
/*     */   {
/* 360 */     logger.debug(this.cls + " analyzeFields");
/*     */ 
/* 363 */     this.fields = this.cls.getDeclaredFields();
/* 364 */     this.f_flags = new byte[this.fields.length];
/*     */ 
/* 366 */     for (int i = 0; i < this.fields.length; i++) {
/* 367 */       int mods = this.fields[i].getModifiers();
/*     */ 
/* 369 */       if ((!Modifier.isFinal(mods)) || (!Modifier.isStatic(mods)) || (!Modifier.isPublic(mods)))
/*     */         continue;
/*     */       int tmp97_96 = i;
/*     */       byte[] tmp97_93 = this.f_flags; tmp97_93[tmp97_96] = (byte)(tmp97_93[tmp97_96] | 0x1);
/*     */     }
/*     */ 
/* 375 */     logger.debug(this.cls + " analyzeFields fields=" + this.fields.length);
/*     */   }
/*     */ 
/*     */   protected void analyzeInterfaces()
/*     */     throws RMIIIOPViolationException
/*     */   {
/* 385 */     logger.debug(this.cls + " analyzeInterfaces");
/*     */ 
/* 387 */     Class[] intfs = this.cls.getInterfaces();
/* 388 */     ArrayList a = new ArrayList();
/* 389 */     ArrayList b = new ArrayList();
/*     */ 
/* 391 */     for (int i = 0; i < intfs.length; i++)
/*     */     {
/* 393 */       if (intfs[i] == Remote.class) {
/*     */         continue;
/*     */       }
/* 396 */       if (intfs[i] == Serializable.class) {
/*     */         continue;
/*     */       }
/* 399 */       if (intfs[i] == Externalizable.class)
/*     */         continue;
/* 401 */       if (!RmiIdlUtil.isAbstractValueType(intfs[i])) {
/* 402 */         a.add(InterfaceAnalysis.getInterfaceAnalysis(intfs[i]));
/*     */       }
/*     */       else {
/* 405 */         b.add(ValueAnalysis.getValueAnalysis(intfs[i]));
/*     */       }
/*     */     }
/*     */ 
/* 409 */     this.interfaces = new InterfaceAnalysis[a.size()];
/* 410 */     this.interfaces = ((InterfaceAnalysis[])(InterfaceAnalysis[])a.toArray(this.interfaces));
/*     */ 
/* 412 */     this.abstractBaseValuetypes = new ValueAnalysis[b.size()];
/* 413 */     this.abstractBaseValuetypes = ((ValueAnalysis[])(ValueAnalysis[])b.toArray(this.abstractBaseValuetypes));
/*     */ 
/* 415 */     logger.debug(this.cls + " analyzeInterfaces interfaces=" + this.interfaces.length + " abstractBaseValueTypes=" + this.abstractBaseValuetypes.length);
/*     */   }
/*     */ 
/*     */   protected void analyzeMethods()
/*     */   {
/* 425 */     logger.debug(this.cls + " analyzeMethods");
/*     */ 
/* 431 */     if ((this.cls.isInterface()) && (Remote.class.isAssignableFrom(this.cls)))
/* 432 */       this.methods = this.cls.getMethods();
/*     */     else
/* 434 */       this.methods = this.cls.getDeclaredMethods();
/* 435 */     this.m_flags = new byte[this.methods.length];
/* 436 */     this.mutators = new int[this.methods.length];
/*     */ 
/* 439 */     for (int i = 0; i < this.methods.length; i++)
/* 440 */       this.mutators[i] = -1;
/* 441 */     for (int i = 0; i < this.methods.length; i++) {
/* 442 */       logger.debug("analyzeMethods(): method[" + i + "].getName()=\"" + this.methods[i].getName() + "\".");
/*     */ 
/* 445 */       if ((isAccessor(this.methods[i])) && ((this.m_flags[i] & 0x2) == 0)) {
/* 446 */         String attrName = attributeReadName(this.methods[i].getName());
/* 447 */         Class iReturn = this.methods[i].getReturnType();
/* 448 */         for (int j = i + 1; j < this.methods.length; j++) {
/* 449 */           if ((!isMutator(this.methods[j])) || ((this.m_flags[j] & 0x4) != 0) || (!attrName.equals(attributeWriteName(this.methods[j].getName()))))
/*     */             continue;
/* 451 */           Class[] jParams = this.methods[j].getParameterTypes();
/* 452 */           if ((jParams.length == 1) && (jParams[0] == iReturn))
/*     */           {
/*     */             int tmp322_321 = i;
/*     */             byte[] tmp322_318 = this.m_flags; tmp322_318[tmp322_321] = (byte)(tmp322_318[tmp322_321] | 0x2);
/*     */             int tmp334_332 = j;
/*     */             byte[] tmp334_329 = this.m_flags; tmp334_329[tmp334_332] = (byte)(tmp334_329[tmp334_332] | 0x4);
/* 455 */             this.mutators[i] = j;
/* 456 */             break;
/*     */           }
/*     */         }
/*     */       }
/* 460 */       else if ((isMutator(this.methods[i])) && ((this.m_flags[i] & 0x4) == 0)) {
/* 461 */         String attrName = attributeWriteName(this.methods[i].getName());
/* 462 */         Class[] iParams = this.methods[i].getParameterTypes();
/* 463 */         for (int j = i + 1; j < this.methods.length; j++) {
/* 464 */           if ((!isAccessor(this.methods[j])) || ((this.m_flags[j] & 0x2) != 0) || (!attrName.equals(attributeReadName(this.methods[j].getName()))))
/*     */             continue;
/* 466 */           Class jReturn = this.methods[j].getReturnType();
/* 467 */           if ((iParams.length == 1) && (iParams[0] == jReturn))
/*     */           {
/*     */             int tmp501_500 = i;
/*     */             byte[] tmp501_497 = this.m_flags; tmp501_497[tmp501_500] = (byte)(tmp501_497[tmp501_500] | 0x4);
/*     */             int tmp513_511 = j;
/*     */             byte[] tmp513_508 = this.m_flags; tmp513_508[tmp513_511] = (byte)(tmp513_508[tmp513_511] | 0x2);
/* 470 */             this.mutators[j] = i;
/* 471 */             break;
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 479 */     for (int i = 0; i < this.methods.length; i++) {
/* 480 */       if (((this.m_flags[i] & 0x6) == 0) && (isAccessor(this.methods[i])))
/*     */       {
/*     */         int tmp583_582 = i;
/*     */         byte[] tmp583_579 = this.m_flags; tmp583_579[tmp583_582] = (byte)(tmp583_579[tmp583_582] | 0x8);
/*     */       }
/*     */     }
/* 484 */     for (int i = 0; i < this.methods.length; i++) {
/* 485 */       if ((this.m_flags[i] & 0xE) == 0) {
/* 486 */         String iName = this.methods[i].getName();
/*     */ 
/* 488 */         for (int j = i + 1; j < this.methods.length; j++) {
/* 489 */           if (iName.equals(this.methods[j].getName()))
/*     */           {
/*     */             int tmp663_662 = i;
/*     */             byte[] tmp663_659 = this.m_flags; tmp663_659[tmp663_662] = (byte)(tmp663_659[tmp663_662] | 0x1);
/*     */             int tmp674_673 = j;
/*     */             byte[] tmp674_670 = this.m_flags; tmp674_670[tmp674_673] = (byte)(tmp674_670[tmp674_673] | 0x1);
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 496 */       if (this.methods[i].getDeclaringClass() != this.cls)
/*     */       {
/*     */         int tmp707_706 = i;
/*     */         byte[] tmp707_703 = this.m_flags; tmp707_703[tmp707_706] = (byte)(tmp707_703[tmp707_706] | 0x10);
/*     */       }
/*     */     }
/* 500 */     logger.debug(this.cls + " analyzeMethods methods=" + this.methods.length);
/*     */   }
/*     */ 
/*     */   protected String attributeReadName(String name)
/*     */   {
/* 509 */     if (name.startsWith("get"))
/* 510 */       name = name.substring(3);
/* 511 */     else if (name.startsWith("is"))
/* 512 */       name = name.substring(2);
/*     */     else {
/* 514 */       throw new IllegalArgumentException("Not an accessor: " + name);
/*     */     }
/* 516 */     return name;
/*     */   }
/*     */ 
/*     */   protected String attributeWriteName(String name)
/*     */   {
/* 525 */     if (name.startsWith("set"))
/* 526 */       name = name.substring(3);
/*     */     else {
/* 528 */       throw new IllegalArgumentException("Not an accessor: " + name);
/*     */     }
/* 530 */     return name;
/*     */   }
/*     */ 
/*     */   protected void analyzeConstants()
/*     */     throws RMIIIOPViolationException
/*     */   {
/* 540 */     logger.debug(this.cls + " analyzeConstants");
/*     */ 
/* 542 */     ArrayList a = new ArrayList();
/*     */ 
/* 544 */     for (int i = 0; i < this.fields.length; i++) {
/* 545 */       logger.debug("f_flags[" + i + "]=" + this.f_flags[i]);
/* 546 */       if ((this.f_flags[i] & 0x1) == 0) {
/*     */         continue;
/*     */       }
/* 549 */       Class type = this.fields[i].getType();
/*     */ 
/* 552 */       if ((!type.isPrimitive()) && (type != String.class))
/*     */       {
/* 554 */         if (this.cls.isInterface()) {
/* 555 */           throw new RMIIIOPViolationException("Field \"" + this.fields[i].getName() + "\" of interface \"" + this.cls.getName() + "\" is a constant, but not of one " + "of the primitive types, or String.", "1.2.3");
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 563 */         String name = this.fields[i].getName();
/*     */         java.lang.Object value;
/*     */         try
/*     */         {
/* 567 */           value = this.fields[i].get(null);
/*     */         } catch (Exception ex) {
/* 569 */           throw new RuntimeException(ex.toString());
/*     */         }
/*     */ 
/* 572 */         logger.debug("Constant[" + i + "] name= " + name);
/* 573 */         logger.debug("Constant[" + i + "] type= " + type.getName());
/* 574 */         logger.debug("Constant[" + i + "] value= " + value);
/* 575 */         a.add(new ConstantAnalysis(name, type, value));
/*     */       }
/*     */     }
/* 578 */     this.constants = new ConstantAnalysis[a.size()];
/* 579 */     this.constants = ((ConstantAnalysis[])(ConstantAnalysis[])a.toArray(this.constants));
/* 580 */     logger.debug(this.cls + " analyzeConstants constant=" + a.size());
/*     */   }
/*     */ 
/*     */   protected void analyzeAttributes()
/*     */     throws RMIIIOPViolationException
/*     */   {
/* 590 */     logger.debug(this.cls + " analyzeAttributes");
/*     */ 
/* 592 */     ArrayList a = new ArrayList();
/*     */ 
/* 594 */     for (int i = 0; i < this.methods.length; i++) {
/* 595 */       logger.debug("m_flags[" + i + "]=" + this.m_flags[i]);
/*     */ 
/* 599 */       if ((this.m_flags[i] & 0xA) == 0)
/*     */         continue;
/* 601 */       String name = attributeReadName(this.methods[i].getName());
/*     */ 
/* 603 */       logger.debug("Attribute[" + i + "] name= " + name);
/* 604 */       if ((this.m_flags[i] & 0x8) != 0)
/* 605 */         a.add(new AttributeAnalysis(name, this.methods[i]));
/*     */       else {
/* 607 */         a.add(new AttributeAnalysis(name, this.methods[i], this.methods[this.mutators[i]]));
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 612 */     this.attributes = new AttributeAnalysis[a.size()];
/* 613 */     this.attributes = ((AttributeAnalysis[])(AttributeAnalysis[])a.toArray(this.attributes));
/*     */ 
/* 615 */     logger.debug(this.cls + " analyzeAttributes attributes=" + a.size());
/*     */   }
/*     */ 
/*     */   protected void analyzeOperations()
/*     */     throws RMIIIOPViolationException
/*     */   {
/* 627 */     logger.debug(this.cls + " analyzeOperations");
/* 628 */     this.operations = new OperationAnalysis[0];
/* 629 */     logger.debug(this.cls + " analyzeOperations operations=" + this.operations.length);
/*     */   }
/*     */ 
/*     */   protected void fixupOverloadedOperationNames()
/*     */     throws RMIIIOPViolationException
/*     */   {
/* 639 */     for (int i = 0; i < this.methods.length; i++) {
/* 640 */       if ((this.m_flags[i] & 0x1) == 0)
/*     */       {
/*     */         continue;
/*     */       }
/* 644 */       OperationAnalysis oa = null;
/* 645 */       String javaName = this.methods[i].getName();
/* 646 */       for (int opIdx = 0; (oa == null) && (opIdx < this.operations.length); opIdx++) {
/* 647 */         if (this.operations[opIdx].getMethod().equals(this.methods[i]))
/* 648 */           oa = this.operations[opIdx];
/*     */       }
/* 650 */       if (oa == null)
/*     */       {
/*     */         continue;
/*     */       }
/* 654 */       ParameterAnalysis[] parms = oa.getParameters();
/* 655 */       StringBuffer b = new StringBuffer(oa.getIDLName());
/* 656 */       if (parms.length == 0)
/* 657 */         b.append("__");
/* 658 */       for (int j = 0; j < parms.length; j++) {
/* 659 */         String s = parms[j].getTypeIDLName();
/*     */ 
/* 661 */         if (s.startsWith("::")) {
/* 662 */           s = s.substring(2);
/*     */         }
/* 664 */         if (s.startsWith("_"))
/*     */         {
/* 666 */           s = s.substring(1);
/*     */         }
/*     */ 
/* 669 */         b.append('_');
/*     */ 
/* 671 */         while (!"".equals(s)) {
/* 672 */           int idx = s.indexOf("::");
/*     */ 
/* 674 */           b.append('_');
/*     */ 
/* 676 */           if (idx == -1) {
/* 677 */             b.append(s);
/* 678 */             s = "";
/*     */           } else {
/* 680 */             b.append(s.substring(0, idx));
/* 681 */             if ((s.length() > idx + 2) && (s.charAt(idx + 2) == '_'))
/*     */             {
/* 683 */               s = s.substring(idx + 3);
/*     */             }
/* 685 */             else s = s.substring(idx + 2);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 692 */       oa.setIDLName(b.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void fixupCaseNames()
/*     */     throws RMIIIOPViolationException
/*     */   {
/* 703 */     ArrayList entries = getContainedEntries();
/* 704 */     boolean[] clash = new boolean[entries.size()];
/* 705 */     String[] upperNames = new String[entries.size()];
/*     */ 
/* 707 */     for (int i = 0; i < entries.size(); i++) {
/* 708 */       AbstractAnalysis aa = (AbstractAnalysis)entries.get(i);
/*     */ 
/* 710 */       clash[i] = false;
/* 711 */       upperNames[i] = aa.getIDLName().toUpperCase();
/*     */ 
/* 713 */       for (int j = 0; j < i; j++) {
/* 714 */         if (upperNames[i].equals(upperNames[j])) {
/* 715 */           clash[i] = true;
/* 716 */           clash[j] = true;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 721 */     for (int i = 0; i < entries.size(); i++) {
/* 722 */       if (clash[i] == 0) {
/*     */         continue;
/*     */       }
/* 725 */       AbstractAnalysis aa = (AbstractAnalysis)entries.get(i);
/* 726 */       boolean noUpper = true;
/* 727 */       String name = aa.getIDLName();
/* 728 */       StringBuffer b = new StringBuffer(name);
/* 729 */       b.append('_');
/* 730 */       for (int j = 0; j < name.length(); j++) {
/* 731 */         if (!Character.isUpperCase(name.charAt(j)))
/*     */           continue;
/* 733 */         if (noUpper)
/* 734 */           noUpper = false;
/*     */         else
/* 736 */           b.append('_');
/* 737 */         b.append(j);
/*     */       }
/*     */ 
/* 740 */       aa.setIDLName(b.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected abstract ArrayList getContainedEntries();
/*     */ 
/*     */   protected void calculateClassHashCode()
/*     */   {
/* 760 */     if (this.cls.isInterface())
/* 761 */       this.classHashCode = 0L;
/* 762 */     else if (!Serializable.class.isAssignableFrom(this.cls))
/* 763 */       this.classHashCode = 0L;
/* 764 */     else if (Externalizable.class.isAssignableFrom(this.cls))
/* 765 */       this.classHashCode = 1L;
/*     */     else
/* 767 */       this.classHashCode = Util.getClassHashCode(this.cls);
/*     */   }
/*     */ 
/*     */   protected String escapeIRName(String name)
/*     */   {
/* 775 */     StringBuffer b = new StringBuffer();
/*     */ 
/* 777 */     for (int i = 0; i < name.length(); i++) {
/* 778 */       char c = name.charAt(i);
/*     */ 
/* 780 */       if (c < 'Ā')
/* 781 */         b.append(c);
/*     */       else
/* 783 */         b.append("\\U").append(toHexString(c));
/*     */     }
/* 785 */     return b.toString();
/*     */   }
/*     */ 
/*     */   protected void calculateRepositoryId()
/*     */   {
/* 796 */     if ((this.cls.isArray()) || (this.cls.isPrimitive())) {
/* 797 */       throw new IllegalArgumentException("Not a class or interface.");
/*     */     }
/* 799 */     if ((this.cls.isInterface()) && (org.omg.CORBA.Object.class.isAssignableFrom(this.cls)) && (IDLEntity.class.isAssignableFrom(this.cls)))
/*     */     {
/* 803 */       StringBuffer b = new StringBuffer("IDL:");
/* 804 */       b.append(this.cls.getPackage().getName().replace('.', '/'));
/* 805 */       b.append('/');
/* 806 */       String base = this.cls.getName();
/* 807 */       base = base.substring(base.lastIndexOf('.') + 1);
/* 808 */       b.append(base).append(":1.0");
/* 809 */       this.repositoryId = b.toString();
/*     */     }
/*     */     else {
/* 812 */       StringBuffer b = new StringBuffer("RMI:");
/* 813 */       b.append(escapeIRName(this.cls.getName()));
/* 814 */       this.memberPrefix = (b.toString() + ".");
/* 815 */       String hashStr = toHexString(this.classHashCode);
/* 816 */       b.append(':').append(hashStr);
/* 817 */       ObjectStreamClass osClass = ObjectStreamClass.lookup(this.cls);
/* 818 */       if (osClass != null) {
/* 819 */         long serialVersionUID = osClass.getSerialVersionUID();
/* 820 */         String SVUID = toHexString(serialVersionUID);
/*     */ 
/* 822 */         if (this.classHashCode != serialVersionUID)
/* 823 */           b.append(':').append(SVUID);
/* 824 */         this.memberPostfix = (":" + hashStr + ":" + SVUID);
/*     */       } else {
/* 826 */         this.memberPostfix = (":" + hashStr);
/*     */       }
/* 828 */       this.repositoryId = b.toString();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.ContainerAnalysis
 * JD-Core Version:    0.6.0
 */