/*     */ package org.jboss.iiop.csiv2;
/*     */ 
/*     */ import org.jboss.iiop.CorbaORBService;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.omg.CORBA.Any;
/*     */ import org.omg.CORBA.BAD_PARAM;
/*     */ import org.omg.CORBA.LocalObject;
/*     */ import org.omg.CORBA.MARSHAL;
/*     */ import org.omg.CORBA.NO_PERMISSION;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CSI.CompleteEstablishContext;
/*     */ import org.omg.CSI.ContextError;
/*     */ import org.omg.CSI.EstablishContext;
/*     */ import org.omg.CSI.GSS_NT_ExportedNameHelper;
/*     */ import org.omg.CSI.IdentityToken;
/*     */ import org.omg.CSI.MessageInContext;
/*     */ import org.omg.CSI.SASContextBody;
/*     */ import org.omg.CSI.SASContextBodyHelper;
/*     */ import org.omg.GSSUP.ErrorToken;
/*     */ import org.omg.GSSUP.ErrorTokenHelper;
/*     */ import org.omg.GSSUP.InitialContextToken;
/*     */ import org.omg.IOP.Codec;
/*     */ import org.omg.IOP.CodecPackage.FormatMismatch;
/*     */ import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
/*     */ import org.omg.IOP.CodecPackage.TypeMismatch;
/*     */ import org.omg.IOP.ServiceContext;
/*     */ import org.omg.PortableInterceptor.ServerRequestInfo;
/*     */ import org.omg.PortableInterceptor.ServerRequestInterceptor;
/*     */ 
/*     */ public class SASTargetInterceptor extends LocalObject
/*     */   implements ServerRequestInterceptor
/*     */ {
/*  80 */   private static final Logger log = Logger.getLogger(SASTargetInterceptor.class);
/*     */ 
/*  82 */   private static final boolean traceEnabled = log.isTraceEnabled();
/*     */   private static final int sasContextId = 15;
/*  87 */   private static final byte[] empty = new byte[0];
/*     */ 
/* 100 */   private static final IdentityToken absent = new IdentityToken();
/*     */   private static final SASContextBody msgBodyCtxAccepted;
/*     */   private static final Any msgCtx0Accepted;
/*     */   private final Codec codec;
/*     */   private final SASContextBody msgBodyCtxError;
/*     */   private final Any msgCtx0Rejected;
/* 143 */   private ThreadLocal threadLocalData = new ThreadLocal()
/*     */   {
/*     */     protected synchronized Object initialValue() {
/* 146 */       return new SASTargetInterceptor.CurrentRequestInfo();
/*     */     }
/* 143 */   };
/*     */ 
/*     */   private static Any createMsgCtxAccepted(long contextId)
/*     */   {
/* 123 */     Any any = ORB.init().create_any();
/* 124 */     synchronized (msgBodyCtxAccepted)
/*     */     {
/* 126 */       msgBodyCtxAccepted.complete_msg().client_context_id = contextId;
/* 127 */       SASContextBodyHelper.insert(any, msgBodyCtxAccepted);
/*     */     }
/* 129 */     return any;
/*     */   }
/*     */ 
/*     */   private Any createMsgCtxError(long contextId, int majorStatus)
/*     */   {
/* 179 */     Any any = ORB.init().create_any();
/* 180 */     synchronized (this.msgBodyCtxError)
/*     */     {
/* 182 */       this.msgBodyCtxError.error_msg().client_context_id = contextId;
/* 183 */       this.msgBodyCtxError.error_msg().major_status = majorStatus;
/* 184 */       SASContextBodyHelper.insert(any, this.msgBodyCtxError);
/*     */     }
/* 186 */     return any;
/*     */   }
/*     */ 
/*     */   public SASTargetInterceptor(Codec codec) {
/* 193 */     this.codec = codec;
/*     */ 
/* 198 */     ErrorToken errorToken = new ErrorToken(1);
/* 199 */     Any any = ORB.init().create_any();
/*     */ 
/* 202 */     ErrorTokenHelper.insert(any, errorToken);
/*     */     byte[] encapsulatedErrorToken;
/*     */     try {
/* 205 */       encapsulatedErrorToken = codec.encode_value(any);
/*     */     }
/*     */     catch (InvalidTypeForEncoding e)
/*     */     {
/* 209 */       throw new RuntimeException("Unexpected exception: " + e);
/*     */     }
/*     */ 
/* 213 */     ContextError ctxError = new ContextError(0L, 1, 1, encapsulatedErrorToken);
/*     */ 
/* 219 */     this.msgBodyCtxError = new SASContextBody();
/* 220 */     this.msgBodyCtxError.error_msg(ctxError);
/*     */ 
/* 223 */     this.msgCtx0Rejected = createMsgCtxError(0L, 1);
/*     */   }
/*     */ 
/*     */   boolean sasContextReceived()
/*     */   {
/* 234 */     CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
/*     */ 
/* 236 */     return threadLocal.sasContextReceived;
/*     */   }
/*     */ 
/*     */   boolean authenticationTokenReceived()
/*     */   {
/* 245 */     CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
/*     */ 
/* 247 */     return threadLocal.authenticationTokenReceived;
/*     */   }
/*     */ 
/*     */   byte[] getIncomingUsername()
/*     */   {
/* 255 */     CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
/*     */ 
/* 257 */     return threadLocal.incomingUsername;
/*     */   }
/*     */ 
/*     */   byte[] getIncomingPassword()
/*     */   {
/* 265 */     CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
/*     */ 
/* 267 */     return threadLocal.incomingPassword;
/*     */   }
/*     */ 
/*     */   byte[] getIncomingTargetName()
/*     */   {
/* 275 */     CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
/*     */ 
/* 277 */     return threadLocal.incomingTargetName;
/*     */   }
/*     */ 
/*     */   IdentityToken getIncomingIdentity()
/*     */   {
/* 286 */     CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
/*     */ 
/* 288 */     return threadLocal.incomingIdentity;
/*     */   }
/*     */ 
/*     */   byte[] getIncomingPrincipalName()
/*     */   {
/* 296 */     CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
/*     */ 
/* 298 */     return threadLocal.incomingPrincipalName;
/*     */   }
/*     */ 
/*     */   void rejectIncomingContext()
/*     */   {
/* 307 */     CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
/*     */ 
/* 310 */     if (threadLocal.sasContextReceived)
/*     */     {
/* 312 */       threadLocal.sasReply = (threadLocal.contextId == 0L ? this.msgCtx0Rejected : createMsgCtxError(threadLocal.contextId, 1));
/*     */ 
/* 317 */       threadLocal.sasReplyIsAccept = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public String name()
/*     */   {
/* 325 */     return "SASTargetInterceptor";
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void receive_request_service_contexts(ServerRequestInfo ri)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void receive_request(ServerRequestInfo ri)
/*     */   {
/* 344 */     if (traceEnabled)
/* 345 */       log.trace("receive_request " + ri.operation());
/* 346 */     CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
/*     */ 
/* 349 */     threadLocal.sasContextReceived = false;
/* 350 */     threadLocal.authenticationTokenReceived = false;
/* 351 */     threadLocal.incomingUsername = empty;
/* 352 */     threadLocal.incomingPassword = empty;
/* 353 */     threadLocal.incomingTargetName = empty;
/* 354 */     threadLocal.incomingIdentity = absent;
/* 355 */     threadLocal.incomingPrincipalName = empty;
/* 356 */     threadLocal.sasReply = null;
/* 357 */     threadLocal.sasReplyIsAccept = false;
/*     */     try
/*     */     {
/* 361 */       ServiceContext sc = ri.get_request_service_context(15);
/* 362 */       Any any = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
/*     */ 
/* 364 */       SASContextBody contextBody = SASContextBodyHelper.extract(any);
/*     */ 
/* 366 */       if (contextBody == null)
/*     */       {
/* 369 */         return;
/*     */       }
/* 371 */       if (contextBody.discriminator() == 5)
/*     */       {
/* 375 */         long contextId = contextBody.in_context_msg().client_context_id;
/*     */ 
/* 377 */         threadLocal.sasReply = createMsgCtxError(contextId, 4);
/*     */ 
/* 380 */         throw new NO_PERMISSION("SAS context does not exist.");
/*     */       }
/* 382 */       if (contextBody.discriminator() == 0)
/*     */       {
/* 384 */         EstablishContext message = contextBody.establish_msg();
/* 385 */         threadLocal.contextId = message.client_context_id;
/* 386 */         threadLocal.sasContextReceived = true;
/*     */ 
/* 388 */         if ((message.client_authentication_token != null) && (message.client_authentication_token.length > 0))
/*     */         {
/* 391 */           if (traceEnabled)
/* 392 */             log.trace("received client authentication token");
/* 393 */           InitialContextToken authToken = CSIv2Util.decodeInitialContextToken(message.client_authentication_token, this.codec);
/*     */ 
/* 397 */           if (authToken == null)
/*     */           {
/* 399 */             threadLocal.sasReply = createMsgCtxError(message.client_context_id, 2);
/*     */ 
/* 403 */             throw new NO_PERMISSION("Could not decode initial context token.");
/*     */           }
/*     */ 
/* 406 */           threadLocal.incomingUsername = authToken.username;
/* 407 */           threadLocal.incomingPassword = authToken.password;
/* 408 */           threadLocal.incomingTargetName = CSIv2Util.decodeGssExportedName(authToken.target_name);
/*     */ 
/* 410 */           if (threadLocal.incomingTargetName == null)
/*     */           {
/* 412 */             threadLocal.sasReply = createMsgCtxError(message.client_context_id, 2);
/*     */ 
/* 416 */             throw new NO_PERMISSION("Could not decode target name in initial context token.");
/*     */           }
/*     */ 
/* 421 */           threadLocal.authenticationTokenReceived = true;
/*     */         }
/* 423 */         if (message.identity_token != null)
/*     */         {
/* 425 */           if (traceEnabled)
/* 426 */             log.trace("received identity token");
/* 427 */           threadLocal.incomingIdentity = message.identity_token;
/* 428 */           if (message.identity_token.discriminator() == 2)
/*     */           {
/* 432 */             Any a = this.codec.decode_value(message.identity_token.principal_name(), GSS_NT_ExportedNameHelper.type());
/*     */ 
/* 435 */             byte[] encodedName = GSS_NT_ExportedNameHelper.extract(a);
/*     */ 
/* 438 */             threadLocal.incomingPrincipalName = CSIv2Util.decodeGssExportedName(encodedName);
/*     */ 
/* 441 */             if (threadLocal.incomingPrincipalName == null)
/*     */             {
/* 443 */               threadLocal.sasReply = createMsgCtxError(message.client_context_id, 2);
/*     */ 
/* 447 */               throw new NO_PERMISSION("Could not decode incoming principal name.");
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/* 452 */         threadLocal.sasReply = (threadLocal.contextId == 0L ? msgCtx0Accepted : createMsgCtxAccepted(threadLocal.contextId));
/*     */ 
/* 455 */         threadLocal.sasReplyIsAccept = true;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (BAD_PARAM e)
/*     */     {
/*     */     }
/*     */     catch (FormatMismatch e)
/*     */     {
/* 464 */       throw new MARSHAL("Exception decoding context data in SASTargetInterceptor: " + e);
/*     */     }
/*     */     catch (TypeMismatch e)
/*     */     {
/* 469 */       throw new MARSHAL("Exception decoding context data in SASTargetInterceptor: " + e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void send_reply(ServerRequestInfo ri)
/*     */   {
/* 476 */     if (traceEnabled)
/* 477 */       log.trace("send_reply " + ri.operation());
/* 478 */     CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
/*     */ 
/* 481 */     if (threadLocal.sasReply != null)
/*     */     {
/*     */       try
/*     */       {
/* 485 */         ServiceContext sc = new ServiceContext(15, this.codec.encode_value(threadLocal.sasReply));
/*     */ 
/* 488 */         ri.add_reply_service_context(sc, true);
/*     */       }
/*     */       catch (InvalidTypeForEncoding e)
/*     */       {
/* 492 */         throw new MARSHAL("Unexpected exception: " + e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void send_exception(ServerRequestInfo ri)
/*     */   {
/* 499 */     if (traceEnabled)
/* 500 */       log.trace("send_exception " + ri.operation() + ": ");
/* 501 */     CurrentRequestInfo threadLocal = (CurrentRequestInfo)this.threadLocalData.get();
/*     */ 
/* 514 */     if ((threadLocal.sasReply != null) && ((!threadLocal.sasReplyIsAccept) || (CorbaORBService.getSendSASAcceptWithExceptionEnabledFlag() == true)))
/*     */     {
/*     */       try
/*     */       {
/* 520 */         ServiceContext sc = new ServiceContext(15, this.codec.encode_value(threadLocal.sasReply));
/*     */ 
/* 523 */         ri.add_reply_service_context(sc, true);
/*     */       }
/*     */       catch (InvalidTypeForEncoding e)
/*     */       {
/* 527 */         throw new MARSHAL("Unexpected exception: " + e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void send_other(ServerRequestInfo ri)
/*     */   {
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 101 */     absent.absent(true);
/*     */ 
/* 107 */     CompleteEstablishContext ctxAccepted = new CompleteEstablishContext(0L, false, new byte[0]);
/*     */ 
/* 112 */     msgBodyCtxAccepted = new SASContextBody();
/* 113 */     msgBodyCtxAccepted.complete_msg(ctxAccepted);
/*     */ 
/* 116 */     msgCtx0Accepted = createMsgCtxAccepted(0L);
/*     */   }
/*     */ 
/*     */   private static class CurrentRequestInfo
/*     */   {
/*     */     boolean sasContextReceived;
/*     */     boolean authenticationTokenReceived;
/*     */     byte[] incomingUsername;
/*     */     byte[] incomingPassword;
/*     */     byte[] incomingTargetName;
/*     */     IdentityToken incomingIdentity;
/*     */     byte[] incomingPrincipalName;
/*     */     long contextId;
/*     */     Any sasReply;
/*     */     boolean sasReplyIsAccept;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.csiv2.SASTargetInterceptor
 * JD-Core Version:    0.6.0
 */