/*     */ package org.jboss.iiop.csiv2;
/*     */ 
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.security.Principal;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ import org.omg.CORBA.Any;
/*     */ import org.omg.CORBA.BAD_PARAM;
/*     */ import org.omg.CORBA.CompletionStatus;
/*     */ import org.omg.CORBA.LocalObject;
/*     */ import org.omg.CORBA.MARSHAL;
/*     */ import org.omg.CORBA.NO_PERMISSION;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CSI.AuthorizationElement;
/*     */ import org.omg.CSI.EstablishContext;
/*     */ import org.omg.CSI.IdentityToken;
/*     */ import org.omg.CSI.SASContextBody;
/*     */ import org.omg.CSI.SASContextBodyHelper;
/*     */ import org.omg.CSIIOP.AS_ContextSec;
/*     */ import org.omg.CSIIOP.CompoundSecMech;
/*     */ import org.omg.GSSUP.InitialContextToken;
/*     */ import org.omg.IOP.Codec;
/*     */ import org.omg.IOP.CodecPackage.FormatMismatch;
/*     */ import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
/*     */ import org.omg.IOP.CodecPackage.TypeMismatch;
/*     */ import org.omg.IOP.ServiceContext;
/*     */ import org.omg.PortableInterceptor.ClientRequestInfo;
/*     */ import org.omg.PortableInterceptor.ClientRequestInterceptor;
/*     */ 
/*     */ public class SASClientInterceptor extends LocalObject
/*     */   implements ClientRequestInterceptor
/*     */ {
/*     */   private static final int sasContextId = 15;
/*  84 */   private static final IdentityToken absentIdentityToken = new IdentityToken();
/*     */   private static final AuthorizationElement[] noAuthorizationToken;
/*     */   private static final Logger log;
/*     */   private static final boolean traceEnabled;
/*     */   private Codec codec;
/*     */ 
/*     */   public SASClientInterceptor(Codec codec)
/*     */   {
/* 102 */     this.codec = codec;
/*     */   }
/*     */ 
/*     */   public String name()
/*     */   {
/* 112 */     return "SASClientInterceptor";
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void send_request(ClientRequestInfo ri)
/*     */   {
/*     */     try
/*     */     {
/* 126 */       CompoundSecMech secMech = CSIv2Util.getMatchingSecurityMech(ri, this.codec, 64, 0);
/*     */ 
/* 132 */       if (secMech == null) {
/* 133 */         return;
/*     */       }
/* 135 */       if ((secMech.as_context_mech.target_supports & 0x40) != 0)
/*     */       {
/* 138 */         Principal p = SecurityAssociation.getPrincipal();
/* 139 */         if (p != null)
/*     */         {
/* 141 */           byte[] encodedTargetName = secMech.as_context_mech.target_name;
/*     */ 
/* 144 */           String name = p.getName();
/* 145 */           if (name.indexOf('@') < 0)
/*     */           {
/* 147 */             byte[] decodedTargetName = CSIv2Util.decodeGssExportedName(encodedTargetName);
/*     */ 
/* 149 */             String targetName = new String(decodedTargetName, "UTF-8");
/* 150 */             name = name + "@" + targetName;
/*     */           }
/* 152 */           byte[] username = name.getBytes("UTF-8");
/*     */ 
/* 155 */           Object credential = SecurityAssociation.getCredential();
/* 156 */           byte[] password = new byte[0];
/* 157 */           if ((credential instanceof char[]))
/*     */           {
/* 159 */             String tmp = new String((char[])(char[])credential);
/* 160 */             password = tmp.getBytes("UTF-8");
/*     */           }
/* 162 */           else if ((credential instanceof byte[])) {
/* 163 */             password = (byte[])(byte[])credential;
/* 164 */           } else if (credential != null)
/*     */           {
/* 166 */             String tmp = credential.toString();
/* 167 */             password = tmp.getBytes("UTF-8");
/*     */           }
/*     */ 
/* 171 */           InitialContextToken authenticationToken = new InitialContextToken(username, password, encodedTargetName);
/*     */ 
/* 176 */           byte[] encodedAuthenticationToken = CSIv2Util.encodeInitialContextToken(authenticationToken, this.codec);
/*     */ 
/* 181 */           EstablishContext message = new EstablishContext(0L, noAuthorizationToken, absentIdentityToken, encodedAuthenticationToken);
/*     */ 
/* 188 */           SASContextBody contextBody = new SASContextBody();
/* 189 */           contextBody.establish_msg(message);
/*     */ 
/* 192 */           Any any = ORB.init().create_any();
/* 193 */           SASContextBodyHelper.insert(any, contextBody);
/* 194 */           ServiceContext sc = new ServiceContext(15, this.codec.encode_value(any));
/*     */ 
/* 196 */           ri.add_request_service_context(sc, true);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (UnsupportedEncodingException e)
/*     */     {
/* 203 */       throw new MARSHAL("Unexpected exception: " + e);
/*     */     }
/*     */     catch (InvalidTypeForEncoding e)
/*     */     {
/* 207 */       throw new MARSHAL("Unexpected exception: " + e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void send_poll(ClientRequestInfo ri)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void receive_reply(ClientRequestInfo ri)
/*     */   {
/*     */     try
/*     */     {
/* 220 */       ServiceContext sc = ri.get_reply_service_context(15);
/* 221 */       Any msg = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
/*     */ 
/* 223 */       SASContextBody contextBody = SASContextBodyHelper.extract(msg);
/*     */ 
/* 230 */       if (traceEnabled) {
/* 231 */         log.trace("receive_reply: got SAS reply, type " + contextBody.discriminator());
/*     */       }
/*     */ 
/* 234 */       if (contextBody.discriminator() == 4)
/*     */       {
/* 237 */         log.warn("Unexpected ContextError in SAS reply");
/* 238 */         throw new NO_PERMISSION("Unexpected ContextError in SAS reply", 1245904897, CompletionStatus.COMPLETED_YES);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (BAD_PARAM e)
/*     */     {
/*     */     }
/*     */     catch (FormatMismatch e)
/*     */     {
/* 249 */       throw new MARSHAL("Could not parse SAS reply: " + e, 0, CompletionStatus.COMPLETED_YES);
/*     */     }
/*     */     catch (TypeMismatch e)
/*     */     {
/* 255 */       throw new MARSHAL("Could not parse SAS reply: " + e, 0, CompletionStatus.COMPLETED_YES);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void receive_exception(ClientRequestInfo ri)
/*     */   {
/*     */     try
/*     */     {
/* 265 */       ServiceContext sc = ri.get_reply_service_context(15);
/* 266 */       Any msg = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
/*     */ 
/* 268 */       SASContextBody contextBody = SASContextBodyHelper.extract(msg);
/*     */ 
/* 275 */       if (traceEnabled) {
/* 276 */         log.trace("receive_exception: got SAS reply, type " + contextBody.discriminator());
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (BAD_PARAM e)
/*     */     {
/*     */     }
/*     */     catch (FormatMismatch e)
/*     */     {
/* 285 */       throw new MARSHAL("Could not parse SAS reply: " + e, 1245904897, CompletionStatus.COMPLETED_MAYBE);
/*     */     }
/*     */     catch (TypeMismatch e)
/*     */     {
/* 291 */       throw new MARSHAL("Could not parse SAS reply: " + e, 1245904897, CompletionStatus.COMPLETED_MAYBE);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void receive_other(ClientRequestInfo ri)
/*     */   {
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  85 */     absentIdentityToken.absent(true);
/*     */ 
/*  87 */     noAuthorizationToken = new AuthorizationElement[0];
/*     */ 
/*  89 */     log = Logger.getLogger(SASTargetInterceptor.class);
/*     */ 
/*  91 */     traceEnabled = log.isTraceEnabled();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.csiv2.SASClientInterceptor
 * JD-Core Version:    0.6.0
 */