/*     */ package org.jboss.iiop.csiv2;
/*     */ 
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.security.Principal;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ import org.omg.CORBA.Any;
/*     */ import org.omg.CORBA.BAD_PARAM;
/*     */ import org.omg.CORBA.CompletionStatus;
/*     */ import org.omg.CORBA.LocalObject;
/*     */ import org.omg.CORBA.MARSHAL;
/*     */ import org.omg.CORBA.NO_PERMISSION;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CSI.AuthorizationElement;
/*     */ import org.omg.CSI.EstablishContext;
/*     */ import org.omg.CSI.GSS_NT_ExportedNameHelper;
/*     */ import org.omg.CSI.IdentityToken;
/*     */ import org.omg.CSI.SASContextBody;
/*     */ import org.omg.CSI.SASContextBodyHelper;
/*     */ import org.omg.CSIIOP.AS_ContextSec;
/*     */ import org.omg.CSIIOP.CompoundSecMech;
/*     */ import org.omg.CSIIOP.CompoundSecMechList;
/*     */ import org.omg.CSIIOP.CompoundSecMechListHelper;
/*     */ import org.omg.CSIIOP.SAS_ContextSec;
/*     */ import org.omg.GSSUP.InitialContextToken;
/*     */ import org.omg.IOP.Codec;
/*     */ import org.omg.IOP.CodecPackage.FormatMismatch;
/*     */ import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
/*     */ import org.omg.IOP.CodecPackage.TypeMismatch;
/*     */ import org.omg.IOP.ServiceContext;
/*     */ import org.omg.IOP.TaggedComponent;
/*     */ import org.omg.PortableInterceptor.ClientRequestInfo;
/*     */ import org.omg.PortableInterceptor.ClientRequestInterceptor;
/*     */ 
/*     */ public class SASClientIdentityInterceptor extends LocalObject
/*     */   implements ClientRequestInterceptor
/*     */ {
/*  84 */   private static final Logger log = Logger.getLogger(SASClientIdentityInterceptor.class);
/*     */ 
/*  86 */   private static final boolean traceEnabled = log.isTraceEnabled();
/*     */   private static final int sasContextId = 15;
/*  98 */   private static final IdentityToken absentIdentityToken = new IdentityToken();
/*     */   private static final AuthorizationElement[] noAuthorizationToken;
/*     */   private static final byte[] noAuthenticationToken;
/*     */   private Codec codec;
/*     */   private static final String serverUsername = "j2ee";
/*     */   private static final String serverPassword = "j2ee";
/*     */ 
/*     */   public SASClientIdentityInterceptor(Codec codec)
/*     */   {
/* 118 */     this.codec = codec;
/*     */   }
/*     */ 
/*     */   public String name()
/*     */   {
/* 128 */     return "SASClientIdentityInterceptor";
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void send_request(ClientRequestInfo ri)
/*     */   {
/*     */     try
/*     */     {
/* 142 */       CompoundSecMech secMech = CSIv2Util.getMatchingSecurityMech(ri, this.codec, 1088, 0);
/*     */ 
/* 149 */       if (secMech == null) {
/* 150 */         return;
/*     */       }
/* 152 */       if (traceEnabled)
/*     */       {
/* 154 */         StringBuffer tmp = new StringBuffer();
/* 155 */         CSIv2Util.toString(secMech, tmp);
/* 156 */         log.trace(tmp);
/*     */       }
/*     */ 
/* 159 */       IdentityToken identityToken = absentIdentityToken;
/* 160 */       byte[] encodedAuthenticationToken = noAuthenticationToken;
/*     */ 
/* 162 */       if ((secMech.sas_context_mech.target_supports & 0x400) != 0)
/*     */       {
/* 166 */         Principal p = null;
/* 167 */         RunAsIdentity runAs = SecurityAssociation.peekRunAsIdentity();
/* 168 */         if (runAs != null)
/*     */         {
/* 171 */           p = runAs;
/*     */         }
/*     */         else
/*     */         {
/* 176 */           p = SecurityAssociation.getPrincipal();
/*     */         }
/*     */ 
/* 179 */         if (p != null)
/*     */         {
/* 182 */           String name = p.getName();
/* 183 */           if (name.indexOf('@') < 0)
/* 184 */             name = name + "@default";
/* 185 */           byte[] principalName = name.getBytes("UTF-8");
/*     */ 
/* 188 */           byte[] encodedName = CSIv2Util.encodeGssExportedName(principalName);
/*     */ 
/* 192 */           Any any = ORB.init().create_any();
/* 193 */           byte[] encapsulatedEncodedName = null;
/* 194 */           GSS_NT_ExportedNameHelper.insert(any, encodedName);
/*     */           try
/*     */           {
/* 197 */             encapsulatedEncodedName = this.codec.encode_value(any);
/*     */           }
/*     */           catch (InvalidTypeForEncoding e)
/*     */           {
/* 201 */             throw new RuntimeException("Unexpected exception: " + e);
/*     */           }
/*     */ 
/* 205 */           identityToken = new IdentityToken();
/* 206 */           identityToken.principal_name(encapsulatedEncodedName);
/*     */         }
/* 208 */         else if ((secMech.sas_context_mech.supported_identity_types & 0x1) != 0)
/*     */         {
/* 213 */           identityToken = new IdentityToken();
/* 214 */           identityToken.anonymous(true);
/*     */         }
/*     */       }
/*     */ 
/* 218 */       if ((secMech.as_context_mech.target_requires & 0x40) != 0)
/*     */       {
/* 223 */         byte[] encodedTargetName = secMech.as_context_mech.target_name;
/* 224 */         String name = "j2ee";
/* 225 */         if (name.indexOf('@') < 0)
/*     */         {
/* 227 */           byte[] decodedTargetName = CSIv2Util.decodeGssExportedName(encodedTargetName);
/*     */ 
/* 229 */           String targetName = new String(decodedTargetName, "UTF-8");
/* 230 */           name = name + "@" + targetName;
/*     */         }
/* 232 */         byte[] username = name.getBytes("UTF-8");
/*     */ 
/* 235 */         byte[] password = "j2ee".getBytes("UTF-8");
/*     */ 
/* 238 */         InitialContextToken authenticationToken = new InitialContextToken(username, password, encodedTargetName);
/*     */ 
/* 243 */         encodedAuthenticationToken = CSIv2Util.encodeInitialContextToken(authenticationToken, this.codec);
/*     */       }
/*     */ 
/* 247 */       if ((identityToken != absentIdentityToken) || (encodedAuthenticationToken != noAuthenticationToken))
/*     */       {
/* 252 */         EstablishContext message = new EstablishContext(0L, noAuthorizationToken, identityToken, encodedAuthenticationToken);
/*     */ 
/* 259 */         SASContextBody contextBody = new SASContextBody();
/* 260 */         contextBody.establish_msg(message);
/*     */ 
/* 263 */         Any any = ORB.init().create_any();
/* 264 */         SASContextBodyHelper.insert(any, contextBody);
/* 265 */         ServiceContext sc = new ServiceContext(15, this.codec.encode_value(any));
/*     */ 
/* 267 */         ri.add_request_service_context(sc, true);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (UnsupportedEncodingException e)
/*     */     {
/* 273 */       throw new MARSHAL("Unexpected exception: " + e);
/*     */     }
/*     */     catch (InvalidTypeForEncoding e)
/*     */     {
/* 277 */       throw new MARSHAL("Unexpected exception: " + e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void send_poll(ClientRequestInfo ri)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void receive_reply(ClientRequestInfo ri)
/*     */   {
/*     */     try
/*     */     {
/* 290 */       ServiceContext sc = ri.get_reply_service_context(15);
/* 291 */       Any msg = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
/*     */ 
/* 293 */       SASContextBody contextBody = SASContextBodyHelper.extract(msg);
/*     */ 
/* 300 */       if (traceEnabled) {
/* 301 */         log.trace("receive_reply: got SAS reply, type " + contextBody.discriminator());
/*     */       }
/*     */ 
/* 304 */       if (contextBody.discriminator() == 4)
/*     */       {
/* 307 */         log.warn("Unexpected ContextError in SAS reply");
/* 308 */         throw new NO_PERMISSION("Unexpected ContextError in SAS reply", 1245904897, CompletionStatus.COMPLETED_YES);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (BAD_PARAM e)
/*     */     {
/*     */     }
/*     */     catch (FormatMismatch e)
/*     */     {
/* 319 */       throw new MARSHAL("Could not parse SAS reply: " + e, 0, CompletionStatus.COMPLETED_YES);
/*     */     }
/*     */     catch (TypeMismatch e)
/*     */     {
/* 325 */       throw new MARSHAL("Could not parse SAS reply: " + e, 0, CompletionStatus.COMPLETED_YES);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void receive_exception(ClientRequestInfo ri)
/*     */   {
/*     */     try
/*     */     {
/* 335 */       ServiceContext sc = ri.get_reply_service_context(15);
/* 336 */       Any msg = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
/*     */ 
/* 338 */       SASContextBody contextBody = SASContextBodyHelper.extract(msg);
/*     */ 
/* 345 */       if (traceEnabled) {
/* 346 */         log.trace("receive_exceptpion: got SAS reply, type " + contextBody.discriminator());
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (BAD_PARAM e)
/*     */     {
/*     */     }
/*     */     catch (FormatMismatch e)
/*     */     {
/* 355 */       throw new MARSHAL("Could not parse SAS reply: " + e, 1245904897, CompletionStatus.COMPLETED_MAYBE);
/*     */     }
/*     */     catch (TypeMismatch e)
/*     */     {
/* 361 */       throw new MARSHAL("Could not parse SAS reply: " + e, 1245904897, CompletionStatus.COMPLETED_MAYBE);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void receive_other(ClientRequestInfo ri)
/*     */   {
/*     */   }
/*     */ 
/*     */   CompoundSecMech getSecurityMech(ClientRequestInfo ri)
/*     */   {
/* 374 */     CompoundSecMechList csmList = null;
/* 375 */     CompoundSecMech securityMech = null;
/*     */     try
/*     */     {
/* 378 */       TaggedComponent tc = ri.get_effective_component(33);
/*     */ 
/* 380 */       Any any = this.codec.decode_value(tc.component_data, CompoundSecMechListHelper.type());
/*     */ 
/* 383 */       csmList = CompoundSecMechListHelper.extract(any);
/*     */ 
/* 391 */       securityMech = csmList.mechanism_list[0];
/*     */     }
/*     */     catch (BAD_PARAM e)
/*     */     {
/*     */     }
/*     */     catch (TypeMismatch tm)
/*     */     {
/*     */     }
/*     */     catch (FormatMismatch tm)
/*     */     {
/*     */     }
/*     */ 
/* 405 */     return securityMech;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  99 */     absentIdentityToken.absent(true);
/*     */ 
/* 101 */     noAuthorizationToken = new AuthorizationElement[0];
/* 102 */     noAuthenticationToken = new byte[0];
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.csiv2.SASClientIdentityInterceptor
 * JD-Core Version:    0.6.0
 */