/*     */ package org.jboss.iiop.csiv2;
/*     */ 
/*     */ import B;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.UnknownHostException;
/*     */ import org.ietf.jgss.GSSException;
/*     */ import org.ietf.jgss.Oid;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.IorSecurityConfigMetaData;
/*     */ import org.jboss.metadata.IorSecurityConfigMetaData.AsContext;
/*     */ import org.jboss.metadata.IorSecurityConfigMetaData.SasContext;
/*     */ import org.jboss.metadata.IorSecurityConfigMetaData.TransportConfig;
/*     */ import org.omg.CORBA.Any;
/*     */ import org.omg.CORBA.BAD_PARAM;
/*     */ import org.omg.CORBA.MARSHAL;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CSIIOP.AS_ContextSec;
/*     */ import org.omg.CSIIOP.CompoundSecMech;
/*     */ import org.omg.CSIIOP.CompoundSecMechList;
/*     */ import org.omg.CSIIOP.CompoundSecMechListHelper;
/*     */ import org.omg.CSIIOP.SAS_ContextSec;
/*     */ import org.omg.CSIIOP.ServiceConfiguration;
/*     */ import org.omg.CSIIOP.TLS_SEC_TRANS;
/*     */ import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
/*     */ import org.omg.CSIIOP.TransportAddress;
/*     */ import org.omg.GSSUP.InitialContextToken;
/*     */ import org.omg.GSSUP.InitialContextTokenHelper;
/*     */ import org.omg.IOP.Codec;
/*     */ import org.omg.IOP.CodecPackage.FormatMismatch;
/*     */ import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
/*     */ import org.omg.IOP.CodecPackage.TypeMismatch;
/*     */ import org.omg.IOP.TaggedComponent;
/*     */ import org.omg.PortableInterceptor.ClientRequestInfo;
/*     */ import org.omg.SSLIOP.SSL;
/*     */ import org.omg.SSLIOP.SSLHelper;
/*     */ 
/*     */ public final class CSIv2Util
/*     */ {
/*  82 */   private static final Logger log = Logger.getLogger(CSIv2Util.class);
/*     */ 
/*  85 */   private static final byte[] gssUpMechOidArray = createGSSUPMechOID();
/*     */ 
/*     */   public static TaggedComponent createCopy(TaggedComponent tc)
/*     */   {
/*  97 */     TaggedComponent copy = null;
/*     */ 
/*  99 */     if (tc != null)
/*     */     {
/* 101 */       byte[] buf = new byte[tc.component_data.length];
/* 102 */       System.arraycopy(tc.component_data, 0, buf, 0, tc.component_data.length);
/*     */ 
/* 104 */       copy = new TaggedComponent(tc.tag, buf);
/*     */     }
/*     */ 
/* 107 */     return copy;
/*     */   }
/*     */ 
/*     */   public static TaggedComponent createSSLTaggedComponent(IorSecurityConfigMetaData metadata, Codec codec, int sslPort, ORB orb)
/*     */   {
/* 123 */     if (metadata == null)
/*     */     {
/* 125 */       log.debug("createSSLTaggedComponent() called with null metadata");
/* 126 */       return null;
/*     */     }
/*     */ 
/* 129 */     TaggedComponent tc = null;
/*     */     try
/*     */     {
/* 133 */       int supports = createTargetSupports(metadata.getTransportConfig());
/* 134 */       int requires = createTargetRequires(metadata.getTransportConfig());
/* 135 */       SSL ssl = new SSL((short)supports, (short)requires, (short)sslPort);
/* 136 */       Any any = orb.create_any();
/* 137 */       SSLHelper.insert(any, ssl);
/* 138 */       byte[] componentData = codec.encode_value(any);
/* 139 */       tc = new TaggedComponent(20, componentData);
/*     */     }
/*     */     catch (InvalidTypeForEncoding e)
/*     */     {
/* 143 */       log.warn("Caught unexcepted exception while encoding SSL component", e);
/* 144 */       throw new RuntimeException(e);
/*     */     }
/* 146 */     return tc;
/*     */   }
/*     */ 
/*     */   public static TaggedComponent createSecurityTaggedComponent(IorSecurityConfigMetaData metadata, Codec codec, int sslPort, ORB orb)
/*     */   {
/* 164 */     if (metadata == null)
/*     */     {
/* 166 */       log.debug("createSecurityTaggedComponent() called with null metadata");
/* 167 */       return null;
/*     */     }
/*     */ 
/* 170 */     TaggedComponent tc = null;
/*     */ 
/* 173 */     CompoundSecMech[] mechList = createCompoundSecMechanisms(metadata, codec, sslPort, orb);
/*     */ 
/* 180 */     CompoundSecMechList csmList = new CompoundSecMechList(false, mechList);
/*     */     try
/*     */     {
/* 185 */       Any any = orb.create_any();
/*     */ 
/* 187 */       CompoundSecMechListHelper.insert(any, csmList);
/* 188 */       byte[] b = codec.encode_value(any);
/*     */ 
/* 190 */       tc = new TaggedComponent(33, b);
/*     */     }
/*     */     catch (InvalidTypeForEncoding e)
/*     */     {
/* 194 */       log.warn("Caught unexcepted exception while encoding CompoundSecMechList", e);
/* 195 */       throw new RuntimeException(e);
/*     */     }
/*     */ 
/* 198 */     return tc;
/*     */   }
/*     */ 
/*     */   public static CompoundSecMech[] createCompoundSecMechanisms(IorSecurityConfigMetaData metadata, Codec codec, int sslPort, ORB orb)
/*     */   {
/* 213 */     CompoundSecMech[] csmList = new CompoundSecMech[1];
/*     */ 
/* 221 */     TaggedComponent transport_mech = createTransportMech(metadata.getTransportConfig(), codec, sslPort, orb);
/*     */ 
/* 226 */     AS_ContextSec asContext = createAuthenticationServiceContext(metadata);
/*     */ 
/* 229 */     SAS_ContextSec sasContext = createSecureAttributeServiceContext(metadata);
/*     */ 
/* 233 */     int target_requires = createTargetRequires(metadata.getTransportConfig()) | asContext.target_requires | sasContext.target_requires;
/*     */ 
/* 239 */     CompoundSecMech csm = new CompoundSecMech((short)target_requires, transport_mech, asContext, sasContext);
/*     */ 
/* 244 */     csmList[0] = csm;
/*     */ 
/* 246 */     return csmList;
/*     */   }
/*     */ 
/*     */   public static SAS_ContextSec createSecureAttributeServiceContext(IorSecurityConfigMetaData metadata)
/*     */   {
/* 257 */     SAS_ContextSec context = null;
/*     */ 
/* 262 */     int support = 0;
/* 263 */     int require = 0;
/* 264 */     ServiceConfiguration[] privilAuth = new ServiceConfiguration[0];
/* 265 */     byte[][] supNamMechs = new byte[0][];
/* 266 */     int supIdenTypes = 0;
/*     */ 
/* 269 */     IorSecurityConfigMetaData.SasContext sasMeta = metadata.getSasContext();
/*     */ 
/* 273 */     if ((sasMeta == null) || (!sasMeta.isCallerPropagationSupported()))
/*     */     {
/* 275 */       context = new SAS_ContextSec((short)support, (short)require, privilAuth, supNamMechs, supIdenTypes);
/*     */     }
/*     */     else
/*     */     {
/* 283 */       support = 1024;
/*     */ 
/* 286 */       byte[] upMech = createGSSUPMechOID();
/* 287 */       supNamMechs = new byte[1][upMech.length];
/* 288 */       System.arraycopy(upMech, 0, supNamMechs[0], 0, upMech.length);
/*     */ 
/* 292 */       supIdenTypes = 15;
/*     */ 
/* 297 */       context = new SAS_ContextSec((short)support, (short)require, privilAuth, supNamMechs, supIdenTypes);
/*     */     }
/*     */ 
/* 304 */     return context;
/*     */   }
/*     */ 
/*     */   public static AS_ContextSec createAuthenticationServiceContext(IorSecurityConfigMetaData metadata)
/*     */   {
/* 315 */     AS_ContextSec context = null;
/*     */ 
/* 318 */     int support = 0;
/* 319 */     int require = 0;
/* 320 */     byte[] clientAuthMech = new byte[0];
/* 321 */     byte[] targetName = new byte[0];
/*     */ 
/* 324 */     IorSecurityConfigMetaData.AsContext asMeta = metadata.getAsContext();
/*     */ 
/* 328 */     if ((asMeta == null) || (asMeta.getAuthMethod().equals("NONE")))
/*     */     {
/* 331 */       context = new AS_ContextSec((short)support, (short)require, clientAuthMech, targetName);
/*     */     }
/*     */     else
/*     */     {
/* 339 */       support = 64;
/*     */ 
/* 342 */       if (asMeta.isRequired()) {
/* 343 */         require = 64;
/*     */       }
/*     */ 
/* 346 */       clientAuthMech = createGSSUPMechOID();
/*     */ 
/* 351 */       String realm = asMeta.getRealm();
/* 352 */       targetName = createGSSExportedName(clientAuthMech, realm.getBytes());
/*     */ 
/* 355 */       context = new AS_ContextSec((short)support, (short)require, clientAuthMech, targetName);
/*     */     }
/*     */ 
/* 361 */     return context;
/*     */   }
/*     */ 
/*     */   public static TaggedComponent createTransportMech(IorSecurityConfigMetaData.TransportConfig tconfig, Codec codec, int sslPort, ORB orb)
/*     */   {
/* 386 */     TaggedComponent tc = null;
/*     */ 
/* 389 */     int support = 0;
/* 390 */     int require = 0;
/*     */ 
/* 392 */     if (tconfig != null)
/*     */     {
/* 394 */       require = createTargetRequires(tconfig);
/* 395 */       support = createTargetSupports(tconfig);
/*     */     }
/*     */ 
/* 398 */     if ((tconfig == null) || (support == 0) || (sslPort < 0))
/*     */     {
/* 401 */       tc = new TaggedComponent(34, new byte[0]);
/*     */     }
/*     */     else
/*     */     {
/*     */       String host;
/*     */       try
/*     */       {
/* 409 */         host = InetAddress.getLocalHost().getHostAddress();
/*     */       }
/*     */       catch (UnknownHostException e)
/*     */       {
/* 413 */         host = "127.0.0.1";
/*     */       }
/*     */ 
/* 417 */       TransportAddress[] taList = createTransportAddress(host, sslPort);
/*     */ 
/* 419 */       TLS_SEC_TRANS tst = new TLS_SEC_TRANS((short)support, (short)require, taList);
/*     */       try
/*     */       {
/* 426 */         Any any = orb.create_any();
/*     */ 
/* 428 */         TLS_SEC_TRANSHelper.insert(any, tst);
/* 429 */         byte[] b = codec.encode_value(any);
/*     */ 
/* 431 */         tc = new TaggedComponent(36, b);
/*     */       }
/*     */       catch (InvalidTypeForEncoding e)
/*     */       {
/* 435 */         log.warn("Caught unexcepted exception while encoding TLS_SEC_TRANS", e);
/* 436 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/*     */ 
/* 440 */     return tc;
/*     */   }
/*     */ 
/*     */   public static TransportAddress[] createTransportAddress(String host, int port)
/*     */   {
/* 451 */     short short_port = port > 32767 ? (short)(port - 65536) : (short)port;
/*     */ 
/* 453 */     TransportAddress ta = new TransportAddress(host, short_port);
/* 454 */     TransportAddress[] taList = new TransportAddress[1];
/* 455 */     taList[0] = ta;
/*     */ 
/* 457 */     return taList;
/*     */   }
/*     */ 
/*     */   public static int createTargetRequires(IorSecurityConfigMetaData.TransportConfig tc)
/*     */   {
/* 465 */     int requires = 0;
/*     */ 
/* 467 */     if (tc != null)
/*     */     {
/* 469 */       if (tc.getIntegrity().equals("REQUIRED")) {
/* 470 */         requires |= 2;
/*     */       }
/* 472 */       if (tc.getConfidentiality().equals("REQUIRED")) {
/* 473 */         requires |= 4;
/*     */       }
/* 475 */       if (tc.getDetectMisordering().equalsIgnoreCase("REQUIRED")) {
/* 476 */         requires |= 16;
/*     */       }
/* 478 */       if (tc.getDetectReplay().equalsIgnoreCase("REQUIRED")) {
/* 479 */         requires |= 8;
/*     */       }
/*     */ 
/* 483 */       if (tc.getEstablishTrustInClient().equals("REQUIRED")) {
/* 484 */         requires |= 64;
/*     */       }
/*     */     }
/* 487 */     return requires;
/*     */   }
/*     */ 
/*     */   public static int createTargetSupports(IorSecurityConfigMetaData.TransportConfig tc)
/*     */   {
/* 495 */     int supports = 0;
/*     */ 
/* 497 */     if (tc != null)
/*     */     {
/* 499 */       if (!tc.getIntegrity().equals("NONE")) {
/* 500 */         supports |= 2;
/*     */       }
/* 502 */       if (!tc.getConfidentiality().equals("NONE")) {
/* 503 */         supports |= 4;
/*     */       }
/* 505 */       if (!tc.getDetectMisordering().equalsIgnoreCase("NONE")) {
/* 506 */         supports |= 16;
/*     */       }
/* 508 */       if (!tc.getDetectReplay().equalsIgnoreCase("NONE")) {
/* 509 */         supports |= 8;
/*     */       }
/* 511 */       if (!tc.getEstablishTrustInTarget().equals("NONE")) {
/* 512 */         supports |= 32;
/*     */       }
/* 514 */       if (!tc.getEstablishTrustInClient().equals("NONE")) {
/* 515 */         supports |= 64;
/*     */       }
/*     */     }
/* 518 */     return supports;
/*     */   }
/*     */ 
/*     */   public static byte[] createGSSUPMechOID()
/*     */   {
/* 530 */     byte[] retval = new byte[0];
/*     */     try
/*     */     {
/* 533 */       Oid oid = new Oid("oid:2.23.130.1.1.1".substring(4));
/* 534 */       retval = oid.getDER();
/*     */     }
/*     */     catch (GSSException e)
/*     */     {
/* 538 */       log.warn("Caught exception while encoding GSSUPMechOID", e);
/*     */     }
/* 540 */     return retval;
/*     */   }
/*     */ 
/*     */   public static byte[] gssUpMechOid()
/*     */   {
/* 548 */     return (byte[])(byte[])gssUpMechOidArray.clone();
/*     */   }
/*     */ 
/*     */   public static byte[] createGSSExportedName(byte[] oid, byte[] name)
/*     */   {
/* 596 */     int olen = oid.length;
/* 597 */     int nlen = name.length;
/*     */ 
/* 600 */     int size = 4 + olen + 4 + nlen;
/*     */ 
/* 603 */     byte[] buf = new byte[size];
/*     */ 
/* 605 */     int i = 0;
/*     */ 
/* 608 */     buf[(i++)] = 4;
/* 609 */     buf[(i++)] = 1;
/*     */ 
/* 612 */     buf[(i++)] = (byte)(olen & 0xFF00);
/* 613 */     buf[(i++)] = (byte)(olen & 0xFF);
/*     */ 
/* 616 */     System.arraycopy(oid, 0, buf, i, olen);
/* 617 */     i += olen;
/*     */ 
/* 620 */     buf[(i++)] = (byte)(nlen & 0xFF000000);
/* 621 */     buf[(i++)] = (byte)(nlen & 0xFF0000);
/* 622 */     buf[(i++)] = (byte)(nlen & 0xFF00);
/* 623 */     buf[(i++)] = (byte)(nlen & 0xFF);
/*     */ 
/* 626 */     System.arraycopy(name, 0, buf, i, nlen);
/*     */ 
/* 629 */     return buf;
/*     */   }
/*     */ 
/*     */   public static byte[] encodeInitialContextToken(InitialContextToken authToken, Codec codec)
/*     */   {
/* 644 */     byte[] out = null;
/* 645 */     Any any = ORB.init().create_any();
/* 646 */     InitialContextTokenHelper.insert(any, authToken);
/*     */     try
/*     */     {
/* 649 */       out = codec.encode_value(any);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 654 */       return new byte[0];
/*     */     }
/*     */ 
/* 657 */     int length = out.length + gssUpMechOidArray.length;
/*     */     int n;
/*     */     int n;
/* 660 */     if (length < 128) {
/* 661 */       n = 0;
/*     */     }
/*     */     else
/*     */     {
/*     */       int n;
/* 662 */       if (length < 256) {
/* 663 */         n = 1;
/*     */       }
/*     */       else
/*     */       {
/*     */         int n;
/* 664 */         if (length < 65536) {
/* 665 */           n = 2;
/*     */         }
/*     */         else
/*     */         {
/*     */           int n;
/* 666 */           if (length < 16777216)
/* 667 */             n = 3;
/*     */           else
/* 669 */             n = 4; 
/*     */         }
/*     */       }
/*     */     }
/* 671 */     byte[] encodedToken = new byte[2 + n + length];
/* 672 */     encodedToken[0] = 96;
/*     */ 
/* 674 */     if (n == 0) {
/* 675 */       encodedToken[1] = (byte)length;
/*     */     }
/*     */     else {
/* 678 */       encodedToken[1] = (byte)(n | 0x80);
/* 679 */       switch (n)
/*     */       {
/*     */       case 1:
/* 682 */         encodedToken[2] = (byte)length;
/* 683 */         break;
/*     */       case 2:
/* 685 */         encodedToken[2] = (byte)(length >> 8);
/* 686 */         encodedToken[3] = (byte)length;
/* 687 */         break;
/*     */       case 3:
/* 689 */         encodedToken[2] = (byte)(length >> 16);
/* 690 */         encodedToken[3] = (byte)(length >> 8);
/* 691 */         encodedToken[4] = (byte)length;
/* 692 */         break;
/*     */       default:
/* 694 */         encodedToken[2] = (byte)(length >> 24);
/* 695 */         encodedToken[3] = (byte)(length >> 16);
/* 696 */         encodedToken[4] = (byte)(length >> 8);
/* 697 */         encodedToken[5] = (byte)length;
/*     */       }
/*     */     }
/* 700 */     System.arraycopy(gssUpMechOidArray, 0, encodedToken, 2 + n, gssUpMechOidArray.length);
/*     */ 
/* 703 */     System.arraycopy(out, 0, encodedToken, 2 + n + gssUpMechOidArray.length, out.length);
/*     */ 
/* 707 */     return encodedToken;
/*     */   }
/*     */ 
/*     */   public static InitialContextToken decodeInitialContextToken(byte[] encodedToken, Codec codec)
/*     */   {
/* 719 */     if (encodedToken[0] != 96) {
/* 720 */       return null;
/*     */     }
/* 722 */     int encodedLength = 0;
/* 723 */     int n = 0;
/*     */ 
/* 725 */     if (encodedToken[1] >= 0) {
/* 726 */       encodedLength = encodedToken[1];
/*     */     }
/*     */     else {
/* 729 */       n = encodedToken[1] & 0x7F;
/* 730 */       for (int i = 1; i <= n; i++) {
/* 731 */         encodedLength += ((encodedToken[(1 + i)] & 0xFF) << (n - i) * 8);
/*     */       }
/*     */     }
/* 734 */     int length = encodedLength - gssUpMechOidArray.length;
/* 735 */     byte[] encodedInitialContextToken = new byte[length];
/*     */ 
/* 737 */     System.arraycopy(encodedToken, 2 + n + gssUpMechOidArray.length, encodedInitialContextToken, 0, length);
/*     */ 
/* 740 */     Any any = null;
/*     */     try
/*     */     {
/* 743 */       any = codec.decode_value(encodedInitialContextToken, InitialContextTokenHelper.type());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 748 */       return null;
/*     */     }
/*     */ 
/* 751 */     InitialContextToken contextToken = InitialContextTokenHelper.extract(any);
/*     */ 
/* 754 */     return contextToken;
/*     */   }
/*     */ 
/*     */   public static byte[] encodeGssExportedName(byte[] name)
/*     */   {
/* 764 */     return createGSSExportedName(gssUpMechOidArray, name);
/*     */   }
/*     */ 
/*     */   public static byte[] decodeGssExportedName(byte[] encodedName)
/*     */   {
/* 774 */     if ((encodedName[0] != 4) || (encodedName[1] != 1)) {
/* 775 */       return null;
/*     */     }
/* 777 */     int mechOidLength = (encodedName[2] & 0xFF) << 8;
/* 778 */     mechOidLength += (encodedName[3] & 0xFF);
/*     */ 
/* 780 */     byte[] oidArray = new byte[mechOidLength];
/* 781 */     System.arraycopy(encodedName, 4, oidArray, 0, mechOidLength);
/*     */ 
/* 785 */     for (int i = 0; i < mechOidLength; i++)
/*     */     {
/* 787 */       if (gssUpMechOidArray[i] != oidArray[i]) {
/* 788 */         return null;
/*     */       }
/*     */     }
/* 791 */     int offset = 4 + mechOidLength;
/* 792 */     int nameLength = (encodedName[offset] & 0xFF) << 24;
/* 793 */     offset++; nameLength += ((encodedName[offset] & 0xFF) << 16);
/* 794 */     offset++; nameLength += ((encodedName[offset] & 0xFF) << 8);
/* 795 */     offset++; nameLength += (encodedName[offset] & 0xFF);
/*     */ 
/* 797 */     byte[] name = new byte[nameLength];
/* 798 */     offset++; System.arraycopy(encodedName, offset, name, 0, nameLength);
/*     */ 
/* 802 */     return name;
/*     */   }
/*     */ 
/*     */   public static CompoundSecMech getMatchingSecurityMech(ClientRequestInfo ri, Codec codec, short clientSupports, short clientRequires)
/*     */   {
/* 830 */     CompoundSecMechList csmList = null;
/*     */     try
/*     */     {
/* 833 */       TaggedComponent tc = ri.get_effective_component(33);
/*     */ 
/* 836 */       Any any = codec.decode_value(tc.component_data, CompoundSecMechListHelper.type());
/*     */ 
/* 839 */       csmList = CompoundSecMechListHelper.extract(any);
/*     */ 
/* 842 */       for (int i = 0; i < csmList.mechanism_list.length; i++)
/*     */       {
/* 844 */         CompoundSecMech securityMech = csmList.mechanism_list[i];
/* 845 */         AS_ContextSec authConfig = securityMech.as_context_mech;
/*     */ 
/* 847 */         if ((0x20 & (clientRequires ^ authConfig.target_supports) & (authConfig.target_supports ^ 0xFFFFFFFF)) != 0)
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/* 856 */         if ((0x40 & (authConfig.target_requires ^ clientSupports) & (clientSupports ^ 0xFFFFFFFF)) != 0)
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/* 865 */         SAS_ContextSec identityConfig = securityMech.sas_context_mech;
/*     */ 
/* 867 */         if ((0x400 & (identityConfig.target_requires ^ clientSupports) & (clientSupports ^ 0xFFFFFFFF)) == 0)
/*     */         {
/* 877 */           return securityMech;
/*     */         }
/*     */       }
/* 880 */       return null;
/*     */     }
/*     */     catch (BAD_PARAM e)
/*     */     {
/* 885 */       return null;
/*     */     }
/*     */     catch (TypeMismatch e)
/*     */     {
/* 890 */       throw new MARSHAL("Unexpected exception: " + e);
/*     */     }
/*     */     catch (FormatMismatch e)
/*     */     {
/*     */     }
/* 895 */     throw new MARSHAL("Unexpected exception: " + e);
/*     */   }
/*     */ 
/*     */   public static void toString(CompoundSecMech securityMech, StringBuffer buffer)
/*     */   {
/* 905 */     AS_ContextSec asMech = securityMech != null ? securityMech.as_context_mech : null;
/* 906 */     SAS_ContextSec sasMech = securityMech != null ? securityMech.sas_context_mech : null;
/* 907 */     if (securityMech != null)
/*     */     {
/* 909 */       buffer.append("CompoundSecMech[");
/* 910 */       buffer.append("target_requires: ");
/* 911 */       buffer.append(securityMech.target_requires);
/* 912 */       if (asMech != null)
/*     */       {
/* 914 */         buffer.append("AS_ContextSec[");
/*     */ 
/* 916 */         buffer.append("client_authentication_mech: ");
/*     */         try
/*     */         {
/* 919 */           buffer.append(new String(asMech.client_authentication_mech, "UTF-8"));
/*     */         }
/*     */         catch (UnsupportedEncodingException e)
/*     */         {
/* 923 */           buffer.append(e.getMessage());
/*     */         }
/* 925 */         buffer.append(", target_name: ");
/*     */         try
/*     */         {
/* 928 */           buffer.append(new String(asMech.target_name, "UTF-8"));
/*     */         }
/*     */         catch (UnsupportedEncodingException e)
/*     */         {
/* 932 */           buffer.append(e.getMessage());
/*     */         }
/* 934 */         buffer.append(", target_requires: ");
/* 935 */         buffer.append(asMech.target_requires);
/* 936 */         buffer.append(", target_supports: ");
/* 937 */         buffer.append(asMech.target_supports);
/* 938 */         buffer.append("]");
/*     */       }
/* 940 */       if (sasMech != null)
/*     */       {
/* 942 */         buffer.append("SAS_ContextSec[");
/* 943 */         buffer.append("supported_identity_types: ");
/* 944 */         buffer.append(sasMech.supported_identity_types);
/* 945 */         buffer.append(", target_requires: ");
/* 946 */         buffer.append(sasMech.target_requires);
/* 947 */         buffer.append(", target_supports: ");
/* 948 */         buffer.append(sasMech.target_supports);
/* 949 */         buffer.append("]");
/*     */       }
/* 951 */       buffer.append("]");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.csiv2.CSIv2Util
 * JD-Core Version:    0.6.0
 */