/*     */ package org.jboss.iiop.csiv2;
/*     */ 
/*     */ import org.jboss.iiop.CorbaORBService;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.IorSecurityConfigMetaData;
/*     */ import org.omg.CORBA.LocalObject;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CORBA.Policy;
/*     */ import org.omg.IOP.Codec;
/*     */ import org.omg.IOP.TaggedComponent;
/*     */ 
/*     */ public class CSIv2Policy extends LocalObject
/*     */   implements Policy
/*     */ {
/*  47 */   private static final Logger log = Logger.getLogger(CSIv2Policy.class);
/*     */   public static final int TYPE = -2023406815;
/*     */   private TaggedComponent sslTaggedComponent;
/*     */   private TaggedComponent secTaggedComponent;
/*     */ 
/*     */   public CSIv2Policy(TaggedComponent sslTaggedComponent, TaggedComponent secTaggedComponent)
/*     */   {
/*  60 */     this.sslTaggedComponent = sslTaggedComponent;
/*  61 */     this.secTaggedComponent = secTaggedComponent;
/*     */   }
/*     */ 
/*     */   public CSIv2Policy(IorSecurityConfigMetaData metadata, Codec codec)
/*     */   {
/*  66 */     log.debug(metadata);
/*     */     try
/*     */     {
/*  72 */       ORB orb = ORB.init();
/*     */ 
/*  74 */       this.sslTaggedComponent = CSIv2Util.createSSLTaggedComponent(metadata, codec, CorbaORBService.getTheActualSSLPort(), orb);
/*     */ 
/*  81 */       this.secTaggedComponent = CSIv2Util.createSecurityTaggedComponent(metadata, codec, CorbaORBService.getTheActualSSLPort(), orb);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  89 */       throw new RuntimeException("Unexpected exception " + e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public TaggedComponent getSSLTaggedComponent()
/*     */   {
/*  98 */     return CSIv2Util.createCopy(this.sslTaggedComponent);
/*     */   }
/*     */ 
/*     */   public TaggedComponent getSecurityTaggedComponent()
/*     */   {
/* 106 */     return CSIv2Util.createCopy(this.secTaggedComponent);
/*     */   }
/*     */ 
/*     */   public Policy copy()
/*     */   {
/* 115 */     return new CSIv2Policy(getSSLTaggedComponent(), getSecurityTaggedComponent());
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 124 */     this.sslTaggedComponent = null;
/* 125 */     this.secTaggedComponent = null;
/*     */   }
/*     */ 
/*     */   public int policy_type()
/*     */   {
/* 134 */     return -2023406815;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 139 */     return "CSIv2Policy[" + this.sslTaggedComponent + ", " + this.secTaggedComponent + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.csiv2.CSIv2Policy
 * JD-Core Version:    0.6.0
 */