/*     */ package org.jboss.iiop.csiv2;
/*     */ 
/*     */ import org.jboss.iiop.CorbaORBService;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.IorSecurityConfigMetaData;
/*     */ import org.omg.CORBA.Any;
/*     */ import org.omg.CORBA.BAD_PARAM;
/*     */ import org.omg.CORBA.LocalObject;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.IOP.Codec;
/*     */ import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
/*     */ import org.omg.IOP.TaggedComponent;
/*     */ import org.omg.PortableInterceptor.IORInfo;
/*     */ import org.omg.PortableInterceptor.IORInterceptor;
/*     */ import org.omg.SSLIOP.SSL;
/*     */ import org.omg.SSLIOP.SSLHelper;
/*     */ 
/*     */ public class CSIv2IORInterceptor extends LocalObject
/*     */   implements IORInterceptor
/*     */ {
/*  58 */   private static final Logger log = Logger.getLogger(CSIv2IORInterceptor.class);
/*     */   private static final int MIN_SSL_OPTIONS = 26;
/*     */   private TaggedComponent defaultSSLComponent;
/*     */   private TaggedComponent defaultCSIComponent;
/*     */ 
/*     */   public CSIv2IORInterceptor(Codec codec)
/*     */   {
/*  72 */     int sslPort = CorbaORBService.getTheActualSSLPort();
/*     */     try
/*     */     {
/*  76 */       SSL ssl = new SSL(26, 0, (short)sslPort);
/*     */ 
/*  79 */       ORB orb = ORB.init();
/*  80 */       Any any = orb.create_any();
/*  81 */       SSLHelper.insert(any, ssl);
/*  82 */       byte[] componentData = codec.encode_value(any);
/*  83 */       this.defaultSSLComponent = new TaggedComponent(20, componentData);
/*     */ 
/*  86 */       IorSecurityConfigMetaData metadata = new IorSecurityConfigMetaData();
/*  87 */       this.defaultCSIComponent = CSIv2Util.createSecurityTaggedComponent(metadata, codec, sslPort, orb);
/*     */     }
/*     */     catch (InvalidTypeForEncoding e)
/*     */     {
/*  92 */       log.warn("Caught unexcepted exception while encoding SSL component", e);
/*  93 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String name()
/*     */   {
/* 101 */     return CSIv2IORInterceptor.class.getName();
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void establish_components(IORInfo info)
/*     */   {
/* 112 */     CSIv2Policy csiv2Policy = null;
/*     */     try
/*     */     {
/* 116 */       csiv2Policy = (CSIv2Policy)info.get_effective_policy(-2023406815);
/*     */     }
/*     */     catch (BAD_PARAM e)
/*     */     {
/* 120 */       log.debug("No CSIv2Policy");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 124 */       log.debug("Error fetching CSIv2Policy", e);
/*     */     }
/*     */ 
/* 127 */     if (csiv2Policy != null)
/*     */     {
/* 131 */       TaggedComponent sslComponent = csiv2Policy.getSSLTaggedComponent();
/*     */ 
/* 133 */       if ((sslComponent != null) && (CorbaORBService.getSSLComponentsEnabledFlag() == true))
/*     */       {
/* 136 */         info.add_ior_component_to_profile(sslComponent, 0);
/*     */       }
/*     */ 
/* 139 */       TaggedComponent csiv2Component = csiv2Policy.getSecurityTaggedComponent();
/*     */ 
/* 141 */       if (csiv2Component != null)
/*     */       {
/* 143 */         info.add_ior_component_to_profile(csiv2Component, 0);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 149 */       if ((this.defaultSSLComponent != null) && (CorbaORBService.getSSLComponentsEnabledFlag() == true))
/*     */       {
/* 154 */         info.add_ior_component_to_profile(this.defaultSSLComponent, 0);
/*     */       }
/*     */ 
/* 157 */       if (this.defaultCSIComponent != null)
/*     */       {
/* 161 */         info.add_ior_component_to_profile(this.defaultCSIComponent, 0);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.csiv2.CSIv2IORInterceptor
 * JD-Core Version:    0.6.0
 */