/*    */ package org.jboss.iiop;
/*    */ 
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.proxy.compiler.IIOPStubCompiler;
/*    */ 
/*    */ public class StubClassLoader extends ClassLoader
/*    */ {
/* 41 */   private static final Logger logger = Logger.getLogger(StubClassLoader.class);
/*    */ 
/*    */   public StubClassLoader(ClassLoader parent)
/*    */   {
/* 48 */     super(parent);
/*    */   }
/*    */ 
/*    */   protected Class findClass(String name)
/*    */     throws ClassNotFoundException
/*    */   {
/* 56 */     logger.debug("findClass(" + name + ") called");
/* 57 */     if (name.endsWith("_Stub")) {
/* 58 */       int start = name.lastIndexOf('.') + 1;
/* 59 */       if (name.charAt(start) == '_') {
/* 60 */         String pkg = name.substring(0, start);
/* 61 */         String interfaceName = pkg + name.substring(start + 1, name.length() - 5);
/*    */ 
/* 63 */         logger.debug("interface name " + interfaceName);
/* 64 */         Class intf = loadClass(interfaceName);
/* 65 */         logger.debug("loaded class " + interfaceName);
/*    */         try
/*    */         {
/* 68 */           byte[] code = IIOPStubCompiler.compile(intf, name);
/*    */ 
/* 70 */           logger.debug("compiled stub class for " + interfaceName);
/* 71 */           Class clz = defineClass(name, code, 0, code.length);
/* 72 */           logger.debug("defined stub class for " + interfaceName);
/* 73 */           resolveClass(clz);
/* 74 */           logger.debug("resolved stub class for " + interfaceName);
/* 75 */           return clz;
/*    */         }
/*    */         catch (RuntimeException e) {
/* 78 */           logger.debug("Exception generating IIOP stub " + name, e);
/* 79 */           throw e;
/*    */         }
/*    */       }
/*    */     }
/* 83 */     throw new ClassNotFoundException(name);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.StubClassLoader
 * JD-Core Version:    0.6.0
 */