/*     */ package org.jboss.iiop;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.Properties;
/*     */ import javax.ejb.spi.HandleDelegate;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ import org.jboss.iiop.naming.ORBInitialContextFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.proxy.ejb.handle.HandleDelegateImpl;
/*     */ import org.jboss.security.SecurityDomain;
/*     */ import org.jboss.system.ORBSingleton;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.system.server.ServerConfigUtil;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CORBA.Policy;
/*     */ import org.omg.PortableServer.IdAssignmentPolicy;
/*     */ import org.omg.PortableServer.IdAssignmentPolicyValue;
/*     */ import org.omg.PortableServer.IdUniquenessPolicyValue;
/*     */ import org.omg.PortableServer.LifespanPolicy;
/*     */ import org.omg.PortableServer.LifespanPolicyValue;
/*     */ import org.omg.PortableServer.POA;
/*     */ import org.omg.PortableServer.POAHelper;
/*     */ import org.omg.PortableServer.POAManager;
/*     */ import org.omg.PortableServer.RequestProcessingPolicyValue;
/*     */ import org.omg.PortableServer.ServantRetentionPolicyValue;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class CorbaORBService extends ServiceMBeanSupport
/*     */   implements CorbaORBServiceMBean, ObjectFactory
/*     */ {
/*  70 */   public static String ORB_NAME = "JBossCorbaORB";
/*  71 */   public static String POA_NAME = "JBossCorbaPOA";
/*  72 */   public static String IR_POA_NAME = "JBossCorbaInterfaceRepositoryPOA";
/*  73 */   public static String SSL_DOMAIN = "JBossCorbaSSLDomain";
/*     */ 
/*  77 */   private String orbClass = null;
/*  78 */   private String orbSingletonClass = null;
/*  79 */   private String orbSingletonDelegate = null;
/*  80 */   private String orbPropertiesFileName = "orb-properties-file-not-defined";
/*  81 */   private Element portableInterceptorInitializers = null;
/*  82 */   private int port = 0;
/*  83 */   private int sslPort = 0;
/*  84 */   private String sslDomain = null;
/*  85 */   private boolean sunJDK14IsLocalBugFix = false;
/*     */   private static ORB orb;
/*     */   private static POA poa;
/*     */   private static POA otsPoa;
/*     */   private static POA otsResourcePoa;
/*     */   private static POA irPoa;
/*     */   private static HandleDelegate hd;
/*     */   private static int oaSslPort;
/* 102 */   private static boolean sslComponentsEnabledFlag = false;
/*     */ 
/* 113 */   private static boolean sendSasAcceptWithExceptionEnabledFlag = true;
/*     */ 
/* 118 */   private static boolean otsContextPropagationEnabledFlag = false;
/*     */ 
/*     */   public static int getTheActualSSLPort()
/*     */   {
/* 126 */     return oaSslPort;
/*     */   }
/*     */ 
/*     */   public static boolean getSSLComponentsEnabledFlag()
/*     */   {
/* 135 */     return sslComponentsEnabledFlag;
/*     */   }
/*     */ 
/*     */   public static boolean getSendSASAcceptWithExceptionEnabledFlag()
/*     */   {
/* 145 */     return sendSasAcceptWithExceptionEnabledFlag;
/*     */   }
/*     */ 
/*     */   public static boolean getOTSContextPropagationEnabledFlag()
/*     */   {
/* 155 */     return otsContextPropagationEnabledFlag;
/*     */   }
/*     */ 
/*     */   public static POA getOtsPoa()
/*     */   {
/* 164 */     return otsPoa;
/*     */   }
/*     */ 
/*     */   public static POA getOtsResourcePoa()
/*     */   {
/* 176 */     return otsResourcePoa;
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 185 */     Properties props = new Properties();
/*     */ 
/* 188 */     ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 189 */     InputStream is = cl.getResourceAsStream(this.orbPropertiesFileName);
/* 190 */     props.load(is);
/* 191 */     String oaiAddr = props.getProperty("OAIAddr");
/* 192 */     if (oaiAddr == null)
/* 193 */       oaiAddr = ServerConfigUtil.getSpecificBindAddress();
/* 194 */     if (oaiAddr != null)
/* 195 */       props.setProperty("OAIAddr", oaiAddr);
/* 196 */     this.log.debug("Using OAIAddr=" + oaiAddr);
/*     */ 
/* 199 */     Properties systemProps = System.getProperties();
/* 200 */     if (this.orbClass != null) {
/* 201 */       props.put("org.omg.CORBA.ORBClass", this.orbClass);
/* 202 */       systemProps.put("org.omg.CORBA.ORBClass", this.orbClass);
/*     */     }
/* 204 */     if (this.orbSingletonClass != null) {
/* 205 */       props.put("org.omg.CORBA.ORBSingletonClass", this.orbSingletonClass);
/* 206 */       systemProps.put("org.omg.CORBA.ORBSingletonClass", this.orbSingletonClass);
/*     */     }
/* 208 */     if (this.orbSingletonDelegate != null) {
/* 209 */       systemProps.put(ORBSingleton.DELEGATE_CLASS_KEY, this.orbSingletonDelegate);
/*     */     }
/*     */ 
/* 218 */     String str = props.getProperty("jacorb.config.log.verbosity");
/* 219 */     if (str != null) {
/* 220 */       systemProps.put("jacorb.config.log.verbosity", str);
/*     */     }
/*     */ 
/* 223 */     if (this.sunJDK14IsLocalBugFix)
/*     */     {
/*     */       try
/*     */       {
/* 231 */         Class SunJDK14IsLocalBugFix = cl.loadClass("org.jboss.iiop.SunJDK14IsLocalBugFix");
/* 232 */         this.log.debug("Was able to load SunJDK14IsLocalBugFix, class=" + SunJDK14IsLocalBugFix);
/*     */ 
/* 234 */         systemProps.put("javax.rmi.CORBA.UtilClass", "org.jboss.iiop.SunJDK14IsLocalBugFix");
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 238 */         this.log.debug("Ignoring sunJDK14IsLocalBugFix=true due to inability to load org.jboss.iiop.SunJDK14IsLocalBugFix", t);
/*     */       }
/*     */     }
/*     */ 
/* 242 */     System.setProperties(systemProps);
/*     */ 
/* 245 */     Iterator initializerElements = MetaData.getChildrenByTagName(this.portableInterceptorInitializers, "initializer");
/*     */ 
/* 248 */     if (initializerElements != null)
/*     */     {
/* 250 */       while (initializerElements.hasNext())
/*     */       {
/* 252 */         Element initializerElement = (Element)initializerElements.next();
/* 253 */         String portableInterceptorInitializerClassName = MetaData.getElementContent(initializerElement);
/*     */ 
/* 255 */         this.log.debug("Adding portable interceptor initializer: " + portableInterceptorInitializerClassName);
/*     */ 
/* 257 */         if ((portableInterceptorInitializerClassName != null) && (!portableInterceptorInitializerClassName.equals("")))
/*     */         {
/* 259 */           props.put("org.omg.PortableInterceptor.ORBInitializerClass." + portableInterceptorInitializerClassName, "");
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 266 */     if (this.port != 0)
/* 267 */       props.put("OAPort", Integer.toString(this.port));
/* 268 */     if (this.sslPort != 0) {
/* 269 */       props.put("OASSLPort", Integer.toString(this.sslPort));
/*     */     }
/*     */ 
/* 273 */     String oaSslPortString = props.getProperty("OASSLPort");
/* 274 */     if (oaSslPortString != null) {
/* 275 */       oaSslPort = Integer.parseInt(oaSslPortString);
/*     */     }
/*     */ 
/* 278 */     if (this.sslDomain != null)
/*     */     {
/* 280 */       InitialContext ctx = new InitialContext();
/* 281 */       this.log.debug("sslDomain: " + this.sslDomain);
/*     */       try
/*     */       {
/* 284 */         SecurityDomain domain = (SecurityDomain)ctx.lookup(this.sslDomain);
/*     */ 
/* 287 */         Registry.bind(SSL_DOMAIN, domain);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 291 */         this.log.warn("Security domain " + this.sslDomain + " not found");
/* 292 */         this.log.debug("Exception looking up " + this.sslDomain + ": ", e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 297 */     orb = ORB.init(new String[0], props);
/* 298 */     bind(ORB_NAME, "org.omg.CORBA.ORB");
/* 299 */     CorbaORB.setInstance(orb);
/* 300 */     ORBInitialContextFactory.setORB(orb);
/*     */ 
/* 303 */     poa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
/* 304 */     bind(POA_NAME, "org.omg.PortableServer.POA");
/*     */ 
/* 324 */     Policy[] policies = { poa.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), poa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), poa.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), poa.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT), poa.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID) };
/*     */ 
/* 338 */     otsPoa = poa.create_POA("OTS", null, policies);
/*     */ 
/* 344 */     otsResourcePoa = poa.create_POA("OTSResources", otsPoa.the_POAManager(), policies);
/*     */ 
/* 348 */     poa.the_POAManager().activate();
/*     */ 
/* 351 */     new Thread(new Runnable()
/*     */     {
/*     */       public void run() {
/* 354 */         CorbaORBService.orb.run();
/*     */       }
/*     */     }
/*     */     , "ORB thread").start();
/*     */     try
/*     */     {
/* 361 */       LifespanPolicy lifespanPolicy = poa.create_lifespan_policy(LifespanPolicyValue.PERSISTENT);
/*     */ 
/* 363 */       IdAssignmentPolicy idAssignmentPolicy = poa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID);
/*     */ 
/* 366 */       irPoa = poa.create_POA("IR", null, new Policy[] { lifespanPolicy, idAssignmentPolicy });
/*     */ 
/* 369 */       bind(IR_POA_NAME, "org.omg.PortableServer.POA");
/*     */ 
/* 372 */       irPoa.the_POAManager().activate();
/*     */     }
/*     */     catch (Exception ex) {
/* 375 */       getLog().error("Error in IR POA initialization", ex);
/*     */     }
/*     */ 
/* 379 */     hd = new HandleDelegateImpl();
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 396 */       unbind(ORB_NAME);
/* 397 */       unbind(POA_NAME);
/* 398 */       unbind(IR_POA_NAME);
/*     */ 
/* 401 */       orb.shutdown(false);
/*     */ 
/* 404 */       Registry.unbind(SSL_DOMAIN);
/*     */     } catch (Exception e) {
/* 406 */       this.log.error("Exception while stopping ORB service", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public ORB getORB()
/*     */   {
/* 414 */     return orb;
/*     */   }
/*     */ 
/*     */   public HandleDelegate getHandleDelegate()
/*     */   {
/* 419 */     return hd;
/*     */   }
/*     */ 
/*     */   public String getORBClass()
/*     */   {
/* 424 */     return this.orbClass;
/*     */   }
/*     */ 
/*     */   public void setORBClass(String orbClass)
/*     */   {
/* 429 */     this.orbClass = orbClass;
/*     */   }
/*     */ 
/*     */   public String getORBSingletonClass()
/*     */   {
/* 434 */     return this.orbSingletonClass;
/*     */   }
/*     */ 
/*     */   public void setORBSingletonClass(String orbSingletonClass)
/*     */   {
/* 439 */     this.orbSingletonClass = orbSingletonClass;
/*     */   }
/*     */ 
/*     */   public String getORBSingletonDelegate()
/*     */   {
/* 444 */     return this.orbSingletonDelegate;
/*     */   }
/*     */ 
/*     */   public void setORBSingletonDelegate(String orbSingletonDelegate)
/*     */   {
/* 449 */     this.orbSingletonDelegate = orbSingletonDelegate;
/*     */   }
/*     */ 
/*     */   public void setORBPropertiesFileName(String orbPropertiesFileName)
/*     */   {
/* 454 */     this.orbPropertiesFileName = orbPropertiesFileName;
/*     */   }
/*     */ 
/*     */   public String getORBPropertiesFileName()
/*     */   {
/* 459 */     return this.orbPropertiesFileName;
/*     */   }
/*     */ 
/*     */   public Element getPortableInterceptorInitializers()
/*     */   {
/* 464 */     return this.portableInterceptorInitializers;
/*     */   }
/*     */ 
/*     */   public void setPortableInterceptorInitializers(Element portableInterceptorInitializers)
/*     */   {
/* 470 */     this.portableInterceptorInitializers = portableInterceptorInitializers;
/*     */   }
/*     */ 
/*     */   public void setPort(int port)
/*     */   {
/* 475 */     this.port = port;
/*     */   }
/*     */ 
/*     */   public int getPort()
/*     */   {
/* 480 */     return this.port;
/*     */   }
/*     */ 
/*     */   public void setSSLPort(int sslPort)
/*     */   {
/* 485 */     this.sslPort = sslPort;
/*     */   }
/*     */ 
/*     */   public int getSSLPort()
/*     */   {
/* 490 */     return this.sslPort;
/*     */   }
/*     */ 
/*     */   public void setSecurityDomain(String sslDomain)
/*     */   {
/* 495 */     this.sslDomain = sslDomain;
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/* 500 */     return this.sslDomain;
/*     */   }
/*     */ 
/*     */   public boolean getSSLComponentsEnabled()
/*     */   {
/* 505 */     return sslComponentsEnabledFlag;
/*     */   }
/*     */ 
/*     */   public void setSSLComponentsEnabled(boolean sslComponentsEnabled)
/*     */   {
/* 510 */     sslComponentsEnabledFlag = sslComponentsEnabled;
/*     */   }
/*     */ 
/*     */   public boolean getSendSASAcceptWithExceptionEnabled()
/*     */   {
/* 515 */     return sendSasAcceptWithExceptionEnabledFlag;
/*     */   }
/*     */ 
/*     */   public void setSendSASAcceptWithExceptionEnabled(boolean value)
/*     */   {
/* 520 */     sendSasAcceptWithExceptionEnabledFlag = value;
/*     */   }
/*     */ 
/*     */   public boolean getOTSContextPropagationEnabled()
/*     */   {
/* 525 */     return otsContextPropagationEnabledFlag;
/*     */   }
/*     */ 
/*     */   public void setOTSContextPropagationEnabled(boolean value)
/*     */   {
/* 530 */     otsContextPropagationEnabledFlag = value;
/*     */   }
/*     */ 
/*     */   public boolean getSunJDK14IsLocalBugFix()
/*     */   {
/* 535 */     return this.sunJDK14IsLocalBugFix;
/*     */   }
/*     */ 
/*     */   public void setSunJDK14IsLocalBugFix(boolean sunJDK14IsLocalBugFix)
/*     */   {
/* 540 */     this.sunJDK14IsLocalBugFix = sunJDK14IsLocalBugFix;
/*     */   }
/*     */ 
/*     */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment)
/*     */     throws Exception
/*     */   {
/* 549 */     String s = name.toString();
/* 550 */     if (getLog().isTraceEnabled()) {
/* 551 */       getLog().trace("getObjectInstance: obj.getClass().getName=\"" + obj.getClass().getName() + "\n                   name=" + s);
/*     */     }
/*     */ 
/* 554 */     if (ORB_NAME.equals(s))
/* 555 */       return orb;
/* 556 */     if (POA_NAME.equals(s))
/* 557 */       return poa;
/* 558 */     if (IR_POA_NAME.equals(s))
/* 559 */       return irPoa;
/* 560 */     return null;
/*     */   }
/*     */ 
/*     */   private void bind(String name, String className)
/*     */     throws Exception
/*     */   {
/* 569 */     Reference ref = new Reference(className, getClass().getName(), null);
/* 570 */     new InitialContext().bind("java:/" + name, ref);
/*     */   }
/*     */ 
/*     */   private void unbind(String name)
/*     */     throws Exception
/*     */   {
/* 576 */     new InitialContext().unbind("java:/" + name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.CorbaORBService
 * JD-Core Version:    0.6.0
 */