/*     */ package org.jboss.iiop;
/*     */ 
/*     */ import java.util.Hashtable;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ import org.apache.avalon.framework.configuration.Configuration;
/*     */ import org.jacorb.naming.NamingContextImpl;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.omg.CORBA.Policy;
/*     */ import org.omg.CosNaming.Binding;
/*     */ import org.omg.CosNaming.BindingHolder;
/*     */ import org.omg.CosNaming.BindingIterator;
/*     */ import org.omg.CosNaming.BindingIteratorHolder;
/*     */ import org.omg.CosNaming.BindingListHolder;
/*     */ import org.omg.CosNaming.BindingType;
/*     */ import org.omg.CosNaming.NameComponent;
/*     */ import org.omg.CosNaming.NamingContext;
/*     */ import org.omg.CosNaming.NamingContextExt;
/*     */ import org.omg.CosNaming.NamingContextExtHelper;
/*     */ import org.omg.CosNaming.NamingContextHelper;
/*     */ import org.omg.PortableServer.IdAssignmentPolicyValue;
/*     */ import org.omg.PortableServer.LifespanPolicyValue;
/*     */ import org.omg.PortableServer.POA;
/*     */ import org.omg.PortableServer.POAManager;
/*     */ 
/*     */ public class CorbaNamingService extends ServiceMBeanSupport
/*     */   implements CorbaNamingServiceMBean, ObjectFactory
/*     */ {
/*  63 */   public static String NAMING_NAME = "JBossCorbaNaming";
/*     */   private POA namingPOA;
/*     */   private static NamingContextExt namingService;
/*     */ 
/*     */   public String list()
/*     */   {
/*  81 */     StringBuffer buf = new StringBuffer();
/*  82 */     rlist(namingService, new NameComponent[0], buf);
/*  83 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/*     */     Context ctx;
/*     */     try
/*     */     {
/*  96 */       ctx = new InitialContext();
/*     */     }
/*     */     catch (NamingException e) {
/*  99 */       throw new RuntimeException("Cannot get intial JNDI context: " + e);
/*     */     }org.omg.CORBA.ORB orb;
/*     */     try { orb = (org.omg.CORBA.ORB)ctx.lookup("java:/" + CorbaORBService.ORB_NAME);
/*     */     } catch (NamingException e)
/*     */     {
/* 105 */       throw new RuntimeException("Cannot lookup java:/" + CorbaORBService.ORB_NAME + ": " + e);
/*     */     }POA rootPOA;
/*     */     try {
/* 109 */       rootPOA = (POA)ctx.lookup("java:/" + CorbaORBService.POA_NAME);
/*     */     }
/*     */     catch (NamingException e) {
/* 112 */       throw new RuntimeException("Cannot lookup java:/" + CorbaORBService.POA_NAME + ": " + e);
/*     */     }
/*     */ 
/* 117 */     Policy[] policies = new Policy[2];
/* 118 */     policies[0] = rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID);
/*     */ 
/* 120 */     policies[1] = rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT);
/*     */ 
/* 122 */     this.namingPOA = rootPOA.create_POA("Naming", null, policies);
/* 123 */     this.namingPOA.the_POAManager().activate();
/*     */ 
/* 126 */     NamingContextImpl.init(orb, rootPOA);
/* 127 */     NamingContextImpl ns = new NamingContextImpl(this.namingPOA);
/* 128 */     Configuration config = ((org.jacorb.orb.ORB)orb).getConfiguration();
/* 129 */     ns.configure(config);
/* 130 */     byte[] rootContextId = "root".getBytes();
/* 131 */     this.namingPOA.activate_object_with_id(rootContextId, ns);
/* 132 */     namingService = NamingContextExtHelper.narrow(this.namingPOA.create_reference_with_id(rootContextId, "IDL:omg.org/CosNaming/NamingContextExt:1.0"));
/*     */ 
/* 135 */     bind(NAMING_NAME, "org.omg.CosNaming.NamingContextExt");
/* 136 */     getLog().info("CORBA Naming Started");
/* 137 */     getLog().debug("Naming: [" + orb.object_to_string(namingService) + "]");
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */   {
/*     */     try
/*     */     {
/* 144 */       unbind(NAMING_NAME);
/*     */     } catch (Exception e) {
/* 146 */       this.log.error("Exception while stopping CORBA naming service", e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 151 */       this.namingPOA.destroy(false, false);
/*     */     } catch (Exception e) {
/* 153 */       this.log.error("Exception while stopping CORBA naming service", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment)
/*     */     throws Exception
/*     */   {
/* 163 */     String s = name.toString();
/* 164 */     if (getLog().isTraceEnabled()) {
/* 165 */       getLog().trace("getObjectInstance: obj.getClass().getName=\"" + obj.getClass().getName() + "\n                   name=" + s);
/*     */     }
/*     */ 
/* 168 */     if (NAMING_NAME.equals(s)) {
/* 169 */       return namingService;
/*     */     }
/* 171 */     return null;
/*     */   }
/*     */ 
/*     */   private void bind(String name, String className)
/*     */     throws Exception
/*     */   {
/* 179 */     Reference ref = new Reference(className, getClass().getName(), null);
/* 180 */     new InitialContext().bind("java:/" + name, ref);
/*     */   }
/*     */ 
/*     */   private void unbind(String name)
/*     */     throws Exception
/*     */   {
/* 186 */     new InitialContext().unbind("java:/" + name);
/*     */   }
/*     */ 
/*     */   private static void rlist(NamingContext ctx, NameComponent[] base, StringBuffer buf)
/*     */   {
/* 192 */     BindingListHolder listHolder = new BindingListHolder(new Binding[0]);
/* 193 */     BindingIteratorHolder iterHolder = new BindingIteratorHolder();
/* 194 */     ctx.list(0, listHolder, iterHolder);
/* 195 */     BindingHolder bindingHolder = new BindingHolder();
/*     */ 
/* 197 */     if (iterHolder.value == null) {
/* 198 */       return;
/*     */     }
/* 200 */     NameComponent[] name = new NameComponent[base.length + 1];
/* 201 */     for (int i = 0; i < base.length; i++) {
/* 202 */       name[i] = base[i];
/*     */     }
/* 204 */     while (iterHolder.value.next_one(bindingHolder))
/*     */     {
/* 206 */       Binding binding = bindingHolder.value;
/* 207 */       name[(name.length - 1)] = binding.binding_name[0];
/*     */       try
/*     */       {
/* 210 */         String stringName = namingService.to_string(name);
/* 211 */         buf.append(stringName);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 215 */         buf.append(e.getMessage());
/*     */       }
/*     */ 
/* 218 */       if (binding.binding_type.value() == 1)
/*     */       {
/* 223 */         buf.append('/');
/* 224 */         buf.append('\n');
/*     */         try
/*     */         {
/* 229 */           NamingContext subCtx = NamingContextHelper.narrow(ctx.resolve(binding.binding_name));
/*     */ 
/* 231 */           rlist(subCtx, name, buf);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 235 */           buf.append(e.getMessage());
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 240 */         buf.append('\n');
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static class NamingContextImpl extends NamingContextImpl
/*     */   {
/*     */     private POA poa;
/* 260 */     private int childCount = 0;
/* 261 */     private static final Logger logger = Logger.getLogger(NamingContextImpl.class);
/*     */ 
/*     */     NamingContextImpl(POA poa)
/*     */     {
/* 266 */       this.poa = poa;
/*     */     }
/*     */ 
/*     */     public NamingContext new_context()
/*     */     {
/*     */       try {
/* 272 */         NamingContextImpl newContextImpl = new NamingContextImpl(this.poa);
/* 273 */         byte[] oid = (new String(this.poa.servant_to_id(this)) + "/ctx" + ++this.childCount).getBytes();
/*     */ 
/* 275 */         this.poa.activate_object_with_id(oid, newContextImpl);
/* 276 */         return NamingContextExtHelper.narrow(this.poa.create_reference_with_id(oid, "IDL:omg.org/CosNaming/NamingContextExt:1.0"));
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 281 */         logger.error("Cannot create CORBA naming context", e);
/* 282 */       }return null;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.CorbaNamingService
 * JD-Core Version:    0.6.0
 */