/*    */ package org.jboss.ejb3.tx;
/*    */ 
/*    */ import javax.ejb.ApplicationException;
/*    */ import javax.ejb.TransactionManagement;
/*    */ import javax.ejb.TransactionManagementType;
/*    */ import javax.naming.InitialContext;
/*    */ import javax.naming.NamingException;
/*    */ import javax.transaction.TransactionManager;
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.aop.joinpoint.MethodInvocation;
/*    */ import org.jboss.ejb.ApplicationExceptionImpl;
/*    */ import org.jboss.ejb3.EJBContainer;
/*    */ import org.jboss.ejb3.InitialContextFactory;
/*    */ import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
/*    */ import org.jboss.metadata.ejb.spec.ApplicationExceptionMetaData;
/*    */ import org.jboss.metadata.ejb.spec.ApplicationExceptionsMetaData;
/*    */ import org.jboss.tm.TransactionManagerLocator;
/*    */ 
/*    */ public class TxUtil
/*    */ {
/*    */   public static TransactionManager getTransactionManager()
/*    */     throws RuntimeException
/*    */   {
/*    */     try
/*    */     {
/* 55 */       InitialContext jndiContext = InitialContextFactory.getInitialContext();
/* 56 */       TransactionManager tm = TransactionManagerLocator.getInstance().locate();
/* 57 */       return tm;
/*    */     }
/*    */     catch (NamingException e) {
/*    */     }
/* 61 */     throw new RuntimeException("Unable to lookup TransactionManager", e);
/*    */   }
/*    */ 
/*    */   public static TransactionManagementType getTransactionManagementType(Advisor c)
/*    */   {
/* 67 */     TransactionManagement transactionManagement = (TransactionManagement)c.resolveAnnotation(TransactionManagement.class);
/* 68 */     if (transactionManagement == null) return TransactionManagementType.CONTAINER;
/* 69 */     return transactionManagement.value();
/*    */   }
/*    */ 
/*    */   public static ApplicationException getApplicationException(Class<?> exceptionClass, Invocation invocation)
/*    */   {
/* 74 */     MethodInvocation ejb = (MethodInvocation)invocation;
/* 75 */     EJBContainer container = (EJBContainer)ejb.getAdvisor();
/*    */ 
/* 79 */     if (exceptionClass.isAnnotationPresent(ApplicationException.class)) {
/* 80 */       return (ApplicationException)exceptionClass.getAnnotation(ApplicationException.class);
/*    */     }
/* 82 */     JBossAssemblyDescriptorMetaData assembly = container.getAssemblyDescriptor();
/*    */ 
/* 84 */     if (assembly != null)
/*    */     {
/* 86 */       ApplicationExceptionsMetaData exceptions = assembly.getApplicationExceptions();
/* 87 */       if (exceptions != null)
/*    */       {
/* 89 */         for (ApplicationExceptionMetaData exception : exceptions)
/*    */         {
/* 91 */           if (exception.getExceptionClass().equals(exceptionClass.getName())) {
/* 92 */             return new ApplicationExceptionImpl(exception.isRollback());
/*    */           }
/*    */         }
/*    */       }
/*    */     }
/* 97 */     return null;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.tx.TxUtil
 * JD-Core Version:    0.6.0
 */